<?php
/**
 * @copyright &copy; 2000-2003 Simon Annetts <simon@ateb.co.uk>
 * @copyright &copy; 2006-2007 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: setup.php,v 1.7 2007/01/20 11:51:22 tokul Exp $
 * @package plugins
 * @subpackage change_ldappass
 */

/**
 * Init function
 */
function squirrelmail_plugin_init_change_ldappass() {
  global $squirrelmail_plugin_hooks;
  global $mailbox, $imap_stream, $imapConnection;
  $squirrelmail_plugin_hooks['optpage_register_block']['change_ldappass'] = 'change_ldappass_opt';

}

/**
 * Adds option block
 */
function change_ldappass_opt() {
  bindtextdomain('change_ldappass', SM_PATH . 'plugins/change_ldappass/locale');
  textdomain('change_ldappass');
  global $optpage_blocks;
    $optpage_blocks[] =
       array(
             'name' => _("Change Password"),
             'url'  => '../plugins/change_ldappass/options.php',
             'desc' => _("This connects to your local Password Server to change your login password for all services."));
  bindtextdomain('squirrelmail', SM_PATH . 'locale');
  textdomain('squirrelmail');
}

/**
 * Returns version string.
 * @return string version number
 */
function change_ldappass_version() {
  return '2.1';
}
