<?php
// Change_ldappass 1.6 (July 26, 2003)
//  
// Copyright Simon Annetts 2000 - 2003. simon@ateb.co.uk 
// PLEASE SEND QUESTIONS COMMENTS AND CHANGES TO MAINTAINOR.
// Maintainor: Raymond Ferguson foo@share-foo.com
// 
// This software may be used, modified and distributed freely
// providing this copyright notice remains intact at the head 
// of the file.
//
// This software is freeware. The author accepts no liability for
// any loss or damages whatsoever incurred directly or indirectly 
// from the use of this script. The author of this software makes 
// no claims as to its fitness for any purpose whatsoever. If you 
// wish to use this software you should first satisfy yourself that 
// it meets your requirements.
//
// Email: foo@share-foo.com (Ray Ferguson, Maintainor)
//
// Portions of code, ideas, suggestions and bug fixes have been posted by:
//
// Simon Annetts (Original Author)
// Matt Butcher
// Henrique de Moraes Holschuh
// David Hall
// Martin Bartosch
// Artemios G. Voyiatzis
// Todd Lyons
// Greg Schueler 
// Beat
// Georg Lehner 
// Ray Ferguson
// Maciej Skalski
// Marcio Merlone 
// Fernando Maior
// 
// Apologies if I've missed anyone :-)
   chdir ("..");
   define('SM_PATH','../');

// include compatibility plugin
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');

if (compatibility_check_sm_version(1, 3)) {
   if (!isset($config_php))
      include_once (SM_PATH . "config/config.php");
   include_once(SM_PATH . 'include/validate.php');
   if (!isset($strings_php))
      include_once (SM_PATH . "functions/strings.php");
   if (!isset($page_header))
      include_once (SM_PATH . "functions/page_header.php");
   if (!isset($imap_php))
      include_once (SM_PATH . "functions/imap.php");
   include_once (SM_PATH . "include/load_prefs.php");
} else {
   //session_start(); 
   include_once("../src/validate.php");
   if (!isset($config_php))
      include_once ("../config/config.php");
   if (!isset($strings_php))
      include_once ("../functions/strings.php");
   if (!isset($page_header))
      include_once ("../functions/page_header.php");
   if (!isset($imap_php))
      include_once ("../functions/imap.php");
   include_once ("../src/load_prefs.php");
}

function do_international() {
   bindtextdomain('change_ldappass', '../plugins/change_ldappass/locale');
   textdomain('change_ldappass');
}

function undo_international() {
    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');
}

   if (isset($_POST['plugin_change_ldappass'])) $Messages = change_ldappass_check();
   displayPageHeader($color, "None");

do_international();
?>

<br>
<table width=95% align=center cellpadding=2 cellspacing=2 border=0>
<tr><td bgcolor="<?php echo $color[0] ?>">
   <center><b><?php echo _("Change Password") ?></b></center>
</td><?php

if (isset($Messages) && count($Messages)) {
    echo "<tr><td>\n";
    foreach ($Messages as $line) {
        echo $line . "<br>\n";
    }
    echo "</td></tr>\n";
}

?><tr><td>
    <form method=post action="<?php print $_SERVER['PHP_SELF'] ?>">
    <table>
      <tr>
        <th align=right><?php echo _("Old Password:")?></th>
        <td><input type=password name=cp_oldpass value=""  size=20></td>
      </tr>
      <tr>
        <th align=right><?php echo _("New Password:")?></th>
        <td><input type=password name=cp_newpass value="" size=20></td>
      </tr>
      <tr>
        <th align=right><?php echo _("Verify New Password:")?></th>
        <td><input type=password name=cp_verify value="" size=20></td>
      </tr>
      <tr>
        <td align=center colspan=2><input type=submit value="<?php echo _("Change Password") ?>" name="plugin_change_ldappass"></td>
      </tr>
    </table>
</td></tr>
</tr></table>
</body></html>
<?php undo_international(); ?>
<?php

function change_ldappass_check($debug = 0) {
	$cp_oldpass = $_POST['cp_oldpass'];
	$cp_newpass = $_POST['cp_newpass'];
	$cp_verify = $_POST['cp_verify'];
	$plugin_change_ldappass = $_POST['plugin_change_ldappass'];
	$username = $_SESSION['username'];

	$Messages = array();
	do_international();
	if ($cp_oldpass == "")	array_push($Messages, _("You must type in your old password."));
	if ($cp_newpass == "") array_push($Messages, _("You must type in a new password."));
	if ($cp_verify == "") array_push($Messages, _("You must also type in your new password in the verify box."));
	if ($cp_newpass != "" && $cp_verify != $cp_newpass) array_push($Messages, _("Your new password doesn't match the verify password."));
	if (!preg_match("/^[A-Za-z0-9\\%\^\*\(\)\-\_\+\=\[\]\{\}\:\@\#\~\,\.\? ]+$/",$cp_newpass)) array_push($Messages,'Passwords can only contain the following characters:<br>A-Z, a-z, 0-9, %^*()-_+=[]{}:@#~,.?');
        undo_international();
	if (count($Messages)) return $Messages;
	return change_ldappass_go($debug);
}


function change_ldappass_go($debug) {
		$username = $_SESSION['username'];
		$base_uri = $_SESSION['base_uri'];
		$cp_oldpass = $_POST['cp_oldpass'];
		$cp_newpass = $_POST['cp_newpass'];

		include_once("../plugins/change_ldappass/config.php");
    $Messages = array();
    do_international(); 
    if ($debug) array_push($Messages, _("Connecting to LDAP Server"));

 		$ds=ldap_connect($ldap_server);
 		if (! $ds) {
			array_push($Messages, _("Can't connect to Directory Server, please try later!"));
	 		return $Messages;
 		}
		if ($ldap_bind_as_manager) {
			if (! @ldap_bind($ds,$ldap_manager_dn,$ldap_manager_pw)) {
				array_push($Messages, _("Could not bind to the LDAP server as $ldap_manager_dn. Is the password correct?"));
				return $Messages;
			} else {
				if ($debug) array_push($Messages, _("Bind to database as $ldap_manager_dn successful."));
			}				
		} else {
			// first bind anonymously and try to determine the correct dn for the user with uid=$username
			$r=ldap_bind($ds,"","");
		}
		$sr=ldap_search($ds,$ldap_base_dn,"($ldap_user_field=$username)",array("dn")); //search for uid
		if (ldap_count_entries($ds,$sr)>1) {
			array_push($Messages, _("Duplicate login entries detected, cannot change password!"));
			return $Messages;
		}
		if (ldap_count_entries($ds,$sr)==0) {
			array_push($Messages, _("Your login account was not found in the LDAP database, cannot change password!"));
			return $Messages;
		}
		$info=ldap_get_entries($ds,$sr);
		if ($debug) array_push($Messages,ldap_debug_print_array($info));
		$dn=$info[0]["dn"]; //finally get the full users dn
		
		// now rebind the the database as user or as root if required
		if (! $ldap_bind_as_manager) {
			if (! @ldap_bind($ds,$dn,$cp_oldpass)) { //if we can't bind as the user then the old passwd must be wrong
				array_push($Messages, _("Your old password is not correct."));
				return $Messages;
			} else {
				if ($debug) array_push($Messages, _("Bind to database as $dn successful."));	
			}
		}
		$sr=ldap_search($ds,$ldap_base_dn,"($ldap_user_field=$username)"); //check the db again, this time so we get the password field returned
		$info = ldap_get_entries($ds, $sr);
		if ($debug) array_push($Messages,ldap_debug_print_array($info));
		$storedpass=$info[0][$ldap_password_field][0];
		if (!isset($storedpass)) {
		         array_push($Messages, _("We could not retrieve your old password from the LDAP server."));
		         return $Messages;
		}
		
		//this next code tries to identify the correct password type
		//*Note* I've not tested all types here as I cannot reproduce some setups
		//Please let me know if the code does not work for you, or if you have code that will work
		//for a particular type.
		
		//password types:
		//{crypt} salted passwords of type DES, MD5 and Blowfish
		//{MD5} unsalted password in MD5 format
		//{SHA} unsalted password in SHA format
		//{SMD5} salted md5
		//{SSHA} salted sha
		
		//lets try to determine the encrytion method of the stored password
		$p=split("}",$storedpass); 					//split the password
		$ctype=strtolower($p[0]); //into the {crypttype}
		$lpass=$p[1];												//and the password
		//if the stored password is {crypt} then its salted, but which sub-type?
		switch ($ctype) {
			case "{crypt":
				$pl=strlen($lpass); 			// We'll look at the length and salt of what's already stored to determine the crypt sub-type
				$stype="DES";		 						//sensible default if not detected
				if ($pl>=34 and substr($lpass,0,3)=="$1$") $stype="MD5"; 
				if ($pl>=34 and substr($lpass,0,3)=="$2$") $stype="BLOWFISH";	
				if ($debug) array_push($Messages, _("Password type is {crypt}, sub-type $stype"));
				$cpass=ldap_crypt_passwd($cp_oldpass,$lpass,$stype); //crypt up our old password so we can check it again
				break;
			case "{md5":
				if ($debug) array_push($Messages, _("Password type is {MD5}"));
				$cpass=ldap_md5_passwd($cp_oldpass);
				break;
			case "{sha":
				if ($debug) array_push($Messages, _("Password type is {SHA}"));
				$cpass=ldap_sha_passwd($cp_oldpass);
				break;
			case "{smd5":
				if ($debug) array_push($Messages, _("Password type is {SMD5}"));
				$hash = base64_decode($lpass) ;
				$salt = substr($hash, 16);
				$cpass = base64_encode(pack("H*", md5($cp_oldpass . $salt)).$salt);
				break;
			case "{ssha":
				if ($debug) array_push($Messages, _("Password type is {SSHA}"));
				$hash = base64_decode($lpass) ;
				$salt = substr($hash, 20);
				$cpass=ldap_ssha_passwd($cp_oldpass,$salt);
				break;
      default:                        // Use plain text password
        $cpass=$cp_oldpass;
        $lpass=$storedpass;     // Override $lpass as it is truncated from the original
        break;
		}	
		//now check again the stored password against the encrypted version of the supplied old password
		if ($lpass != $cpass) {
			array_push($Messages, _("Your old password is not correct."));
			if ($debug) array_push($Messages, _("Stored Password: $lpass  Old Password: $cpass"));
			return $Messages;
		}
		//Make sure the new passwd generation uses the encryption method of the previous password
		switch ($ctype) {
			case "{crypt":		
				$newpass="{crypt}".ldap_crypt_passwd($cp_newpass,ldap_generate_salt($stype),$stype);
				break;
			case "{md5":
				$newpass="{MD5}".ldap_md5_passwd($cp_newpass);
				break;
			case "{sha":
				$newpass="{SHA}".ldap_sha_passwd($cp_newpass);
				break;			
			case "{smd5":
				$newpass="{SMD5}".ldap_smd5_passwd($cp_newpass);
				break;
			case "{ssha":
				@ $newpass="{SSHA}".ldap_ssha_passwd($cp_newpass);
				break;
				
			// more password types should go here ;-) and the functions to drive them below.
	    default:                        // Use plain text password
      	$newpass=$cp_newpass;
        break;
		}
		if ($debug) array_push($Messages, _("New Password: $newpass"));
		$newinfo=array();
		$newinfo[$ldap_password_field][0]=$newpass;
		if ($change_ldapsmb) {
			$exe = "$mkntpwd " . escapeshellarg($newpass) . " 2>&1" ;
			if ($debug) array_push($Messages,$exe);
			$ntString = exec ($exe, $retarray, $retval);
			if ($debug) $Messages = array_merge($Messages,$retarray);
			if ( $retval == "0" && preg_match("/^[0-9A-F]+:[0-9A-F]+$/",$ntString )) {
				list($lmPassword, $ntPassword) = explode (":", $ntString);
				$newinfo["ntPassword"] = $ntPassword;
				$newinfo["lmPassword"] = $lmPassword;
			} else {  //smbpasswd change failed so we must re sync the ldap password back to its original
				array_push($Messages, _("SMB Password change was not successful, so LDAP not changed!"));
				return $Messages;
			}
		}
		if (@ldap_modify($ds,$dn,$newinfo)) {
			$smb=0;
			if ($change_smb) {
				$exe="echo " . escapeshellarg($cp_oldpass)  
				       .  " |$smb_passwd -U " . escapeshellarg($username) 
				       . " -s " . escapeshellarg($cp_newpass) . " 2>&1" ;
				if ($debug) array_push($Messages,$exe);
				$r=exec($exe,$s);
				if ($r==_("Password changed for user $username")) $smb=1 ;
			} else {
				$smb=1;
			}
			if ($debug) array_push($Messages, $r);			
			if ($smb) {
				// Write new cookies for the password
				$onetimepad = OneTimePadCreate(strlen($cp_newpass));
				$_SESSION['onetimepad']=$onetimepad; //do I need to do this now?
				$key = OneTimePadEncrypt($cp_newpass, $onetimepad);
				$_COOKIES['key']=$key;
				setcookie("key", $key, 0, $base_uri);
				// Give feedback if password change was successful.
				if ($debug == 0) {
                                        array_push($Messages, _("Password changed successfully"));
                                        return $Messages ;
					exit(0);
				}
				return $Messages;
			} else { //smbpasswd change failed so we must re sync the ldap password back to its original
				$newinfo[$ldap_password_field][0]=$storedpass;
				$r=ldap_modify($ds,$dn,$newinfo);  //change it back so  they're not out of sync.
				array_push($Messages, _("SMB Password change was not successful, so LDAP not changed!"));
				return $Messages;
			}
		} else {
			array_push($Messages, _("LDAP Password change was not successful!"));
			if ($debug) array_push($Messages, _("LDAP ERROR => " . ldap_error($ds))) ;
			return $Messages;
		}
		@ldap_close($ds);
		undo_international();
}

// Generate an unsalted SHA1 pw. This should work withNetscape messaging / directory server 4+ 
function ldap_sha_passwd($clear_pw) {
        if(function_exists('sha1')) {
		$hash = pack("H*",sha1($clear_pw));
        } else if (function_exists('mHash')) {
		$hash = mHash(MHASH_SHA1, $clear_pw);
        } else {
		echo "Error: You will need php >= 4.3.0 or php compiled with MHASH if you are going to use SHA or SSHA passwords.";
		exit();
	}
	return base64_encode($hash);
}

// Generate a salted SHA1 pw.
function ldap_ssha_passwd($clear_pw,$salt) {
	if (!isset($salt)){
	        // set seed for the random number generator
       		mt_srand((double)microtime()*1000000);
		$salt = substr(md5(mt_rand()), 4, 8);
	}
        if(function_exists('sha1')) {
		$hash = pack("H*",sha1($clear_pw . $salt));
        } else if (function_exists('mHash')) {
		$hash = mHash(MHASH_SHA1, $clear_pw . $salt);
        } else {
		echo "Error: You will need php >= 4.3.0 or php compiled with MHASH if you are going to use SHA or SSHA passwords.";
		exit();
	}
	return base64_encode($hash . $salt);
}

// Generate an unsalted MD5 pw. This works fine with OpenLDAP.
function ldap_md5_passwd($clear_pw) {
	return base64_encode(pack("H*", md5($clear_pw)));	
}

function ldap_smd5_passwd($clear_pw) {
	 $salt = myhash_keyge_s2k($clear_pw, 4);
	 $new_password = base64_encode(pack("H*", md5($clear_pw . $salt)) . $salt);
	 return $new_password ;
}

// Generate salted crypt passwords
function ldap_crypt_passwd($password,$salt,$stype) {
	if ($stype=="MD5") 	return crypt($password,substr($salt,0,12)); 						//MD5 uses 12 chr salt
	if ($stype=="BLOWFISH") 	return crypt($password,substr($salt,0,16)); //BLOWFISH uses 16 chr salt
	if ($stype=="DES")  return crypt($password,substr($salt,0,2)); 							//crypt uses 2 chr salt
}

function ldap_generate_salt($stype) {
  $salt="";	//generate a salt using characters [A-Z][a-z][0-9]./
  $chars="./0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	for ($i=0;$i<16;$i++) {
		$salt.=$chars[mt_rand(0,strlen($chars))];
	}
	//return salts longer than we need but these will be trimmed in the ldap_crypt_passwd function
	if ($stype=="MD5") return "$1$".$salt;
	if ($stype=="BLOWFISH") return "$2$".$salt;
	if ($stype=="DES")	return $salt;
}

function myhash_keyge_s2k($pass, $bytes ){
	// This and md5 implimentation of the Salted S2K algorithm as 
	// specified in the OpenPGP document (RFC 2440).
	// basically a non mhash dependant version of mhash_keygen_s2k
	$salt=substr(pack("h*", md5(mt_rand())), 0, 8);
	return substr(pack("H*", md5($salt . $pass)), 0, $bytes);
}

function ldap_debug_print_array($array) {
	$out="<br>--------------------------------------------------------<br>\n";
  $out.=ldap_debug_print_array1($array,"");
	$out.= "<br>--------------------------------------------------------<br>\n";
	return $out;
}

function ldap_debug_print_array1($array,$out) {
	if(gettype($array)=="array") {
		$out.="<ul>";
		while (list($index, $subarray) = each($array) ) {
			$out.="<li>$index <code>=&gt;</code>";
			$out=ldap_debug_print_array1($subarray,$out);
			$out.="</li>";
		}
		$out.="</ul>";
	} else $out.="$array";
	return $out;
}
?>
