<?php

/**
  * SquirrelMail CAPTCHA Plugin
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage captcha
  *
  */



/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function captcha_init()
{

   global $captcha_backend;


   if (!@include_once(SM_PATH . 'plugins/captcha/config.php'))
      return FALSE;


   // if the backend has a separate configuration file 
   // to load, include it too
   //
   if (!@include_once(SM_PATH . 'plugins/captcha/backends/' 
                              . $captcha_backend . '/' 
                              . $captcha_backend . '_config.php'))
      @include_once(SM_PATH . 'plugins/captcha/backends/' 
                            . $captcha_backend . '/' 
                            . $captcha_backend . '_config.sample.php');

   return TRUE;

}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function captcha_check_configuration_do()
{

   global $captcha_backend;


   // make sure base config is available
   //
   if (!captcha_init())
   {
      do_err('CAPTCHA plugin is missing its main configuration file', FALSE);
      return TRUE;
   }



   // make sure correct backend files/functions are present
   //
   if (empty($captcha_backend))
   {
      do_err('CAPTCHA plugin backend is not configured', FALSE);
      return TRUE;
   }
   if (!@is_dir(SM_PATH . 'plugins/captcha/backends/' . $captcha_backend))
   {
      do_err('CAPTCHA plugin backend "' . $captcha_backend . '" is missing', FALSE);
      return TRUE;
   }
   if (!@include_once(SM_PATH . 'plugins/captcha/backends/' 
                              . $captcha_backend . '/' . $captcha_backend . '.php'))
   {
      do_err('CAPTCHA plugin backend "' . $captcha_backend . '" is incomplete', FALSE);
      return TRUE;
   }
   if (!function_exists($captcha_backend . '_show_input_widgets')
    || !function_exists($captcha_backend . '_validate_captcha'))
   {
      do_err('CAPTCHA plugin backend "' . $captcha_backend . '" is incomplete', FALSE);
      return TRUE;
   }



   // only need to do this pre-1.5.2, as 1.5.2 will make this
   // check for us automatically
   //
   if (!check_sm_version(1, 5, 2))
   {

      // 1.4.10+ gets a pass on Compatibility plugin
      //
      if (check_sm_version(1, 5, 0) || !check_sm_version(1, 4, 10))
      {

         // try to find Compatibility, and then that it is v2.0.7+
         //
         if (function_exists('check_plugin_version')
          && check_plugin_version('compatibility', 2, 0, 7, TRUE))
            return FALSE;


         // something went wrong
         //
         do_err('CAPTCHA plugin requires the Compatibility plugin version 2.0.7+', FALSE);
         return TRUE;

      }

   }



   // if the backend has a configtest to add, call it here
   //
   if (function_exists($captcha_backend . '_check_configuration'))
   {
      $function = $captcha_backend . '_check_configuration';
      return $function();
   }

}



/**
  * Show captcha inputs on login page
  *
  */
function captcha_show_input_widgets_do()
{

   global $captcha_backend;
   captcha_init();


   // call correct captcha backend 
   //
   include_once(SM_PATH . 'plugins/captcha/backends/' 
                        . $captcha_backend . '/' . $captcha_backend . '.php');
   $function = $captcha_backend . '_show_input_widgets';
   $output = $function();
   

   // depending on SM version, either return or display output
   //
   if (check_sm_version(1, 5, 2))
      return array('login_form' => $output);
   else if (check_sm_version(1, 5, 1))
      return $output;
   else
      echo $output;

}



/**
  * Validate that correct captcha was sent
  *
  */
function captcha_validate_do()
{

   global $captcha_backend, $log_CAPTCHA_events;
   captcha_init();


   // call correct captcha backend 
   //
   include_once(SM_PATH . 'plugins/captcha/backends/' 
                        . $captcha_backend . '/' . $captcha_backend . '.php');
   $function = $captcha_backend . '_validate_captcha';
   $validated = $function();


   // only needed for logging
   //
   if ($log_CAPTCHA_events && is_plugin_enabled('squirrel_logger'))
   {
      include_once(SM_PATH . 'plugins/squirrel_logger/functions.php');

      // what username did the user submit
      //
      global $login_username, $$login_username;
      $user = trim($login_username);


      // if password_forget is loaded, use the obfuscated name
      //
      if (is_plugin_enabled('password_forget'))
      {
         if (!isset($$login_username))
            sqgetGlobalVar($login_username, $$login_username, SQ_FORM);
         if ($$login_username != '')
           $user = trim($$login_username);
      }
   }


   // did the user fail to enter the right response?
   //
   if (!$validated)
   {

      // for now, we'll take care of the error message, although
      // some captcha backends may have slightly different ones
      // of their own
      //
      sq_change_text_domain('captcha');
      $error_msg = _("Sorry, you did not provide the correct challenge response.");
      sq_change_text_domain('squirrelmail');


      // log CAPTCHA results - note that to use this,
      // you'll need to have the Squirrel Logger plugin
      // installed and activated and you'll have to add
      // a "CAPTCHA" event type to its configuration
      //
      if ($log_CAPTCHA_events && is_plugin_enabled('squirrel_logger'))
      {
         sl_logit('CAPTCHA', 'Wrong CAPTCHA (backend ' . $captcha_backend . ')', $user);
      }


      logout_error($error_msg);
      exit;
   }
   else
   {
      // log CAPTCHA results - note that to use this,
      // you'll need to have the Squirrel Logger plugin
      // installed and activated and you'll have to add
      // a "CAPTCHA" event type to its configuration
      //
      if ($log_CAPTCHA_events && is_plugin_enabled('squirrel_logger'))
      {
         sl_logit('CAPTCHA', 'Correct CAPTCHA (backend ' . $captcha_backend . ')', $user);
      }
   }

}



