<?php

   if (file_exists('../../../../functions/global.php'))
   {
      define('SM_PATH', '../../../../');
      include_once(SM_PATH . 'functions/global.php');
   }
   else exit;


/*
 * PHP Captcha 1.0
 * Copyright (C) 2007 Kerem Erkan <kerem@keremerkan.net>
 *
 * Please see README for installation and usage instructions.
 * Do not edit this file unless you know what you are doing!
*/

//require_once("config.php");
if (!@include_once(SM_PATH . 'plugins/captcha/backends/phpcaptcha/phpcaptcha_config.php'))
   include_once(SM_PATH . 'plugins/captcha/backends/phpcaptcha/phpcaptcha_config.sample.php');
require_once("functions.php");

//@session_start();

// need to correctly initiate session before we can put anything in it;
// for SquirrelMail 1.5.2+.... ugh... copied code from include/init.php

/**
 * calculate SM_PATH and calculate the base_uri
 * assumptions made: init.php is only called from plugins or from the src dir.
 * files in the plugin directory may not be part of a subdirectory called "src"
 *
 */
if (isset($_SERVER['SCRIPT_NAME'])) {
    $a = explode('/',$_SERVER['SCRIPT_NAME']);
} elseif (isset($HTTP_SERVER_VARS['SCRIPT_NAME'])) {
    $a = explode('/',$HTTP_SERVER_VARS['SCRIPT_NAME']);
} else {
    $error = 'Unable to detect script environment. '
        .'Please test your PHP settings and send PHP core config, $_SERVER '
        .'and $HTTP_SERVER_VARS to SquirrelMail developers.';
    die($error);
}
$sSM_PATH = '';
for($i = count($a) -2;$i > -1; --$i) {
    $sSM_PATH .= '../';
    if ($a[$i] === 'src' || $a[$i] === 'plugins') {
        break;
    }
}

$base_uri = implode('/',array_slice($a,0,$i)). '/';



/** set the name of the session cookie */
if (!isset($session_name) || !$session_name) {
    $session_name = 'SQMSESSID';
}

/**
 * if session.auto_start is On then close the session
 */
$sSessionAutostartName = session_name();
$sCookiePath = null;
if ((isset($sSessionAutostartName) || $sSessionAutostartName == '') &&
     $sSessionAutostartName !== $session_name) {
    $sCookiePath = ini_get('session.cookie_path');
    $sCookieDomain = ini_get('session.cookie_domain');
    // reset the cookie
    setcookie($sSessionAutostartName,'',time() - 604800,$sCookiePath,$sCookieDomain);
    @session_destroy();
    session_write_close();
}

/**
 * includes from classes stored in the session
 */
require(SM_PATH . 'class/mime.class.php');

ini_set('session.name' , $session_name);
session_set_cookie_params (0, $base_uri);
sqsession_is_active();







if ( !empty($_SESSION["captcha_text_direction"]) )
  $text_direction = $_SESSION["captcha_text_direction"];

$sufficient_characters = 0;

if ( $min_correct_characters > 0 && $min_correct_characters <= $min_string_length )
  $sufficient_characters = $min_correct_characters;

$captcha = NewMagickWand();
MagickSetFormat($captcha, $image_type);

if ( $text_color != "light" && $text_color != "dark" )
{
  if ( mt_rand(0,1) == 0 )
    $text_color = "light";
  else
    $text_color = "dark";
}

if ( $text_color == "light" )
  $color = phpcaptcha_get_random_color(0,70);
else
  $color = phpcaptcha_get_random_color(185,255);

MagickNewImage($captcha, $width, $height, $color);

if ( $background_noise > 0 )
{
  for ( $i = 0; $i < $background_noise; $i++ )
    MagickAddNoiseImage($captcha, 4);
}

if ( $number_of_lines > 0 )
{
  $obj = NewDrawingWand();

  for ( $i = 0; $i < $number_of_lines; $i++ )
  {
    DrawSetStrokeColor($obj, phpcaptcha_get_random_color());
    DrawSetStrokeWidth($obj, mt_rand(1,4));
    DrawLine($obj, mt_rand(-10,($width+10)), mt_rand(-10,($height+10)),
                   mt_rand(-10,($width+10)), mt_rand(-10,($height+10)));
  }

  MagickDrawImage($captcha,$obj);
  DestroyDrawingWand($obj);
}

if ( $number_of_ellipses > 0 )
{
  $obj = NewDrawingWand();

  for ( $i = 0; $i < $number_of_ellipses; $i++ )
  {
    DrawSetStrokeColor($obj, phpcaptcha_get_random_color());
    DrawSetStrokeWidth($obj, mt_rand(1,4));
    DrawSetFillAlpha($obj, 0);
    DrawEllipse($obj, mt_rand(0,$width), mt_rand(0,$height),
                      mt_rand(round($width/5),round($width/2)), mt_rand(round($height/5),round($height/2)),
                      mt_rand(30,90), mt_rand(30,90));
  }

  MagickDrawImage($captcha,$obj);
  DestroyDrawingWand($obj);
}

if ( $number_of_beziers > 0 )
{
  $obj = NewDrawingWand();

  for ( $i = 0; $i < $number_of_beziers; $i++ )
  {
    DrawSetStrokeColor($obj, phpcaptcha_get_random_color());
    DrawSetStrokeWidth($obj, mt_rand(1,4));
    DrawSetFillAlpha($obj, 0);
    DrawBezier($obj, array(mt_rand(-10,round($width/3)), mt_rand(-10,($height+10)),
                           mt_rand(round($width/3),round($width/3*2)), mt_rand(10,($height-10)),
                           mt_rand(round($width/3*2),($width+10)), mt_rand(-10,($height+10))));
  }

  MagickDrawImage($captcha,$obj);
  DestroyDrawingWand($obj);
}

if ( $text_direction_pointer == 1 && $sufficient_characters == 0 )
  $text = phpcaptcha_get_random_string(mt_rand(($min_string_length+1),($max_string_length+1)), $text_type);
else
  $text = phpcaptcha_get_random_string(mt_rand($min_string_length,$max_string_length), $text_type);

$text_array = explode(" ", $text);

$char_width = round($width / sizeof($text_array));

$border1 = 0 - round($width/2);
$border2 = $border1 + $char_width;

$text_style = NewDrawingWand();
DrawSetGravity($text_style, MW_CenterGravity);
DrawSetStrokeWidth($text_style, 2);

$pointer_location = -1;

if ( $text_direction_pointer == 1 && $sufficient_characters == 0 )
  $pointer_location = mt_rand(0,(sizeof($text_array)-1));

for ( $i = 0; $i < sizeof($text_array); $i++ )
{
  if ( $text_color == "light" )
  {
    DrawSetStrokeColor($text_style, phpcaptcha_get_random_color(155,255));
    DrawSetFillColor($text_style, phpcaptcha_get_random_color(0,255));
  }
  else
  {
    DrawSetStrokeColor($text_style, phpcaptcha_get_random_color(0,100));
    DrawSetFillColor($text_style, phpcaptcha_get_random_color(0,255));
  }

  DrawSetFillAlpha($text_style, (mt_rand($minimum_text_alpha,$maximum_text_alpha)/100));

  $font_size = mt_rand($min_font_size,$max_font_size);
  $font_offset = round($font_size / 2);
  DrawSetFontSize($text_style, $font_size);

  if ( $pointer_location == -1 || $i != $pointer_location )
  {
    DrawSetFont($text_style, "fonts/" . $font);
    $rotation_angle = mt_rand($min_rotation_angle,$max_rotation_angle);

    if ( mt_rand(0,1) == 0 )
      $rotation_angle = 0 - $rotation_angle;

    $character = $text_array[$i];
  }
  else
  {
    DrawSetFont($text_style, "fonts/pointers.ttf");

    if ( $text_direction == "RL" )
      $rotation_angle = -180;
    else
      $rotation_angle = 0;

    $character = phpcaptcha_get_random_string(1,"P");
    $text_array[$i] = "";
  }

  MagickAnnotateImage($captcha, $text_style, mt_rand(($border1 + $font_offset),($border2 - $font_offset)), mt_rand(($font_offset - round($height/2)),(round($height/2) - $font_offset)), $rotation_angle, $character);

  $border1 = $border2;
  $border2 = $border2 + $char_width;
}

$swirl_angle = mt_rand($min_swirl_angle,$max_swirl_angle);

if ( mt_rand(0,1) == 0 )
  $swirl_angle = 0 - $swirl_angle;

if ( $foreground_noise > 0 )
  MagickAddNoiseImage($captcha, 4);

MagickSwirlImage($captcha, $swirl_angle);

if ( !empty($motion_blur_radius) )
  MagickMotionBlurImage($captcha, $motion_blur_radius, $motion_blur_sigma, mt_rand(-30,30));

if ( $border_thickness > 0 )
{
  if ( empty($border_color) )
    $border_color = phpcaptcha_get_random_color();

  MagickBorderImage($captcha, $border_color, $border_thickness, $border_thickness);
}

MagickFlattenImages($captcha);

$text = implode("", $text_array);

$_SESSION["captcha"] = str_replace(" ","", $text);

if ( $text_direction == "RL" && $sufficient_characters == 0 )
  $_SESSION["captcha"] = strrev(str_replace(" ","", $text));  

if ( $text_case_sensitive == 0 )
  $_SESSION["captcha"] = strtoupper($_SESSION["captcha"]);

$_SESSION["captcha_text_info"] = strlen($_SESSION["captcha"]);

if ( $sufficient_characters == 0 )
{
  if ( function_exists("hash") )
    $_SESSION["captcha"] = hash("md5", $_SESSION["captcha"]);
  else
    $_SESSION["captcha"] = md5($_SESSION["captcha"]);
}

$_SESSION["captcha_text_direction"] = $text_direction;
$_SESSION["captcha_text_case_sensitive"] = $text_case_sensitive;
$_SESSION["captcha_text_info"] .= ":" . $sufficient_characters;

if ( $expiration_time > 0 )
  $_SESSION["captcha_expiration_time"] = time() + $expiration_time;

$content_type = MagickGetImageMimeType($captcha);

// HTTP 1.0
header("Pragma: no-cache");
header("Cache-Control: post-check=0, pre-check=0", false);
// HTTP 1.1
header("Cache-Control: no-store, no-cache, must-revalidate");
// Date in past
header("Expires: Fri, 01 Jan 1999 01:00:00 GMT");
// Always modified
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Content-type: " . $content_type);

MagickEchoImageBlob($captcha);

