<?php
// vi: ts=4 sw=4 et:

/*******************************************************************************

    Author ....... Jonathan S. Earle
    Contact ...... plugins@kronos.honk.org
    Home Site .... http://kronos.honk.org/~earlej/
    Program ...... Canadian Weather

*******************************************************************************/

//http://weatheroffice.ec.gc.ca/forecast/city_e.html?on-118&unit=m

// This works for metric... easier to just use the form above though.
//http://www.weatheroffice.gc.ca/city/pages/on-118_metric_f.html

function show_weather()
{
    global $weather_region, $weather_position, $weather_lang,
           $weather_unit;

    // Will be populated with code to display for weather warnings/watches.
    $warning = "";
    // Holds regex matches in later expressions.
    $matches = array();
    // Final HTML output string will be assembled here.
    $html = "";

    // Exit if values are invalid.
    if (!$weather_region || !$weather_position || 
        !$weather_lang   || !$weather_unit)
    {
        return;
    }

    /*
     * Build the request, open the socket and retrieve the region's weather page.
     */

    $site = "www.weatheroffice.gc.ca";
    $port = 80;
    $uri = "/forecast/city_" . $weather_lang . ".html?" .
           $weather_region . "&unit=" . $weather_unit;

    $httpsock = fsockopen($site, $port);
    if (!$httpsock) return;

    $request  = "GET " . $uri . " HTTP/1.1\r\n";
    $request .= "Host: " . $site . "\r\n";
    $request .= "Accept: */*\r\n";
    $request .= "\r\n\r\n";

    fwrite($httpsock, $request);
    $data = "";

    while (!feof($httpsock)) 
    {
        $data .= fread($httpsock, 1024);
    }

    /*
     * Clean up the data before processing it.
     */

    /*
     * Note 1: EC occasionally emits pages with the following characters which,
     * if not cleaned up, mess up the regex's below.

        </dl>
      </d
1df5
iv>
      <div id="cityadditional">
     */

    /*
     * Note 2: Experiment to strip out a potentially unneeded element.  EC is
     * able to hide this with a style definition for IE (Firefox never had an
     * issue) but I don't see how they did it. Anyone care to take a stab at
     * it?  In case you're wondering.. this element ends up, in IE, putting a
     * 2px blank line between each row of the table, therefore you see a tiny
     * vertical gap between each row, like so:
     *      |,... this is the gap
     *   -------
     */

    // Patterns to remove or alter in the retrieved data buffer.
    $arr_search = array(// 17Apr07: fix EC error.
                        "/\r\n.*\r\n/",
                        // Snip everything before the region name.
                        "/.*(<h1 id=\"c1\">.*)/",
                        // Snip data after current conditions.
                        "/<li class=\"rightList footer\".*/ims",
                        // Remove erroneous leading spaces.
                        "/^[ \t]*/ms",
                        // Unneeded element (see Note 2 above)
                        "/<dd class=\"dd1\">.*?<\/dd>/",
                        // Other unneeded elements.
                        "/<dl.*?>/", "/<\/dl>/",
                        "/<ul.*?>/", "/<\/ul>/",
                        "/<li.*?>/", "/<\/li>/",
                        // Add site to original relative uri.
                        "/\/weathericons/",
                        // Ensure links open in new windows.
                        "/href/",
                        // Add site to uri. (explanations)
                        "/\/mainmenu/",
                        // Add site to uri. (weather warnings)
                        "/\/warnings/"
                       );

    // How to adjust the above patterns.
    $arr_replace = array("",
                         "$1",
                         "",
                         "",
                         "", // Note 2
                         "", "",
                         "", "",
                         "", "",
                         "http://" . $site . "/weathericons",
                         "target=\"_new\" href",
                         "http://" . $site . "/mainmenu",
                         "http://" . $site . "/warnings"
                        );

    // Massage the data.
    $data = preg_replace($arr_search, $arr_replace, $data);

    // Remove erroneous \n's. Works better here rather than using a regex in
    // the preceeding operation (doesn't inject a pile of spaces in the
    // resulting string).
    $data = str_replace("\n", "", $data);

    //error_log("processed data:".$data);

    /*
     * First, we will need to grab the City name, then look for any warnings,
     * watches, etc.  Next, trim off all leading content up to the start of the
     * block we want.  Finally, trim off all trailing data after the conditions
     * block and replace with closing div tags. Clean things up and proceed.
     */

    // City is used to anchor a url to the region's EC page.
    $city = "";
    $match_expr = "/<h1 id=\"c1\">(.*?)<\/h1>/i";
    if (preg_match($match_expr, $data, $matches))
    {
        $city = $matches[1];
        //error_log("city: ". $city);
    }

    // Check for weather warnings
    if ($warning == "")
        list ($warning, $data) = check_warning_watch($data, "warning");
    
    // Check for weather watches
    if ($warning == "")
        list ($warning, $data) = check_warning_watch($data, "watch");
    
    // Check for weather warning or watches that have ended.
    if ($warning == "")
        list ($warning, $data) = check_warning_watch($data, "ended");

    /*
     * Now we are going to extract the component pieces until we find the
     * actual forecast conditions.
     */

    $image = "";        // Nice weather graphic.
    $observed = "";     // Observed place & time. Needs editing after extraction.
    $conditions = "";   // Observed conditions.

    // Extract observation time, place, image, conditions, etc. Everything that
    // comes before the actual condition details.
    $match_expr = "/.*<div id=\"currentcond\">.*?(<(img|p).*?>)" .  // Weather icon (non-greedy to avoid Temp.)
                  ".*<div id=\"cityobserved\"><dt>(.*?)<\/div>" .   // Observed place & time
                  ".*?<dd>(.*?)<\/dd>(.*)" .                        // Observed conditions & rest.
                  "$/ms";

    if (preg_match($match_expr, $data, $matches))
    {
        // matches[2] references the img|p condition.
        $image      = $matches[1];
        $observed   = $matches[3];
        $conditions = $matches[4];
        $data       = $matches[5];

        // Clean up the Observed string.
        $observed   = preg_replace(array("/date:/i","/<.*?>/"), 
                                   array("", ""), 
                                   $observed);

        // If no image given, then clear the image and observed conditions
        // values (both are linked).
        if (preg_match("/.*noConditionIcon.*/i", $image))
        {
            $image = '';
            $conditions = '';
        }

        //error_log("image: ". $image);
        //error_log("observed: ". $observed);
        //error_log("conditions: ". $conditions);
        //error_log("data: ". $data);
    }

    // Remove extra whitespace from start/end of string.
    $data = trim($data, "\n");
    //error_log("final data:".$data);

    /*
     * Time to assemble the final product!
     */

    // If required, put an empty line between the folder list and the weather.
    if ($weather_position == "below")
        $html .= "<br>";

    // Add warnings/watches/etc.
    if ($warning) 
        $html .= $warning;

    // Open the div tags.
    $html .= <<< EOT
    <center>
    <div id="city">
      <div id="box">
        <div id="citycurrent">
EOT;

    // Add the region name and a link to the main EC page for the region. 
    $html .= "<h2><a target=\"new\" href=\"http://" . $site . $uri ."\">" . 
             $city . "</a></h2>";

    // Print out date/time/place that weather conditions were recorded.
    $html .= '<div id="cityobserved">' . $observed . '</div>';

    // Image and Conditions are optional... EC doesn't always report observed
    // conditions for all regions.
    if ($image != '') 
        $html .= $image; // Used to be class="currentimg" and no title.
    if ($conditions != '') 
        $html .= '<div class="citycondition">' . $conditions . "</div>";

    // Add the main condition detail data.
    $html .= "<dl>" . $data . "</dl>";

    // Close the div tags.
    $html .= <<< EOT
        </dl>
        </div>
      </div>
    </div>
    </center>
EOT;

    // Put an empty line bwtween the weather and the folder list.
    if ($weather_position == "above")
        $html .= "<br>";

    // Print the assembled weather block!
    print $html;

    return;
}

// Check for weather warnings, watches or warnings/watches that have ended.
function check_warning_watch($data, $tag)
{
    global $weather_lang;

    $matches = array();
    $warning = "";

    if (preg_match("/.*(<div id=\"$tag\">.*?<\/div>)(.*)/is", $data, $matches))
    {
        $warning = $matches[1];
        $data = $matches[2];

        $warning = str_replace("\n", "", $warning);
        //error_log("warning: ".$warning);

        /*
         * Massage the message to be smaller, allowing it to fit into the
         * folders frame. We use the EC warning message as the acronym for the
         * generic message... mouse over the message to see the actual warning.
         */

        $arr_search = array();
        $arr_search = array("/(<a.*?>)(.*?)(<\/a>)/is");

        $arr_replace = array();
        if ($weather_lang == "e")
        {
            switch ($tag)
            {
            case "warning":
                $arr_replace = array("$1<acronym title=\"$2\">WEATHER WARNING</acronym>$3");
                break;
            case "watch":
                $arr_replace = array("$1<acronym title=\"$2\">WEATHER WATCH</acronym>$3");
                break;
            case "ended":
                $arr_replace = array("$1<acronym title=\"$2\">" .
                                     "WEATHER WARNING/WATCH ENDED</acronym>$3");
                break;
            }
        }
        else
        {
            switch ($tag)
            {
            case "warning":
                $arr_replace = array("$1<acronym title=\"$2\">" .
                                     "SURVIVEZ   l'AVERTISSEMENT</acronym>$3");
                break;
            case "watch":
                $arr_replace = array("$1<acronym title=\"$2\">" .
                                     "SURVIVEZ   la MONTRE</acronym>$3");
                break;
            case "ended":
                $arr_replace = array("$1<acronym title=\"$2\">" .
                                     "SURVIVEZ   L'AVERTISSEMENT/ MONTRE FINIS</acronym>$3");
                break;
            }
        }

        // This is now a loop to handle situations where EC sets multiple warnings.
        while (($warning = preg_replace($arr_search, $arr_replace, $warning)) === true)
        {;}
    }

    return array ($warning, $data);
}

function weather_show_above_do()
{
    global $weather_region, $weather_position;

    if ($weather_region && $weather_position == 'above')
        show_weather();

    return;
}

function weather_show_below_do()
{
    global $weather_region, $weather_position;

    if ($weather_region && $weather_position == 'below')
        show_weather();

    return;
}

function weather_save_options_do()
{
    global $data_dir, $username;

    setPref($data_dir, $username, 'weather_lang', $_POST['weather_lang_in']);
    setPref($data_dir, $username, 'weather_position', $_POST['weather_position_in']);
    setPref($data_dir, $username, 'weather_province', $_POST['weather_province_in']);
    if (isset($_POST['weather_region_in']) || isset($_POST['weather_region_text_in']))
    {
        if (isset($_POST['weather_region_in']))
            setPref($data_dir, $username, 'weather_region', $_POST['weather_region_in']);
        else if (isset($_POST['weather_region_text_in']))
            setPref($data_dir, $username, 'weather_region', $_POST['weather_region_text_in']);
    }
    setPref($data_dir, $username, 'weather_unit', $_POST['weather_unit_in']);

    $left_size = getPref($data_dir, $username, 'left_size');

    if ($_POST['weather_region_in'] && $left_size < 160)
        setPref($data_dir, $username, 'left_size', '160');

    return;
}

function weather_load_options_do()
{
    global $weather_lang, $weather_position, $weather_province, $weather_region, 
           $weather_unit, $data_dir, $username;

    $weather_lang = getPref($data_dir, $username, 'weather_lang');
    $weather_position = getPref($data_dir, $username, 'weather_position');
    $weather_province = getPref($data_dir, $username, 'weather_province');
    $weather_region = getPref($data_dir, $username, 'weather_region');
    $weather_unit = getPref($data_dir, $username, 'weather_unit');

    return;
}

/*
Current (As of a few months before 24June08):


<h1 id="c1">Maniwaki</h1>
                        <div id="watch">

                    <h2>
  <a href="/warnings/report_e.html?qc58">SEVERE THUNDERSTORM WATCH</a>
</h2>
            </div>
...

then, either (includes icon):

<div id="currentcond">
  <div id="currentcond-left">
    <p class="noConditionIcon">&nbsp;</p>
    <div>
      <p class="temperature">22<sup>
          <a href="/forecast/city_e.html?qc-102&amp;unit=i" title="Convert to Imperial Units">&deg;C</a>
        </sup>
      </p>
    </div>
  </div>

or (no icon):

<div id="currentcond">
  <div id="currentcond-left">
    <img id="currentimg" src="/weathericons/03.gif" alt="Mostly Cloudy" title="Mostly Cloudy" />
    <div>
      <p class="temperature">18<sup>
          <a href="/forecast/city_e.html?qc-121&amp;unit=i" title="Convert to Imperial Units">&deg;C</a>
        </sup>
      </p>
    </div>
  </div>

Followed immmediately by:

  <div id="currentcond-content">
    <div id="cityobserved">
      <dl>
        <dt>Observed at: </dt>
        <dd>Chibougamau Chapais Airport</dd>
        <dt>Date: </dt>
        <dd>12:00 PM EDT Thursday 26 June 2008</dd>
      </dl>
    </div>
    <div id="citycondition">
      <ul>
        <li class="leftList">
          <dl class="leftCol">
            <dt>Condition:</dt>
            <dd>Mostly Cloudy</dd>
            <dd class="dd1">&nbsp;</dd>
            <dt>Pressure:</dt>
            <dd>100.9&nbsp;kPa</dd>
            <dd class="dd1">&nbsp;</dd>
            <dt>Tendency:</dt>
            <dd>falling</dd>
            <dd class="dd1">&nbsp;</dd>
            <dt>Visibility:</dt>
            <dd>24 km</dd>
            <dd class="dd1">&nbsp;</dd> </dl>
        </li>
        <li class="rightList">
          <dl class="rightCol">
            <dt>Temperature:</dt>
            <dd>18.1&deg;C</dd>
            <dd class="dd1">&nbsp;</dd>
            <dt>Dewpoint:</dt>
            <dd>13.5&deg;C</dd>
            <dd class="dd1">&nbsp;</dd>
            <dt>Humidity:</dt>
            <dd>74 %</dd>
            <dd class="dd1">&nbsp;</dd>
            <dt>Wind:</dt>
            <dd class="longContent">NNE 8 km/h</dd>
            <dd class="dd1">&nbsp;</dd>
          </dl>
        </li>
        <li class="rightList footer">&nbsp;</li>
      </ul>
    </div>
  </div>
</div>


Previously:

<h1>
  <a name="content">&nbsp;</a>Chibougamau</h1>
                    <div id="warning">
                <h2>
  <a href="/warnings/report_e.html?qc19">SNOWFALL WARNING CONTINUED</a>
</h2>
        </div>
    <div id="city">
  <div id="box">
    <div id="citycurrent">
      <h2>Currently</h2>
      <div id="cityobserved">Observed at: Chibougamau Chapais Airport 
                             30 October 2006 1:00 AM EST</div>
      <img class="currentimg" src="/weathericons/16.gif" alt="Light Snow"/>
      <div class="citycondition">Light Snow</div>
      <dl>
        <dt>Temperature</dt>
        <dd>-1&deg;C</dd>
        <dd class="dd1"/>
        <dt>Pressure/ Tendency</dt>
        <dd>98.7 kPa<span class="rising" id="risingPressure">&uarr;</span></dd>
        <dd class="dd1"/>
        <dt>Visibility</dt>
        <dd>2 km</dd>
        <dd class="dd1"/>
        <dt>Humidity</dt>
        <dd>99 %</dd>
        <dd class="dd1"/>
        <dt>
          <a href="/mainmenu/faq_e.html#weather2">Wind Chill</a>
        </dt>
        <dd>-7 </dd>
        <dd class="dd1"/>
        <dt>Dewpoint</dt>
        <dd>-1&deg;C</dd>
        <dd class="dd1"/>
        <dt>Wind</dt>
        <dd>W 24 km/h gust 41 km/h</dd>
        <dd class="dd1"/>
      </dl>
    </div>

  </div>
</div>
*/
?>
