<?php

/*******************************************************************************

    Author ....... Jonathan S. Earle
    Contact ...... plugins@kronos.honk.org
    Home Site .... http://kronos.honk.org/~earlej/
    Program ...... Canadian Weather

*******************************************************************************/

/* 
 * Only reason this module is required is to get around the fact that we cannot
 * do cross site scripting.
 */

// Get the weather region list page from Environment Canada

$weather_lang     = $_GET['weather_lang_in'];
$weather_province = $_GET['weather_province_in'];

if ($weather_province)
{
    $site = "www.weatheroffice.gc.ca";
    $port = 80;
    $uri = "/forecast/canada/index_" . $weather_lang . ".html?" . 
           "id=" . $weather_province . " HTTP/1.1";
    
    $httpsock = fsockopen($site, $port);
    if (!$httpsock) return;

    $request  = "GET " . $uri . "\r\n";
    $request .= "Host: " . $site . "\r\n";
    $request .= "Accept: */*\r\n";
    $request .= "\r\n\r\n";

    fwrite($httpsock, $request);
    $data = "";

    while (!feof($httpsock)) 
    {
        $data .= fread($httpsock, 1024);
    }
    //error_log("raw strlen:".strlen($data));
    //error_log("raw:".substr($data,15000));

    /*
     * Search for the start of the province code/name list and copy everything
     * up to the closing </select>, discarding rest of page. This forms our
     * basic list of provincial regions.  Then we strip everything in each
     * option tag but the region code and name until we're left with just a
     * nice comma separated list of region codes and names: 
     * on-122,Alexandria, ...
     */

    // 02Aug07 - EC changed things again on initial parse and , trimming. Also, found
    // same error I corrected on Apr17 with \r's in string; fix copied here too.
    //            "/.*\"Form1\".*?<\/option>(.*)<\/select.*/is", // Initial parse.
    $arr_search = 
            array("/\r\n.*\r\n/",             // 17Apr07: fix EC error.
                  "/.*<select id=\"Province\".*?<\/option>(.*?)<\/select.*/is", // Initial parse.
                  "/.*\/(.*?)_.*>(.*)<.*/S",   // Leave only region code and name.
                  "/\n/s",                    // Replace CR's with ,'s.
                  "/\t/",                     // Remove erroneous tabs.
                  "/,+(.*?),+$/");            // Remove , at start/end of final string.
    $arr_replace = array("", "$1", "$1,$2", ",", "", "$1");

    $data = preg_replace($arr_search, $arr_replace, $data);
    //$data = htmlentities($data);

    //error_log("final strlen:".strlen($data));
    //error_log("final:[$data]");

    print $data;
} else
    print "PROVINCE UNDEFINED";

?>
