<?php

/**
  * SquirrelMail Bypass Trash Plugin
  * Copyright (c) 2003-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage bypass_trash
  *
  */


global $show_bypass_trash_checkbox_allow_override, $bypass_trash_text,
       $bypass_trash_title_text, $folders_to_show_bypass_trash_checkbox,
       $folders_to_not_show_bypass_trash_checkbox,
       $bt_show_purge_button_allow_override, $bt_purge_button_text,
       $bt_purge_button_title_text, $bt_folders_to_show_purge_button,
       $bt_folders_to_not_show_purge_button, $bt_show_links_where_buttons_are,
       $bt_purge_button_description, $bypass_trash_description;



// -------------------------------------------------------------------
//
// MESSAGE LIST PURGE BUTTON/BYPASS TRASH CHECKBOX OPTIONS
//


// This is a list of folders that by default will have a
// "purge" button on the mailbox list page.  You may leave
// this empty if none should.
//
// The purge button will remove the selected message(s)
// permanently - without moving to the trash folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting.
//
// $bt_folders_to_show_purge_button = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$bt_folders_to_show_purge_button = array(
);



// This is a list of folders that by default will NOT have
// a "purge" button on the mailbox list page.  All other
// folders WILL have a "purge" button in them if this
// setting is anything except an empty list.
//
// The purge button will remove the selected message(s)
// permanently - without moving to the trash folder.
//
// If any of the folders identified here overlap with
// $bt_folders_to_show_purge_button, a purge button WILL
// be shown for that folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting.
//
// $bt_folders_to_not_show_purge_button = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$bt_folders_to_not_show_purge_button = array(
);



// Should a purge link be shown in the options list under
// the message headers on the message display screen when
// viewing a message in one of the folders that purge buttons
// are enabled for?
//
$bt_show_links_where_buttons_are = 1;



// Allow users to determine what folders the purge
// button is to be shown in?
//
$bt_show_purge_button_allow_override = 1;



// This is a list of folders that by default will have a
// "bypass trash" checkbox on the mailbox list page.  You
// may leave this empty if none should.
//
// The bypass trash checkbox will cause the normal "Delete"
// button to act the same as the "purge" button above -
// the selected message(s) will be removed permanently -
// without moving to the trash folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting.
//
// $folders_to_show_bypass_trash_checkbox = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$folders_to_show_bypass_trash_checkbox = array(
);



// This is a list of folders that by default will NOT have
// a "bypass trash" checkbox on the mailbox list page.  All
// other folders WILL have a "bypass trash" checkbox in
// them if this setting is anything except an empty list.
//
// The bypass trash checkbox will cause the normal "Delete"
// button to act the same as the "purge" button above -
// the selected message(s) will be removed permanently -
// without moving to the trash folder.
//
// If any of the folders identified here overlap with
// $folders_to_show_bypass_trash_checkbox, a bypass trash
// checkbox WILL be shown for that folder.
//
// If set, this value must contain the exact name(s) of
// the specified folder(s) (the format of which may depend
// on your IMAP server).
//
// The trash folder is not affected by this setting.
//
// $folders_to_not_show_bypass_trash_checkbox = array(
//    'INBOX',
//    'INBOX.Sent',
//    'INBOX.Mailing Lists',
// );
//
$folders_to_not_show_bypass_trash_checkbox = array(
);



// Allow users to determine what folders the bypass
// trash checkbox is to be shown in?
//
$show_bypass_trash_checkbox_allow_override = 0;



// -------------------------------------------------------------------
//
// LANGUAGE OPTIONS
//


// You may change the text of the links and buttons that
// this plugin generates.  The following strings are
// included in the translation file for this plugin:
//
//    "Wipe"
//    "Purge"
//    "Skip Trash"
//    "Bypass Trash"
//    "Permanent Delete"
//
// You can use any other string you like, but if you use something
// other than those strings above, the buttons/links will not be
// correctly translated into other languages unless you add the
// string(s) to your locale files manually.
// 
$bt_purge_button_text = "Wipe";
$bypass_trash_text = "Bypass Trash";



// You may change the text of the title attribute for the links
// and buttons that this plugin generates.  The following strings
// are included in the translation file for this plugin:
//
//    "Permanently remove the selected message(s)"
//    "Purge the selected message(s)"
//    "Delete the selected message(s), bypassing the trash"
//    "Delete the selected message(s), skipping the trash"
//    "When enabled, the Delete button will permanently remove the selected message(s)"
//    "When enabled, the Delete button will permanently remove the selected message(s), skipping the trash"
//    "When enabled, the Delete button will permanently remove the selected message(s), bypassing the trash"
//    "When enabled, the Delete button will purge the selected message(s)"
//    "When enabled, the Delete button will purge the selected message(s), skipping the trash"
//    "When enabled, the Delete button will purge the selected message(s), bypassing the trash"
//
// You can use any other string you like, but if you use something
// other than those strings above, the confirmation/warning message
// will not be correctly translated into other languages unless you
// add the string(s) to your locale files manually.
//
$bt_purge_button_title_text = "Permanently remove the selected message(s)";
$bypass_trash_title_text = "When enabled, the Delete button will permanently remove the selected message(s)";



// You may change the text of the description for each widget
// on the folder manipulation page. The following strings
// are included in the translation file for this plugin:
//
//    "Wipe checkboxes on the message list page make the Delete button remove selected messages permanently."
//    "Purge checkboxes on the message list page make the Delete button remove selected messages permanently."
//    "Skip Trash checkboxes on the message list page make the Delete button remove selected messages permanently."
//    "Bypass Trash checkboxes on the message list page make the Delete button remove selected messages permanently."
//    "Permanent Delete checkboxes on the message list page make the Delete button remove selected messages permanently."
//    "Wipe buttons on the message list page remove the selected messages from the folder permanently."
//    "Purge buttons on the message list page remove the selected messages from the folder permanently."
//    "Skip Trash buttons on the message list page remove the selected messages from the folder permanently."
//    "Bypass Trash buttons on the message list page remove the selected messages from the folder permanently."
//    "Permanent Delete buttons on the message list page remove the selected messages from the folder permanently."
//
// You can use any other string you like, but if you use something
// other than those strings above, the buttons/links will not be
// correctly translated into other languages unless you add the
// string(s) to your locale files manually.
// 
$bt_purge_button_description = "Wipe buttons on the message list page remove the selected messages from the folder permanently.";
$bypass_trash_description = "Bypass Trash checkboxes on the message list page make the Delete button remove selected messages permanently.";



