<?php

/**
  * SquirrelMail Bypass Trash Plugin
  * Copyright (c) 2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage bypass_trash
  *
  */



/**
  * Places text and widgets on the folder page
  *
  */
function bypass_trash_show_options_do() 
{

   global $username, $data_dir, $color, $javascript_on,
          $show_bypass_trash_checkbox_allow_override,
          $bt_show_purge_button_allow_override,
          $bt_folders_to_not_show_purge_button,
          $bt_folders_to_show_purge_button,
          $folders_to_not_show_bypass_trash_checkbox,
          $folders_to_show_bypass_trash_checkbox,
          $bt_purge_button_description, $bypass_trash_description;


   // no user config?  bail.
   //
   include_once(SM_PATH . 'plugins/bypass_trash/functions.php');
   bypass_trash_init();
   if (!$show_bypass_trash_checkbox_allow_override
    && !$bt_show_purge_button_allow_override)
      return;


   // grab new settings if user had just pressed the Save button
   //
   if (sqgetGlobalVar('bypass_trash_form', $bypass_trash_form, SQ_FORM)
    && $bypass_trash_form)
   {

      // get folders that should have a purge button
      //
      if ($bt_show_purge_button_allow_override)
      {
         $bt_show_purge_button = 0;
         sqgetGlobalVar('bt_show_purge_button', $bt_show_purge_button, SQ_FORM);
         if (!empty($bt_show_purge_button) && is_array($bt_show_purge_button))
         {
            $allFolders = '';
            foreach ($bt_show_purge_button as $folder)
               $allFolders .= $folder . '###';
         }
         else
            // cannot use an empty value here, otherwise the plugin defaults
            // will take over again when user intended for NO folders to be
            // the correct behavior, so we use the set string "NONE"
            //
            $allFolders = 'NONE';

         setPref($data_dir, $username, 'bt_show_purge_button', $allFolders);
      }


      // get folders that should have a bypass trash checkbox
      //
      if ($show_bypass_trash_checkbox_allow_override)
      {
         $bt_show_bypass_trash_checkbox = 0;
         sqgetGlobalVar('bt_show_bypass_trash_checkbox', $bt_show_bypass_trash_checkbox, SQ_FORM);
         if (!empty($bt_show_bypass_trash_checkbox) && is_array($bt_show_bypass_trash_checkbox))
         {
            $allFolders = '';
            foreach ($bt_show_bypass_trash_checkbox as $folder)
               $allFolders .= $folder . '###';
         }
         else
            // cannot use an empty value here, otherwise the plugin defaults
            // will take over again when user intended for NO folders to be
            // the correct behavior, so we use the set string "NONE"
            //
            $allFolders = 'NONE';

         setPref($data_dir, $username, 'bt_show_bypass_trash_checkbox', $allFolders);
      }

   }



   // grab user preference for purge button folders
   //
   if ($bt_show_purge_button_allow_override)
      $allFolders = getPref($data_dir, $username,
                            'bt_show_purge_button',
                            NULL);
   else
      $allFolders = NULL;



   // reformat folder list if not NULL (which means defaults apply below)
   //
   if ($allFolders == 'NONE') $allFolders = ''; // see note elsewhere about why we use "NONE"
   if (!is_null($allFolders)) $bt_show_purge_button = explode('###', $allFolders);
   else $bt_show_purge_button = NULL;



   // grab user preference for bypass trash checkbox folders
   //
   if ($show_bypass_trash_checkbox_allow_override)
      $allFolders = getPref($data_dir, $username,
                            'bt_show_bypass_trash_checkbox',
                            NULL);
   else
      $allFolders = NULL;



   // reformat folder list if not NULL (which means defaults apply below)
   //
   if ($allFolders == 'NONE') $allFolders = ''; // see note elsewhere about why we use "NONE"
   if (!is_null($allFolders)) $bt_show_bypass_trash_checkbox = explode('###', $allFolders);
   else $bt_show_bypass_trash_checkbox = NULL;



   // prepare folder list for easy use by template
   //
   // create an array where each entry is a five-element array keyed
   // by "displayable", "option_value", "bt_show_purge_button",
   // "show_bypass_trash_checkbox" and "is_special",
   // where the last three are boolean values
   //
   // this list excludes the trash folder, since deletions
   // from it are always permanent deletions
   //
   $bt_folder_listing = array();
/* ----- already tested these at the top of this function...
   if ($show_bypass_trash_checkbox_allow_override
    || $bt_show_purge_button_allow_override)
----- */
   {
      global $bt_folder_listing, $trash_folder, $boxes, $nbsp;
      if (!check_sm_version(1, 5, 2)) $nbsp = '&nbsp;';
      for ($i = 0; $i < count($boxes); $i++) 
      {
         if (strtolower($boxes[$i]['unformatted']) != strtolower($trash_folder)
          && strtolower($boxes[$i]['unformatted-dm'] != 'inbox.trash'))
         {
            $bt_folder_listing[$i]['option_value'] = $boxes[$i]['unformatted-dm'];
            $bt_folder_listing[$i]['displayable'] = str_replace(' ', $nbsp, imap_utf7_decode_local($boxes[$i]['unformatted-disp']));


            if (isSpecialMailbox($bt_folder_listing[$i]['option_value']))
               $bt_folder_listing[$i]['is_special'] = 1;
            else
               $bt_folder_listing[$i]['is_special'] = 0;



            // if the user specified a list before, just use it to
            // test for what folders have the purge button turned on
            //
            if (is_array($bt_show_purge_button))
            {
               if (in_array($bt_folder_listing[$i]['option_value'], $bt_show_purge_button))
                  $bt_folder_listing[$i]['bt_show_purge_button'] = 1;
               else
                  $bt_folder_listing[$i]['bt_show_purge_button'] = 0;
            }


            // or apply the defaults from the configuration file
            //
            // (button enabled if in default list, or if NOT in the
            // default "don't show" list (and that list is non-empty))
            //
            else
            {
               if (in_array($bt_folder_listing[$i]['option_value'], $bt_folders_to_show_purge_button)
                || (!empty($bt_folders_to_not_show_purge_button) && !in_array($bt_folder_listing[$i]['option_value'], $bt_folders_to_not_show_purge_button)))
                  $bt_folder_listing[$i]['bt_show_purge_button'] = 1;
               else
                  $bt_folder_listing[$i]['bt_show_purge_button'] = 0;
            }



            // if the user specified a list before, just use it to
            // test for what folders have the bypass trash checkbox turned on
            //
            if (is_array($bt_show_bypass_trash_checkbox))
            {
               if (in_array($bt_folder_listing[$i]['option_value'], $bt_show_bypass_trash_checkbox))
                  $bt_folder_listing[$i]['show_bypass_trash_checkbox'] = 1;
               else
                  $bt_folder_listing[$i]['show_bypass_trash_checkbox'] = 0;
            }


            // or apply the defaults from the configuration file
            //
            // (checkbox enabled if in default list, or if NOT in the
            // default "don't show" list (and that list is non-empty))
            //
            else
            {
               if (in_array($bt_folder_listing[$i]['option_value'], $folders_to_show_bypass_trash_checkbox)
                || (!empty($folders_to_not_show_bypass_trash_checkbox) && !in_array($bt_folder_listing[$i]['option_value'], $folders_to_not_show_bypass_trash_checkbox)))
                  $bt_folder_listing[$i]['show_bypass_trash_checkbox'] = 1;
               else
                  $bt_folder_listing[$i]['show_bypass_trash_checkbox'] = 0;
            }
         }
      }
   }


   sq_change_text_domain('empty_folders');


   // bypass trash checkbox not applicable for SM versions 1.5.0+
   //
   if (check_sm_version(1, 5, 0))
      $show_bypass_trash_checkbox_allow_override = 0;


   if (check_sm_version(1, 5, 2))
   {
      global $oTemplate;

      $oTemplate->assign('bt_purge_button_description', $bt_purge_button_description);
      $oTemplate->assign('bypass_trash_description', $bypass_trash_description);
      $oTemplate->assign('bt_show_purge_button_allow_override', $bt_show_purge_button_allow_override);
      $oTemplate->assign('show_bypass_trash_checkbox_allow_override', $show_bypass_trash_checkbox_allow_override);
      $oTemplate->assign('bt_folder_listing', $bt_folder_listing);
      $oTemplate->assign('javascript_on', $javascript_on);
      $oTemplate->assign('color', $color);

      $output = $oTemplate->fetch('plugins/bypass_trash/bypass_trash_options.tpl');
      return array('folders_bottom' => $output);
   }
   else
   {
      global $t;
      $t = array(); // no need to put config vars herein, they are already globalized

      include_once(SM_PATH . 'plugins/bypass_trash/templates/default/bypass_trash_options.tpl');
   }


   sq_change_text_domain('squirrelmail');

}



