<?php

/**
  * SquirrelMail Bypass Trash Plugin
  * Copyright (c) 2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage bypass_trash
  *
  */



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function bypass_trash_check_configuration_do()
{

   // make sure base config is available
   //
   if (!bypass_trash_init())
   {
      do_err('Bypass Trash plugin is missing its main configuration file', FALSE);
      return TRUE;
   }

}



/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function bypass_trash_init()
{

   if (!@include_once (SM_PATH . 'config/config_bypass_trash.php'))
      if (!@include_once (SM_PATH . 'plugins/bypass_trash/config.php'))
         if (!@include_once (SM_PATH . 'plugins/bypass_trash/config_default.php'))
            return FALSE;

   return TRUE;

/* ----------  This is how to do the same thing using the Compatibility plugin
   return load_config('bypass_trash',
                      array('../../config/config_bypass_trash.php',
                            'config.php',
                            'config_default.php'),
                      TRUE, TRUE);
----------- */

}



/**
  * Show bypass trash controls on mailbox list page
  *
  * @param array $buttons The list of buttons being added to when
  *                       using 1.5.2+
  *
  */
function bypass_trash_show_controls_do(&$buttons)
{

   global $show_bypass_trash_checkbox_allow_override, $bypass_trash_text,
          $bypass_trash_title_text, $folders_to_show_bypass_trash_checkbox,
          $folders_to_not_show_bypass_trash_checkbox,
          $trash_folder, $username, $data_dir, $numMessages, $aMailbox,
          $bt_show_purge_button_allow_override, $bt_purge_button_text,
          $bt_purge_button_title_text, $bt_folders_to_show_purge_button,
          $bt_folders_to_not_show_purge_button;



   sqgetGlobalVar('mailbox', $mailbox, SQ_FORM);
   if (empty($mailbox)) $mailbox = 'INBOX';



   // trash folder doesn't need any of this
   //
   if ($mailbox == $trash_folder) return;



   bypass_trash_init();



   // grab user preference for purge button folders
   //
   if ($bt_show_purge_button_allow_override)
      $allFolders = getPref($data_dir, $username,
                            'bt_show_purge_button',
                            NULL);
   else
      $allFolders = NULL;



   // reformat folder list if not NULL (which means defaults apply below)
   //
   if ($allFolders == 'NONE') $allFolders = ''; // see note elsewhere about why we use "NONE"
   if (!is_null($allFolders)) $bt_show_purge_button = explode('###', $allFolders);
   else $bt_show_purge_button = NULL;



   // now figure out if this folder gets a purge button
   //
   // if the user specified a list, just use it to
   // test for what folders have the button turned on
   //
   $show_purge_button = FALSE;
   if (is_array($bt_show_purge_button))
   {
      if (in_array($mailbox, $bt_show_purge_button))
         $show_purge_button = TRUE;
   }


   // or apply the defaults from the configuration file
   //
   // (button enabled if in default list, or if NOT in the
   // default "don't show" list (and that list is non-empty))
   //
   else
   {
      if (in_array($mailbox, $bt_folders_to_show_purge_button)
       || (!empty($bt_folders_to_not_show_purge_button) && !in_array($mailbox, $bt_folders_to_not_show_purge_button)))
         $show_purge_button = TRUE;
   }



   sq_change_text_domain('bypass_trash');



   // display the purge button?
   //
   if ($show_purge_button)
   {

      if (check_sm_version(1, 5, 2))
         $buttons['btPurge'] = array('value' => _($bt_purge_button_text),
                                     'type' => 'submit',
                                     'extra_attrs' => array('title' => _($bt_purge_button_title_text)));
      else if (check_sm_version(1, 5, 1))
         $buttons[1]['btPurge'] = array(0 => _($bt_purge_button_text),
                                        1 => 'submit');
      else
         echo '<input type="submit" name="btPurge" title="' . _($bt_purge_button_title_text) . '" value="' . _($bt_purge_button_text) . "\" />\n";

   }



   // bypass trash checkbox not applicable for SM versions 1.5.0+
   //
   if (!check_sm_version(1, 5, 0))
   {

      // grab user preference for bypass trash checkbox folders
      //
      if ($show_bypass_trash_checkbox_allow_override)
         $allFolders = getPref($data_dir, $username,
                               'bt_show_bypass_trash_checkbox',
                               NULL);
      else
         $allFolders = NULL;



      // reformat folder list if not NULL (which means defaults apply below)
      //
      if ($allFolders == 'NONE') $allFolders = ''; // see note elsewhere about why we use "NONE"
      if (!is_null($allFolders)) $bt_show_bypass_trash_checkbox = explode('###', $allFolders);
      else $bt_show_bypass_trash_checkbox = NULL;



      // now figure out if this folder gets a delete all button
      //
      // if the user specified a list, just use it to
      // test for what folders have the button turned on
      //
      $show_bypass_trash_checkbox = FALSE;
      if (is_array($bt_show_bypass_trash_checkbox))
      {
         if (in_array($mailbox, $bt_show_bypass_trash_checkbox))
            $show_bypass_trash_checkbox = TRUE;
      }


      // or apply the defaults from the configuration file
      //
      // (button enabled if in default list, or if NOT in the
      // default "don't show" list (and that list is non-empty))
      //
      else
      {
         if (in_array($mailbox, $folders_to_show_bypass_trash_checkbox)
          || (!empty($folders_to_not_show_bypass_trash_checkbox) && !in_array($mailbox, $folders_to_not_show_bypass_trash_checkbox)))
            $show_bypass_trash_checkbox = TRUE;
      }



      // display the bypass trash checkbox?
      //
      if ($show_bypass_trash_checkbox)
         echo '<input type="checkbox" name="bypass_trash" id="bypass_trash" title="' . _($bypass_trash_title_text) . '" value="1" /><label for="bypass_trash"> ' . _($bypass_trash_text) . "</label>\n";

   }

   sq_change_text_domain('squirrelmail');

}



/**
  * Add link to action options below message headers
  *
  */
function bypass_trash_show_link_do(&$links)
{

   global $passed_id, $bt_purge_button_text,
          $base_uri, $where, $what, $sort,
          $bt_show_purge_button_allow_override,
          $bt_folders_to_show_purge_button,
          $bt_folders_to_not_show_purge_button,
          $username, $data_dir, $mailbox,
          $bt_show_links_where_buttons_are;
   bypass_trash_init();


   // return if links aren't enabled
   //
   if (!$bt_show_links_where_buttons_are) return;



   // grab user preference for purge button folders
   //
   if ($bt_show_purge_button_allow_override)
      $allFolders = getPref($data_dir, $username,
                            'bt_show_purge_button',
                            NULL);
   else
      $allFolders = NULL;



   // reformat folder list if not NULL (which means defaults apply below)
   //
   if ($allFolders == 'NONE') $allFolders = ''; // see note elsewhere about why we use "NONE"
   if (!is_null($allFolders)) $bt_show_purge_button = explode('###', $allFolders);
   else $bt_show_purge_button = NULL;



   // now figure out if this folder gets a purge button
   //
   // if the user specified a list, just use it to
   // test for what folders have the button turned on
   //
   $show_purge_button = FALSE;
   if (is_array($bt_show_purge_button))
   {
      if (in_array($mailbox, $bt_show_purge_button))
         $show_purge_button = TRUE;
   }


   // or apply the defaults from the configuration file
   //
   // (button enabled if in default list, or if NOT in the
   // default "don't show" list (and that list is non-empty))
   //
   else
   {
      if (in_array($mailbox, $bt_folders_to_show_purge_button)
       || (!empty($bt_folders_to_not_show_purge_button) && !in_array($mailbox, $bt_folders_to_not_show_purge_button)))
         $show_purge_button = TRUE;
   }



   // display the purge button?
   //
   if (!$show_purge_button) return;



   sqgetGlobalVar('mailbox',       $mailbox,       SQ_FORM);
   sqgetGlobalVar('startMessage',  $startMessage,  SQ_FORM);
   sqgetGlobalVar('account',       $account,       SQ_FORM);


   // calculate message list return location
   //
   if (check_sm_version(1, 5, 2))
   {
      global $aMailbox;
      $msgs_url = get_message_list_uri($aMailbox['NAME'], $startMessage, $what);
      if ($where == 'search.php')
         $msgs_url = str_replace('right_main.php', 'search.php', $msgs_url);
   }
   else
   {
      $msgs_url = $base_uri . 'src/';
      if (isset($where) && isset($what))
         $msgs_url .= 'search.php?where=' . urlencode($where)
                    . '&what=' . urlencode($what) . '&mailbox=' . urlencode($mailbox);
      else
         $msgs_url .= 'right_main.php?sort=' . $sort . '&startMessage='
                    . $startMessage . '&mailbox=' . urlencode($mailbox);
   }


   sq_change_text_domain('bypass_trash');

   $uri = sqm_baseuri() . 'plugins/bypass_trash/delete_bypass_trash.php?mailbox='
        . urlencode($mailbox) . '&passed_id=' . $passed_id
        . '&startMessage=' . $startMessage
        . '&account=' . $account
        . '&what=' . urlencode($what)
        . '&dbt=1&location='
        . urlencode($msgs_url);

   if (check_sm_version(1, 5, 2))
      $links = array_merge($links, array(
                           array('URL'  => $uri,
                                 'Text' => _($bt_purge_button_text))));

   else
      echo ' | <a href="' . $uri . '">' . _($bt_purge_button_text) . '</a>';

   sq_change_text_domain('squirrelmail');

}



/**
  * Perform any needed actions when clicked from message list page
  *
  * @param array (only used in 1.5.2) An array consisting of: button name (provided
  *                                   by an external caller - ignore for now), the
  *                                   mailbox cache, the account number, the mailbox
  *                                   name (ignore for now), and a UID list (should
  *                                   be null when we care about handling any actions).
  *
  * @return boolean (only in 1.5.2) TRUE when a button action
  *                                 was handled, FALSE otherwise
  *
  */
function bypass_trash_handle_button_click_do($args)
{

   global $trash_folder;
   if (!sqGetGlobalVar('mailbox', $mailbox, SQ_FORM) || empty($mailbox))
      $mailbox = 'INBOX';


   if (check_sm_version(1, 5, 2))
   {
      $mbox_cache = &$args[1];
      $account_number = $args[2];
      //$mailbox = $args[3];
   }
   else
   {
      $mbox_cache = NULL;
      $account_number = 0;
      //if (!sqGetGlobalVar('mailbox', $mailbox, SQ_FORM) || empty($mailbox))
      //   $mailbox = 'INBOX';
   }



   // currently, we have no actions to perform on the trash folder
   //
   if ($mailbox == $trash_folder) return FALSE;



   // purge some other folder?
   //
   if (sqGetGlobalVar('btPurge', $btPurge, SQ_FORM) && !empty($btPurge))
   {

      // check for UID list, and do the purge
      //
      if (sqGetGlobalVar('msg', $uids, SQ_FORM) && is_array($uids) && !empty($uids))
      {

         global $imapConnection;

         // 1.5.x
         //
         if (check_sm_version(1, 5, 2))
         {
            $error = handleMessageListForm($imapConnection, $mbox_cache, 'setDeleted', $uids, '', TRUE);
            if (!empty($error))
            {
               // TODO: use correct error output mechanism
               //
               echo $error;
               exit;
            }

            return TRUE;
         }


         // 1.4.x
         //
         else
         {
            global $move_to_trash, $auto_expunge, $startMessage, $mbx_response,
                   $show_num, $location;
            $cnt = count($uids);

            // temporarily change "move to trash" setting so message is purged
            //
            $orig_move_to_trash = $move_to_trash;
            $move_to_trash = FALSE;
            sqimap_msgs_list_delete($imapConnection, $mailbox, $uids);
            $move_to_trash = $orig_move_to_trash;

            if ($auto_expunge)
               $cnt = sqimap_mailbox_expunge($imapConnection, $mailbox, true);
            if (($startMessage+$cnt-1) >= $mbx_response['EXISTS'])
            {
               if ($startMessage > $show_num)
                  $location = set_url_var($location,'startMessage',$startMessage-$show_num, false);
               else
                  $location = set_url_var($location,'startMessage',1, false);
            }

            sqimap_logout($imapConnection);
            header("Location: $location");
            exit;
         }

      }

   }



   // now check for the bypass trash checkbox in 1.4.x only
   //
   if (!check_sm_version(1, 5, 0)
    && sqGetGlobalVar('bypass_trash', $bypass_trash, SQ_FORM) && !empty($bypass_trash)
    && sqGetGlobalVar('delete', $delete, SQ_FORM) && !empty($delete))
   {

      // check for UID list, and do the purge
      //
      if (sqGetGlobalVar('msg', $uids, SQ_FORM) && is_array($uids) && !empty($uids))
      {

         global $move_to_trash, $auto_expunge, $startMessage, $mbx_response,
                $imapConnection, $show_num, $location;
         $cnt = count($uids);

         // temporarily change "move to trash" setting so message is purged
         //
         $orig_move_to_trash = $move_to_trash;
         $move_to_trash = FALSE;
         sqimap_msgs_list_delete($imapConnection, $mailbox, $uids);
         $move_to_trash = $orig_move_to_trash;

         if ($auto_expunge)
            $cnt = sqimap_mailbox_expunge($imapConnection, $mailbox, true);
         if (($startMessage+$cnt-1) >= $mbx_response['EXISTS'])
         {
            if ($startMessage > $show_num)
               $location = set_url_var($location,'startMessage',$startMessage-$show_num, false);
            else
               $location = set_url_var($location,'startMessage',1, false);
         }

         sqimap_logout($imapConnection);
         header("Location: $location");
         exit;

      }

   }

}



