/*
   Block Sender - A Plugin for SqurrelMail
   Version: 2.01
   Version Date: 06-Jan-2003
   Author: Derek Battams <derek@battams.ca>
   Please see the README file for further information

   File: ibsrc/isBlocked.c

DATE          AUTHOR   CHANGE
=============================================================================
06-Jan-2003   ddb      Initial version

C program for checking if an address is blocked - used by procmail
*/

/* REQUIRED INCLUDES */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* IF YOU'RE HAVING PROBLEMS WITH THIS CODE COMPILING IT'S LIKELY THAT THE #INCLUDE LINE BELOW NEEDS TO BE CHANGED */
#include <mysql/mysql.h>

/* CONST DEFINITIONS */
#define REQ_ARGS 7           /* Number of command line arguments required for proper operation */
#define SQL_QRY_BUF 1024     /* Allocated buffer size for SQL statements */
#define PWD_BUF 128          /* Allocated buffer size for MySQL password */
#define EMAIL_SEP '@'        /* Separates email user from email domain */
#define NEWLINE_CHAR '\n'
#define NULL_CHAR '\0'

/* PROGRAM ERROR MESSAGES */
#define MYSQL_INIT_FAIL "Can't initialize MySQL object!"
#define MYSQL_BAD_PWD "Invalid MySQL password!"
#define MYSQL_CONNECT_FAIL "Can't connect to MySQL host!"
#define PWD_FILE_FAIL "Can't open password file!"
#define MYSQL_QRY_FAIL "SQL query failed!"
#define MYSQL_RESULT_FAIL "Can't get result set!"

/* FUNCTION PROTOTYPES */
void printUsage();
void fatalError(char *msg);
int setMysqlPwd(char *pwd, char *file);
int chkDatabase(MYSQL *mysql, char *smuser, char *sender);
int runQuery(MYSQL *mysql, char *qry);

/* main() function */
int main(int argc, char *argv[])
{
MYSQL mysql;                /* MySQL object */
int   retVal;               /* Return value of program */
char  *mysqlHost,           /* Host name of the MySQL server */
      *mysqlID,             /* ID of the MySQL user */
      *mysqlDB,             /* Name of the MySQL database to use */
      *mysqlPwdLoc,         /* Location of the file containing the MySQL user password */
      *smUser,              /* Name of the SM user receiving the message */
      *senderAddr,          /* Email address of the sender - the addres we're checking to see if it's blocked */
      qry[SQL_QRY_BUF],     /* Buffer to hold a SQL query */
      mysqlPwd[PWD_BUF];    /* MySQL password */

   if(argc < REQ_ARGS) // Ensure the program was called with the appropriate number of arguments
      printUsage();

   /* Assign the arguments to meaningful variable names, makes reading the code MUCH easier - everyone should do this! */
   mysqlHost = argv[1],
   mysqlID = argv[2],
   mysqlDB = argv[3],
   mysqlPwdLoc = argv[4],
   smUser = argv[5],
   senderAddr = argv[6];

   if(!mysql_init(&mysql))
      fatalError(MYSQL_INIT_FAIL);

   if(!setMysqlPwd(mysqlPwd, mysqlPwdLoc))
      fatalError(MYSQL_BAD_PWD);

   if(!mysql_real_connect(&mysql, mysqlHost, mysqlID, mysqlPwd, mysqlDB, 0, NULL, 0))
      fatalError(MYSQL_CONNECT_FAIL);

   retVal = chkDatabase(&mysql, smUser, senderAddr);
   mysql_close(&mysql);

   return !retVal;
}

/* Simply print a usage block to stdout then terminate the program with an error status */
void printUsage()
{
   puts("Usage: isBlocked <host> <id> <db> <passwd file> <smuser> <email>");
   puts("host: hostname of MySQL host; use localhost if server is local");
   puts("id: MySQL ID to use");
   puts("db: MySQL database name to connect to");
   puts("passwd file: Location of the file containing the MySQL ID password");
   puts("smuser: Receipient ID of the email message");
   puts("email: Sender address of the email message");
   exit(EXIT_FAILURE);
   return;
}

/* Write msg to stdout then terminate the program with an error status */
void fatalError(char *msg)
{
   puts(msg);
   exit(EXIT_FAILURE);
   return;
}

/* Given the path to a file, file, read the text from the file and store it in pwd less any trailing newlines */
/* Return the length of the read password */
int setMysqlPwd(char *pwd, char *file)
{
FILE *fp;
char passwd[PWD_BUF];

   if((fp = fopen(file, "r")) == NULL)
      fatalError(PWD_FILE_FAIL);
   fgets(passwd, PWD_BUF, fp);
   fclose(fp);

   if(passwd[strlen(passwd)-1] == NEWLINE_CHAR)
      passwd[strlen(passwd)-1] = NULL_CHAR;
   strncpy(pwd, passwd, PWD_BUF);
   return strlen(pwd);
}

/* Given a receipient user, smuser, and an email address, sender, check the MySQL database represented by mysql to see */
/* if smuser has blocked sender or sender's domain.  Return 1 if sender should be blocked or 0 otherwise. */
int chkDatabase(MYSQL *mysql, char *smuser, char *sender)
{
MYSQL_RES *resultSet;                         /* MySQL result set object */
char qry[SQL_QRY_BUF];                        /* Buffer for SQL query */
char *domain = strchr(sender, EMAIL_SEP) + 1, /* Domain of the sender */
     sqlDomain[strlen(domain) * 2 + 1],       /* SQL escaped version of domain */
     sqlSender[strlen(sender) * 2 + 1],       /* SQL escaped version of sender */
     sqlUser[strlen(smuser) * 2 + 1];         /* SQL escaped version of smuser */

   /* Initialize SQL data */
   mysql_real_escape_string(mysql, sqlDomain, domain, strlen(domain));
   mysql_real_escape_string(mysql, sqlSender, sender, strlen(sender));
   mysql_real_escape_string(mysql, sqlUser, smuser, strlen(smuser));

   sprintf(qry, "SELECT user FROM blocked WHERE user='%s' AND email='*@%s'", sqlUser, sqlDomain);
   if(runQuery(mysql, qry))
      return 1; /* User blocked the entire domain */

   sprintf(qry, "SELECT user FROM blocked WHERE user='%s' AND email='%s'", sqlUser, sqlSender);
   if(runQuery(mysql, qry))
      return 1; /* Given address has been blocked */

   return 0; /* No match! */
}

/* Given a query, qry, run it against the MySQL database, mysql.  Returns 1 on success or 0 if no match is found */
int runQuery(MYSQL *mysql, char *qry)
{
MYSQL_RES *resultSet;
int retVal;

   if(mysql_query(mysql, qry))
      fatalError(MYSQL_QRY_FAIL);

   if((resultSet = mysql_store_result(mysql)) == NULL)
      fatalError(MYSQL_RESULT_FAIL);

   if(mysql_num_rows(resultSet) == 1)
      retVal = 1; /* Match */
   else
      retVal = 0; /* No match */

   mysql_free_result(resultSet);
   return retVal;
}
