<?php
/*
   Block Sender - A Plugin for SqurrelMail
   Version: 0.2 (BETA)
   Version Date: 24-Feb-2002
   Author: Derek Battams <derek@battams.ca>
   Please see the README file for further information

   File: options.php

DATE          AUTHOR   CHANGE
=============================================================================
21-Feb-2002   ddb      Completion of original version

Contains code for the options page.  The options page for this plugin allows
the user to modify their blocked senders list.
*/

chdir('..');
require_once('../src/validate.php');
require_once('../functions/page_header.php');
$blockFile = $data_dir . $username . ".block";
?>

<html>
<?php displayPageHeader($color, 'None'); ?>

<br>
<table width=95% align=center border=0 cellpadding=2 cellspacing=0><tr><td
 bgcolor="<?php echo $color[0] ?>">
         <center><b><?php echo _("Options") ?> - Blocked Senders List</b></center>
      </td></tr>
<tr><td>
<?php
if($action == "editList")
{
   echo "<p>";
   switch(writeList($blockList, $blockFile))
   {
      case TRUE:
          echo "<b><i>Your blocked list has been updated!</i></b>";
          break;
      default:
          echo "<b><i>There was an error updating your blocked list!  Please try again or report this error to your system administrator if this problem continues!</i></b>";
   }
   echo "</p>\n";
}
?>

<p>
   The list below shows all of the addresses that are currently being blocked.  Any e-mail received from addresses listed below will be automatically delivered to your <b>Trash</b> folder.  You may remove or add addresses to your list below.  Addresses must be listed <b>one</b> per line.  Click on "Update List" when done.
</p>

<p align="center">
<form action="<?php echo $PHP_SELF; ?>" method="POST">
   <input type="hidden" name="action" value="editList">
<textarea name="blockList" rows="15" cols="60">
<?php @readfile($blockFile); ?>
</textarea><br>
   <input type="submit" name="submit" value="Update List">
</form></p></td></tr></table>
</body>
</html>

<?php
// Given the update list, $list, write it to the file, $file
function writeList($list, $file)
{
   if($fp = fopen($file, "w"))
   {
      fputs($fp, $list);
      if($list != "")
         fputs($fp, "\n");
   }
   return fclose($fp);
}
?>
