<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@advcs.org
    Home Site ...... http://www.advcs.org/
    Program ........ Block Attachments
    Version ........ 0.6
    Purpose ........ Allows an admin to block any types of attachments

*******************************************************************************/

define('SM_PATH','../../');

/* SquirrelMail required files. */
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/page_header.php');
require_once(SM_PATH . 'functions/imap.php');
require_once(SM_PATH . 'include/load_prefs.php');

global $username;

$admins = array();
if (!@file_exists(SM_PATH . 'config/admins')) return;
$file = @fopen(SM_PATH . 'config/admins',r);
while (!@feof($file)){
   $x = trim(@fgets($file,100));
   if (strlen($x)>0)
      $admins[]= $x;
}
@fclose($file);

$auth = in_array($username, $admins);
if (!$auth) return;

$filename = SM_PATH . 'plugins/block_attach/blocked_attachments.php';
if (!file_exists($filename)) {
   touch($filename);
   $blocked = Array('scr','pif','bat','vbs');
   $warning = Array('exe','com');
   $excluded = Array('');
   CreateBlockedArray($blocked,$warning,$excluded,$filename);
}

include_once($filename);

include_once(SM_PATH . 'plugins/block_attach/includes/display_save.php');

displayPageHeader($color, 'None');

bindtextdomain('block_attach', SM_PATH . 'plugins/block_attach/locale');
textdomain('block_attach');

print "<br><center><font size=+1>". _("Block Attachments") . "<br>". _("Admin Interface") . "</font></center>\n";
print "<center><table><form method=post action=\"" . SM_PATH . "plugins/block_attach/options.php\">\n";
print "<tr><td colspan=4><hr width='100%' color='$color[9]'></td></tr>";
print "<tr><td colspan=2>" . _("Add a file extension") . "<br><input type=text name='newb' maxlength=5> <input type=submit name=submit value='" . _("Add") . "'><br>";
print "<input type=radio name='give' value='warning' checked>&nbsp;". _("Warning") . "&nbsp;&nbsp;&nbsp;&nbsp;";
print "<input type=radio name='give' value='block'>&nbsp;". _("Block") . "<br>";
print "</form></td>";

print '<td colspan=2><center><form method=post action="' . SM_PATH . 'plugins/block_attach/options.php">&nbsp;&nbsp;&nbsp;&nbsp;' . _("Add an excluded user") . '<br>';
print "&nbsp;&nbsp;&nbsp;&nbsp;<input type=text name='exu' maxlength=50><input type=submit name=submit value='" . _("Add") . "'><br><br><br>";
print "</td></tr>\n";

print "<tr><td colspan=4><hr width='100%' color='$color[9]'></td></tr>\n<tr>";
print '<td><center><form method=post action="' . SM_PATH . 'plugins/block_attach/options.php">' . _("Give Warning") . '<br><select name="wtypes" size=5>\n';
foreach($warning as $value) {
   if (strlen($value)>0)
      print "<option value='$value'>*.$value</option>\n";
}
print "</select><br><input type=submit name=submit value='" . _("Remove") . "'></form></td>\n";
print '<td><center><form method=post action="' . SM_PATH . 'plugins/block_attach/options.php">' . _("Block") . '<br><select name="btypes" size=5>\n';
foreach($blocked as $value) {
   if (strlen($value)>0)
      print "<option value='$value'>*.$value</option>\n";
}
print "</select><br><input type=submit name=submit value='" . _("Remove") . "'></form></td>\n";


print '<td><center><form method=post action="' . SM_PATH . 'plugins/block_attach/options.php">' . _("Excluded Users") . '<br><select name="exclude" size=5>\n';
foreach($excluded as $value) {
   if (strlen($value)>0)
      print "<option value='$value'>$value</option>\n";
}
print "</select><br><input type=submit name=submit value='" . _("Remove") . "'></form></center></td></tr>\n";

print "<tr><td colspan=4><hr width='100%' color='$color[9]'></td></tr>";
print "</table></center>\n";

textdomain('squirrelmail');

function CreateBlockedArray($blocked, $warning, $excluded, $filename) {
   $string = "<?php\r\n\r\nglobal \$blocked;\r\n\r\n";
   $string .= "\$excluded = Array(";
   $string .= OutputBlockedArray($excluded);
   $string .= ");\r\n\r\n";
   $string .= "\$blocked = Array(";
   $string .= OutputBlockedArray($blocked);
   $string .= ");\r\n\r\n";
   $string .= "\$warning = Array(";
   $string .= OutputBlockedArray($warning);
   $string .= ");\r\n\r\n?>";
   if ($file =  @fopen($filename, 'w')) {
      @fwrite ($file, $string);
     @fclose($file);
   }
}

function OutputBlockedArray($ar, $name = '') {
   $string = '';
   $end = count($ar);
   $c = 0;
   sort($ar);
   reset($ar);
   foreach ($ar as $key => $value) {
      $c++;
      if (!is_array($value)) {
         $string .= "'$value'";
         if ($c != $end) 
            $string .= ",\r\n";
      }
   }
   return $string;
}
?>