<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@advcs.org
    Home Site ...... http://www.advcs.org/
    Program ........ Block Attachments
    Version ........ 0.1
    Purpose ........ Allows an admin to block any types of attachments

*******************************************************************************/

define('SM_PATH','../../');

/* SquirrelMail required files. */
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/page_header.php');
require_once(SM_PATH . 'functions/imap.php');
require_once(SM_PATH . 'include/load_prefs.php');

global $username;

include_once(SM_PATH . 'plugins/block_attach/admins.php');
if (!in_array($username,$admin)) header("Location " . SM_PATH . "index.php");

$filename = SM_PATH . 'plugins/block_attach/blocked_attachments.php';
if (!file_exists($filename)) {
   touch($filename);
   $blocked = Array('exe','scr','pif','bat','com','vbs');
   $allowblockeddownloads = false;
   CreateBlockedArray($blocked,$allowblockeddownloads,$filename);
}

include_once($filename);

include_once(SM_PATH . 'plugins/block_attach/includes/display_save.php');

displayPageHeader($color, 'None');

print "<br><center><font size=+1>Blocked Attachments<br>Admin Interface</font></center>\n";
print "<br><center><table><form method=post action=\"" . SM_PATH . "plugins/block_attach/options.php\">\n";
print "<tr><td colspan=2><hr width=\'100%' color='$color[9]'></td></tr>";
print "<tr><td colspan=2>Add a blocked attachment<br><input type=text name='newb' maxlength=5> <input type=submit name=submit value='Add'></form></td></tr>\n";

print "<tr><td colspan=2><hr width=\'100%' color='$color[9]'></td></tr>";
print '<tr><td><form method=post action="' . SM_PATH . 'plugins/block_attach/options.php"><select name="btypes" size=8>\n';
foreach($blocked as $value) {
   if (strlen($value)>0)
      print "<option value='$value'>*.$value</option>\n";
}
print "</select></td>\n<td><input type=submit name=submit value='Remove'></form></td></tr>\n";
print "<tr><td colspan=2><hr width=\'100%' color='$color[9]'></td></tr>";
print "</table></center>\n";

print "<br><center><table><form method=post action=\"" . SM_PATH . "plugins/block_attach/options.php\">\n";
print "<tr><td colspan=2>Allow downloads, but give warning.<input type=radio name='allowed' value=1";
if ($allowblockeddownloads) print " checked";
print ">&nbsp;Yes&nbsp;<input type=radio name='allowed' value=0";
if (!$allowblockeddownloads) print " checked";
print ">&nbsp;No<br><center><input type=submit name=submit value='Save'></center></form></td></tr></table>\n";


function CreateBlockedArray($blocked, $allowblockeddownloads, $filename) {
   $string = "<?php\r\n\r\nglobal \$blocked;\r\n\r\n";
   $string .= "\$allowblockeddownloads = ";
   if ($allowblockeddownloads)
      $string .= "true";
   else
      $string .= "false";
   $string .= ";\r\n\r\n";
   $string .= "\$blocked = Array(";
   $string .= OutputBlockedArray($blocked);
   $string .= ");\r\n\r\n?>";
   if ($file =  @fopen($filename, 'w')) {
      @fwrite ($file, $string);
     @fclose($file);
   }
}

function OutputBlockedArray($ar, $name = '') {
   $string = '';
   $end = count($ar);
   $c = 0;
   sort($ar);
   reset($ar);
   foreach ($ar as $key => $value) {
      $c++;
      if (!is_array($value)) {
         $string .= "'$value'";
         if ($c != $end) 
            $string .= ",\r\n";
      }
   }
   return $string;
}
?>