<?php
include_once(SM_PATH . 'plugins/bayesspam/config.php');

/* Initialize the plugin */

function squirrelmail_plugin_init_bayesspam() {
   global $squirrelmail_plugin_hooks, $bayesdbhandle;
   if ($bayesdbhandle == null)
      return;

   $squirrelmail_plugin_hooks['optpage_register_block']['bayesspam'] =
      'bayesspam_options_hook';
   $squirrelmail_plugin_hooks['loading_prefs']['bayesspam'] =
      'bayesspam_load_hook';
   $squirrelmail_plugin_hooks['read_body_header']['bayesspam'] =
      'bayesspam_display_hook';
   $squirrelmail_plugin_hooks['webmail_bottom']['bayesspam'] =
      'bayesspam_rebuild_corpus_do';
   $squirrelmail_plugin_hooks['left_main_after']['bayesspam'] =
      'bayesspam_rebuild_corpus_do';
   $squirrelmail_plugin_hooks['left_main_before']['bayesspam'] = 
      'bayesspam_filter_hook';
   $squirrelmail_plugin_hooks['right_main_after_header']['bayesspam'] = 
      'bayesspam_filter_hook';
   $squirrelmail_plugin_hooks['special_mailbox']['bayesspam'] =
      'bayesspam_special_mailbox';
   $squirrelmail_plugin_hooks['mailbox_display_buttons']['bayesspam'] = 
      'bayesspam_buttons';
   $squirrelmail_plugin_hooks['move_messages_button_action']['bayesspam'] = 
      'bayesspam_button_action_hook';
   $squirrelmail_plugin_hooks['mailbox_display_button_action']['bayesspam'] =
      'bayesspam_button_action_hook';
}

function bayesspam_options_hook () {
   include_once(SM_PATH . 'plugins/bayesspam/bayesspam_functions.php');
   bayesspam_options();
}

function bayesspam_load_hook () {
   include_once(SM_PATH . 'plugins/bayesspam/bayesspam_functions.php');
   bayesspam_load();
}

function bayesspam_display_hook () {
   include_once(SM_PATH . 'plugins/bayesspam/bayesspam_functions.php');
   bayesspam_display();
}

function bayesspam_rebuild_corpus_do () {
   include_once(SM_PATH . 'plugins/bayesspam/bayesspam_functions.php');
   bayesspam_rebuild_corpus();
}

function bayesspam_filter_hook ($args) {
   include_once(SM_PATH . 'plugins/bayesspam/bayesspam_functions.php');
   bayesspam_prune_spam($args);
   bayesspam_filter($args);
}

function bayesspam_prune_spam ($args) {
   if ($args[0] == 'left_main_before' && isset($_SESSION['just_logged_in']) && $_SESSION['just_logged_in'] == true) {
      include_once(SM_PATH . 'plugins/bayesspam/bayesspam_functions.php');
      bayesspam_prune();
   }
}

function bayesspam_special_mailbox ($args) {
   if ($args == $GLOBALS['bayesspam_folder'])
      return true;
   if ($args == $GLOBALS['bayesspam_uncertain_folder'])
      return true;   
   return false;
}

function bayesspam_buttons () {
   include_once(SM_PATH . 'plugins/bayesspam/bayesspam_functions.php');
   bayesspam_show_buttons();
}

function bayesspam_button_action_hook ($id) {
   include_once(SM_PATH . 'plugins/bayesspam/bayesspam_functions.php');
   bayesspam_button_action ($id);
}

function bayesspam_version() {
   return '3.6';
}

?>
