<?php
require_once(SM_PATH . 'plugins/bayesspam/config.php');

/* Initialize the plugin */
function squirrelmail_plugin_init_bayesspam() {
	$GLOBALS['bayesdbhandle'] = DB::connect($GLOBALS['bayesdbtype'].'://'.$GLOBALS['bayesdbuser'].':'.$GLOBALS['bayesdbpass'].'@'.$GLOBALS['bayesdbhost'].':'.$GLOBALS['bayesdbport'].'/'.$GLOBALS['bayesdbname']);
	if (DB::isError($GLOBALS['bayesdbhandle'])) {
		echo 'BayesSpam improperly configured. Check DB Information.';
		return;
	}
	$GLOBALS['bayesdbhandle']->setFetchMode(DB_FETCHMODE_ASSOC);

	$GLOBALS['squirrelmail_plugin_hooks']['optpage_register_block']['bayesspam'] =
		'bayesspam_options';
	$GLOBALS['squirrelmail_plugin_hooks']['loading_prefs']['bayesspam'] =
		'bayesspam_load';
	$GLOBALS['squirrelmail_plugin_hooks']['read_body_header']['bayesspam'] =
		'bayesspam_display';
	$GLOBALS['squirrelmail_plugin_hooks']['webmail_bottom']['bayesspam'] =
		'bayesspam_rebuild_corpus_hook';
	$GLOBALS['squirrelmail_plugin_hooks']['left_main_after']['bayesspam'] =
		'bayesspam_rebuild_corpus_hook';
	$GLOBALS['squirrelmail_plugin_hooks']['left_main_before']['bayesspam'] = 
		'bayesspam_filter';
	$GLOBALS['squirrelmail_plugin_hooks']['right_main_after_header']['bayesspam'] = 
		'bayesspam_filter';
}

function bayesspam_rebuild_corpus_hook($args) {
	$res = $GLOBALS['bayesdbhandle']->query('SELECT IF(UNIX_TIMESTAMP(LastRebuild)<(UNIX_TIMESTAMP(NOW())-'.($GLOBALS['bayes_autorebuild_timeout']*60).'),1,0) AS Rebuild FROM users WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
	$row = $res->fetchRow();

	if ($row['Rebuild']) {
		if($args[0] == 'webmail_bottom' && $GLOBALS['bayesspam_rebuild_on_login']) {
			bayesspam_rebuild_corpus();
		}
	
		if($args[0] == 'left_main_after' && $GLOBALS['bayesspam_rebuild_on_refresh']) {
			bayesspam_rebuild_corpus();
		}
	}
}

// Load the settings
// Validate some of it (make '' into 'default', etc.)
function bayesspam_load() {
	$GLOBALS['bayesspam_links_enabled'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_links_enabled');
	$GLOBALS['bayesspam_filtering_enabled'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_filtering_enabled');
	$GLOBALS['bayesspam_delete'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_delete');
	$GLOBALS['bayesspam_folder'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_folder');
	$GLOBALS['bayesspam_autolearn'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_autolearn');
	$GLOBALS['bayesspam_rebuild_on_login'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_rebuild_on_login');
	$GLOBALS['bayesspam_rebuild_on_refresh'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_rebuild_on_refresh');
	$GLOBALS['bayesspam_show_prob'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_show_prob');
	$GLOBALS['bayesspam_scan_size'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_scan_size');
	$GLOBALS['bayesspam_inboxonly'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_inboxonly');
	$GLOBALS['bayesspam_do_user_stats'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_do_user_stats');
	$GLOBALS['bayesspam_do_uncertain_filtering'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_do_uncertain_filtering');
	$GLOBALS['bayesspam_uncertain_folder'] = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_uncertain_folder');

	if ($GLOBALS['bayesspam_scan_size'] == '') {
		$GLOBALS['bayesspam_scan_size'] = $GLOBALS['bayes_default_scan_size'];
		setPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_scan_size', $GLOBALS['bayesspam_scan_size']);
	}

	$GLOBALS['bayesspam_ignore_folders'] = array();
	for ($i=0; $load = getPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_ignore_folders_'.$i); $i++) {
		$GLOBALS['bayesspam_ignore_folders'][$i] = $load;
	}

	if ($GLOBALS['bayesspam_folder'] == '') {
		$GLOBALS['bayesspam_folder'] = 'INBOX.Trash';
		setPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_folder', $GLOBALS['bayesspam_folder']);
	}

	if(!$GLOBALS['bayesspam_ignore_folders']) {
		$GLOBALS['bayesspam_ignore_folders'][] = 'INBOX.Trash';
		$GLOBALS['bayesspam_ignore_folders'][] = $GLOBALS['bayesspam_folder'];

		array_unique($GLOBALS['bayesspam_ignore_folders']);
		$temp = array();
		foreach ($GLOBALS['bayesspam_ignore_folders'] as $value) {
			$temp[] = $value;
		}	
		$GLOBALS['bayesspam_ignore_folders'] = $temp;
		
		for ($i=0; $i<count($GLOBALS['bayesspam_ignore_folders']); $i++) {
			setPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_ignore_folders_'.$i, $GLOBALS['bayesspam_ignore_folders'][$i]);
		}
	} elseif (!in_array('INBOX.Trash', $GLOBALS['bayesspam_ignore_folders'])) {
		$GLOBALS['bayesspam_ignore_folders'][] = 'INBOX.Trash';
		for ($i=0; $i<count($GLOBALS['bayesspam_ignore_folders']); $i++) {
			setPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_ignore_folders_'.$i, $GLOBALS['bayesspam_ignore_folders'][$i]);
		}
	} elseif (!in_array($GLOBALS['bayesspam_folder'], $GLOBALS['bayesspam_ignore_folders'])) {
		$GLOBALS['bayesspam_ignore_folders'][] = $GLOBALS['bayesspam_folder'];
		for ($i=0; $i<count($GLOBALS['bayesspam_ignore_folders']); $i++) {
			setPref($GLOBALS['data_dir'], $GLOBALS['username'], 'bayesspam_ignore_folders_'.$i, $GLOBALS['bayesspam_ignore_folders'][$i]);
		}
	}
}


function bayesspam_display() {
	$version_array = split('\.', $GLOBALS['version']);

	if ($GLOBALS['bayesspam_show_prob']) {
		$is_spam = bayesspam_get_probability($GLOBALS['imapConnection'], $GLOBALS['passed_id']);

		$do_popup_link = 1;

		if (!isset($GLOBALS['token_display_string'])) {
			$GLOBALS['token_display_string'] = 'Recalculate score to view interesting tokens.';
			$do_popup_link = 0;
		}

		$s = '';

		if ($do_popup_link) {
			$s =<<<EOL
<script language="javascript">
<!--
function do_bayesspam_popup() {
	bayesspamWindow = window.open("","bayesspamWindow","scrollbars=yes,resizable=yes,width=450,height=725"); 
	bayesspamWindow.document.write("<HTML><TITLE>BayesSpam Token Info</TITLE><BODY bgcolor=#ffffff>");
	bayesspamWindow.document.write("<table border=0 width=100%>");
	bayesspamWindow.document.write("$GLOBALS[token_html_display_string]");
	bayesspamWindow.document.write("</table>");
	bayesspamWindow.document.write("</BODY></HTML>");
	bayesspamWindow.document.close();
}
//-->
</script>
EOL;
		}

		$s .= '<TR BGCOLOR="'.$GLOBALS['color'][0].'">';

		if ($version_array[0] == 1 && $version_array[1] <= 2) {
			$s .=   '<TD align=right valign=top width=20%>BayesSpam Probability:</TD>'."\n";
			$s .=   '<TD align=left valign=top width=80% colspan=2>';
			if ($do_popup_link) {
				$s .= '<a href="javascript:do_bayesspam_popup()">';
			}
			$s .=   '<b title="'.$GLOBALS['token_display_string'].'">'. number_format($is_spam*100,2).'%';
			if ($GLOBALS['bayes_was_cached']) {
				$s .= ' (Cached)';
			} else {
				$s .= ' (Calculated)';
			}
			$s .=   '</b></a></td>' . "\n";
		} else {
			$s .=   '<TD align=right valign=top width=20%><b>BayesSpam Probability:&nbsp;&nbsp;</b></TD>'."\n";
			$s .=   '<TD align=left valign=top width=80% colspan=2>';
			if ($do_popup_link) {
				$s .= '<a href="javascript:do_bayesspam_popup()">';
			}
			$s .= '<span title="'.$GLOBALS['token_display_string'].'">'. number_format($is_spam*100,2).'%';
			if ($GLOBALS['bayes_was_cached']) {
				$s .= ' (Cached)';
			} else {
				$s .= ' (Calculated)';
			}
			$s .=   '</span></a></td>' . "\n";
		}
		$s .= '</TR>';
	
		echo $s;
	}
	
	if (!$GLOBALS['bayesspam_links_enabled']) {
		return;
	}

	$s = '';

	$s .= '<TR BGCOLOR="'.$GLOBALS['color'][0].'">';
	if ($version_array[0] == 1 && $version_array[1] <= 2) {
		$s .=   '<TD align=right valign=top width=20%>BayesSpam Links:</TD>'."\n";
		$s .=   '<TD align=left valign=top width=80% colspan=2><b>';
	} else {
		$s .=   '<TD align=right valign=top width=20%><b>BayesSpam Links:&nbsp;&nbsp;</b></TD>'."\n";
		$s .=   '<TD align=left valign=top width=80% colspan=2>';	
	}
	
	if (!$GLOBALS['bayesspam_show_prob']) {
		$tokens = bayesspam_get_tokens($GLOBALS['imapConnection'],$GLOBALS['passed_id']);
	}

	$check = bayesspam_check_messageid();
	
	if ($check == 'spam') {
		$s .= 'Known As Spam</b> -- <small><a href="../plugins/bayesspam/bayesspam_learn.php?bayes_type=nonspam&passed_id='.urlencode($GLOBALS['passed_id']);
		$s .= '&mailbox='.urlencode($GLOBALS['mailbox']);
		$s .= '&startMessage='.urlencode($GLOBALS['startMessage']);
		$s .= '&show_more='.urlencode($GLOBALS['show_more']);
		$s .= '">Move to NonSpam</a> | ';
	} elseif ($check == 'nonspam') {
		$s .= 'Known As NonSpam</b> -- <small><a href="../plugins/bayesspam/bayesspam_learn.php?bayes_type=spam&passed_id='.urlencode($GLOBALS['passed_id']);
		$s .= '&mailbox='.urlencode($GLOBALS['mailbox']);
		$s .= '&startMessage='.urlencode($GLOBALS['startMessage']);
		$s .= '&show_more='.urlencode($GLOBALS['show_more']);
		$s .= '">Move to Spam</a> | ';	
	} else {
		$s .= 'Not In DB</b> -- <small><a href="../plugins/bayesspam/bayesspam_learn.php?bayes_type=spam&passed_id='.urlencode($GLOBALS['passed_id']);
		$s .= '&mailbox='.urlencode($GLOBALS['mailbox']);
		$s .= '&startMessage='.urlencode($GLOBALS['startMessage']);
		$s .= '&show_more='.urlencode($GLOBALS['show_more']);
		$s .= '">Spam</a> | ';
		$s .= '<a href="../plugins/bayesspam/bayesspam_learn.php?bayes_type=nonspam&passed_id='.urlencode($GLOBALS['passed_id']);
		$s .= '&mailbox='.urlencode($GLOBALS['mailbox']);
		$s .= '&startMessage='.urlencode($GLOBALS['startMessage']);
		$s .= '&show_more='.urlencode($GLOBALS['show_more']);
		$s .= '">NonSpam</a> | ';
	}
	$s .= '<a href="../src/read_body.php?passed_id='.urlencode($GLOBALS['passed_id']);
	$s .= '&mailbox='.urlencode($GLOBALS['mailbox']);
	$s .= '&startMessage='.urlencode($GLOBALS['startMessage']);
	$s .= '&show_more='.urlencode($GLOBALS['show_more']);
	$s .= '&bayes_recache=1">Recalculate Score</a>';
	$s .= '</small></td>' . "\n";
	$s .= '</TR>';
	
	echo $s;
}

// Show the link to our own custom options page
function bayesspam_options() {
	$GLOBALS['optpage_blocks'][] = array(
		'name' => _('BayesSpam - Intelligent Spam Filtering'),
		'url' => '../plugins/bayesspam/options.php',
		'desc' => _('An intelligent mail filter that actually learns what you consider to be spam. Uses Bayesian filtering to very accurately filter out your spam.'),
		'js' => false
	);
}

?>
