<?php 
require_once(SM_PATH . 'plugins/bayesspam/config.php');
require_once(SM_PATH . 'functions/imap.php');
require_once(SM_PATH . 'functions/mailbox_display.php');

function bayesspam_nuke_db() {
	$sql0 = 'DELETE FROM Corpus WHERE UserName=\''.$GLOBALS['bayes_username'].'\'';
	$sql1 = 'DELETE FROM nonspamOccurences WHERE UserName=\''.$GLOBALS['bayes_username'].'\'';
	$sql2 = 'DELETE FROM spamOccurences WHERE UserName=\''.$GLOBALS['bayes_username'].'\'';
	$sql3 = 'DELETE FROM Messages WHERE UserName=\''.$GLOBALS['bayes_username'].'\'';
	$sql4 = 'DELETE FROM ScoreCache WHERE UserName=\''.$GLOBALS['bayes_username'].'\'';
	$sql5 = 'UPDATE users SET nonspamCount=0,spamCount=0,LastAdd=NOW(),LastRebuild=NOW() WHERE UserName=\''.$GLOBALS['bayes_username'].'\'';

	$GLOBALS['bayesdbhandle']->query($sql0);
	$GLOBALS['bayesdbhandle']->query($sql1);
	$GLOBALS['bayesdbhandle']->query($sql2);
	$GLOBALS['bayesdbhandle']->query($sql3);
	$GLOBALS['bayesdbhandle']->query($sql4);
	$GLOBALS['bayesdbhandle']->query($sql5);
}

function bayesspam_add_messageid($type) {
	$sql = 'REPLACE INTO Messages VALUES(\''.$GLOBALS['bayes_username'].'\',\''.$GLOBALS['bayes_message_id'].'\',\''.$type.'\',NULL)';
	$GLOBALS['bayesdbhandle']->query($sql);
}

function bayesspam_del_messageid($type) {
	$sql = 'DELETE FROM '.$type.'Messages WHERE UserName=\''.$GLOBALS['bayes_username'].'\' AND MessageID=\''.$GLOBALS['bayes_message_id'].'\'';
	$GLOBALS['bayesdbhandle']->query($sql);
}

function bayesspam_check_messageid() {
	$sql = 'SELECT * FROM Messages WHERE UserName=\''.$GLOBALS['bayes_username'].'\' AND MessageID=\''.$GLOBALS['bayes_message_id'].'\'';
	$res = $GLOBALS['bayesdbhandle']->query($sql);

	$row = $res->fetchRow();
	
	if ($row) {
		return $row['Type'];
	} else {
		return FALSE;
	}
}

function bayesspam_do_learn($type,$oldarray,$newarray,$count,$skip_check=0) {
	$check = FALSE;
	
	if ($skip_check || (($check = bayesspam_check_messageid()) != $type)) {
		if (!$skip_check && $check) {
			$old_occurences = bayesspam_get_occurences($check);
			$update = array();
			foreach ($newarray as $token=>$value) {
				if (isset($old_occurences[$token])) {
					if ($check == 'spam') {
						$update[$token] = $old_occurences[$token] - $value;
					} elseif ($check == 'nonspam') {
						$update[$token] = $old_occurences[$token] - ($value*2);
					}
				}
			}

			$sql = 'REPLACE INTO '.$check.'Occurences VALUES ';
			$i = 1;
			foreach ($update as $token=>$value) {
				$sql .= '(\''.$GLOBALS['bayes_username'].'\',\''.addslashes(substr($token,5)).'\','.$value.',NULL)';
				if ($i < count($update)) {
					$sql .= ',';
				}
				$i++;
			}

			$GLOBALS['bayesdbhandle']->query($sql);
		}
	
		foreach ($newarray as $token=>$value) {
			@$newarray[$token] += $oldarray[$token];
		}
	
		$sql = 'REPLACE INTO '.$type.'Occurences VALUES ';
		$i = 1;
		foreach ($newarray as $token=>$value) {
			$sql .= '(\''.$GLOBALS['bayes_username'].'\',\''.addslashes(substr($token,5)).'\','.$value.',NULL)';
			if ($i < count($newarray)) {
				$sql .= ',';
			}
			$i++;
		}
		$GLOBALS['bayesdbhandle']->query($sql);

		$res = $GLOBALS['bayesdbhandle']->query('SELECT UserName FROM users WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		if (!DB::isError($res) && $row = $res->fetchRow()) {
			if ($check !== FALSE) {
				$GLOBALS['bayesdbhandle']->query('UPDATE users SET '.$type.'Count='.$type.'Count+'.$count.','.$check.'Count='.$check.'Count-'.$count.' WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
			} else {
				$GLOBALS['bayesdbhandle']->query('UPDATE users SET '.$type.'Count='.$type.'Count+'.$count.' WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
			}
		} else {
			$GLOBALS['bayesdbhandle']->query('INSERT INTO users SET '.$type.'Count='.$count.',UserName=\''.$GLOBALS['bayes_username'].'\'');
		}

		$GLOBALS['bayesdbhandle']->query('UPDATE users SET LastAdd=NOW() WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
	}
}

function bayesspam_get_occurences($type) {
	$return = array();
	
	$res = $GLOBALS['bayesdbhandle']->query('SELECT Token,Frequency FROM '.$type.'Occurences WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
	if (DB::isError($res)) {
		echo $res->getDebugInfo();
	} else {
		while ($row = $res->fetchRow()) {
			$return['token'.$row['Token']]=$row['Frequency'];
		}
	}	
	return $return;
}

function bayesspam_set_message_id(&$imap_stream,$passed_id) {
	global $uid_support;
	$headers = sqimap_get_small_header_list ($imap_stream, array($passed_id));
	$version_array = split('\.', $GLOBALS['version']);

	$read = sqimap_run_command ($imap_stream, 'FETCH '.$passed_id.':'.$passed_id.' BODY[HEADER]', true, $response, $message, $uid_support);

	array_shift($read);
	$text_headers = implode('\n',$read);

	unset($read);

	$GLOBALS['bayes_message_id'] = md5($text_headers);
	unset($text_headers);

	if(!$headers[0]['FLAG_SEEN']) {
		if ($version_array[0] == 1 && $version_array[1] <= 2) {
			sqimap_messages_remove_flag($imap_stream, $passed_id, $passed_id, 'Seen');
		} else {
			sqimap_messages_remove_flag($imap_stream, $passed_id, $passed_id, 'Seen', FALSE);
		}
	}
}

function bayesspam_parse_line($string,$token_type) {
	$return = array();

	# Pull out any email addresses in the line that are marked with <> and have an @ in them
	while (preg_match('/<([a-zA-Z0-9\-_\.]+?@([a-zA-Z0-9\-_\.]+?))>/',$string,$matches)) {
		$string = preg_replace('/<([a-zA-Z0-9\-_\.]+?@([a-zA-Z0-9\-_\.]+?))>/','',$string,1);
		$matches[1] = trim($matches[1]);
		$matches[2] = trim($matches[2]);
		if ($matches[1])
			$return[] = 'EMAIL: '.$matches[1];
		if ($matches[2])
			$return[] = 'DOMAIN: '.$matches[2];
	}

	# Grab domain names
	while (preg_match('/(([a-zA-Z][a-zA-Z0-9\-_]+\.){2,})([a-zA-Z0-9\-_]+)([^a-zA-Z0-9\-_]|$)/',$string,$matches)) {
		$string = preg_replace('/(([a-zA-Z][a-zA-Z0-9\-_]+\.){2,})([a-zA-Z0-9\-_]+)([^a-zA-Z0-9\-_]|$)/',$matches[4],$string,1);
		$matches[3] = trim($matches[3]);
		if ($matches[3])
			$return[] = 'DOMAIN: '.$matches[1].$matches[3];
	}

	# Grab IP addresses
	while (preg_match('/(([12]?\d{1,2}\.){3}[12]?\d{1,2})/',$string,$matches)) {
		$string = preg_replace('/(([12]?\d{1,2}\.){3}[12]?\d{1,2})/','',$string,1);
		$matches[1] = trim($matches[1]);
		if ($matches[1])
			$return[] = 'IPADDRESS: '.$matches[1];
	}

	# Only care about words between 3 and 45 characters since short words like
	# an, or, if are too common and the longest word in English (according to
	# the OED) is pneumonoultramicroscopicsilicovolcanoconiosis
	while (preg_match('/([a-zA-Z][a-zA-Z\']{0,44})[_\-,\."\'\)\?!:;\/&]{0,5}([ \t\n\r]|$)/',$string,$matches)) {
		$string = preg_replace('/([a-zA-Z][a-zA-Z\']{0,44})[_\-,\."\'\)\?!:;\/&]{0,5}([ \t\n\r]|$)/',' ',$string,1);
		$matches[1] = trim($matches[1]);
		if ($matches[1] && strlen($matches[1]) > 3)
			$return[] = $token_type.': '.$matches[1];
	}

	return $return;
}

function bayesspam_parse_html_tag($tag, $arg) {
	preg_replace('/[\r\n]/','',$tag);
	preg_replace('/[\r\n]/','',$arg);

	if (preg_match('/^img$/i',$tag) || preg_match('/^frame$/i',$tag)) {
		preg_match('/src[ \t]*=[ \t]*["\']?http:\/(\/(.+:)?)([^ \/">]+)([ \/">]|$)/i',$arg,$matches);
		if ($matches[3])
			return 'HTML: '.$matches[3];
	}
	if (preg_match('/^a$/i',$tag)) {
		preg_match('/href[ \t]*=[ \t]*["\']?http:\/(\/(.+:)?)([^ \/">]+)([ \/">]|$)/i',$arg,$matches);
		if ($matches[3])
			return 'HTML: '.$matches[3];
	}
	if (preg_match('/^form$/i',$tag)) {
		preg_match('/action[ \t]*=[ \t]*(["\']?(http:\/\/)?)([^ \/\">]+)([ \/">]|$)/i',$arg,$matches);
		if ($matches[3])
			return 'HTML: '.$matches[3];
	}
}

function bayesspam_get_tokens(&$imap_stream,$passed_id) {
	$tokens = array();

	$headers = sqimap_get_small_header_list ($imap_stream, array($passed_id));
	$version_array = split('\.', $GLOBALS['version']);

	bayesspam_set_message_id($imap_stream, $passed_id);

	$lines1 = sqimap_run_command($imap_stream, 'FETCH '.$passed_id.':'.$passed_id.' BODY[HEADER]<0.'.$GLOBALS['bayesspam_scan_size'].'>', true,$response, $msg, $GLOBALS['uid_support']);
	$response = array_shift($lines1);

	preg_match('/\{(\d+)\}/',$response,$matches);

	$lines2 = sqimap_run_command($imap_stream, 'FETCH '.$passed_id.':'.$passed_id.' BODY[TEXT]<0.'.($GLOBALS['bayesspam_scan_size'] - $matches[1]).'>', true, $response, $msg, $GLOBALS['uid_support']);

	if(!$headers[0]['FLAG_SEEN']) {
		if ($version_array[0] == 1 && $version_array[1] <= 2) {
			sqimap_messages_remove_flag($imap_stream, $passed_id, $passed_id, 'Seen');
		} else {
			sqimap_messages_remove_flag($imap_stream, $passed_id, $passed_id, 'Seen', FALSE);
		}
	}

	array_shift($lines2);

	$lines = array_merge($lines1,$lines2);
	unset($lines1);
	unset($lines2);

	$mime = '';
	$encoding = '';
	$decoded = '';
	$content_type = '';
	$in_html_tag = 0;

	for($i = 0; $i < count($lines); $i++) {
		$line = $lines[$i];
		if ($line == '') {
			continue;
		}
	
		if (($mime != '') && (preg_match('/'.$mime.'/',$line))) {
			$encoding = '';
			continue;
		}
	
		if (preg_match('/base64/i', $encoding)) {
			$decoded = '';
	
			while ((preg_match('/^([A-Za-z0-9+\/]{4}){1,48}[\n\r]*/',$line)) || (preg_match('/^[A-Za-z0-9+\/]+=+?[\n\r]*/',$line))) {
				$decoded .= base64_decode($line);
				if (preg_match('/[^a-zA-Z\-\.]$/',$decoded)) {
					$temp_tokens = bayesspam_parse_line($decoded,'ENCODED');
					foreach ($temp_tokens as $token) {
						$tokens[] = $token;
					}
					$decoded = '';
				}
				$i++;
				if ($i < count($lines)) {
					$line = $lines[$i];
				} else {
					break;
				}
			}
			$temp_tokens = bayesspam_parse_line($decoded,'ENCODED');
			foreach ($temp_tokens as $token) {
				$tokens[] = $token;
			}
		}
		if ($i == count($lines)) {
			break;
		}
		if (preg_match('/<html>/i',$line)) {
			$content_type = 'text/html';
		}
		if (preg_match('/quoted\-printable/',$encoding)) {
			$line = preg_replace('/=[\r\n]*$/','=\n',$line);
			$line = quoted_printable_decode($line);
		}

		$oldline = $line;
		while ($oldline != ($line = preg_replace('/<!--.*?-->/','',$line)) ) {
			$tokens[] = 'HTML: CHEATER';
			$oldline = $line;
		}
		
		unset($oldline);
	
		if (preg_match('/html/',$content_type)) {
			if ($in_html_tag) {
				if (preg_match('/(.*?)>/',$line,$matches)) {
					$line = preg_replace('/(.*?)>/',' ',$line);
					$html_arg .= $matches[1];
					$in_html_tag = 0;
					if (preg_match('/quoted\-printable/',$line)) {
						$html_tag = preg_replace('/=\n ?/','',$html_tag);
						$html_arg = preg_replace('/=\n ?/','',$html_arg);
					} 
					$tokens[] = bayesspam_parse_html_tag($html_tag,$html_arg);
					$html_tag = '';
					$html_arg = '';
				} else {
					$html_arg .= ' ' . $line;
					$line = '';
					continue;
				}
	
			}

			while (preg_match('/<[\/]?([A-Za-z]+)([^>]*?)>/',$line,$matches)) {
				$line = preg_replace('/<[\/]?([A-Za-z]+)([^>]*?)>/',' ',$line,1);
				$tokens[] = bayesspam_parse_html_tag($matches[1],$matches[2]);
			}

			if (preg_match('/<([^ >]+)([^>]*)$/',$line,$matches)) {
				$line = preg_replace('/<([^ >]+)([^>]*)$/','',$line);
				$html_tag = $matches[1];
				$html_arg = $matches[2];
				$in_html_tag = 1;
			}
		}

		if (preg_match('/^([A-Za-z-]+): ?([^\n\r]*)/',$line,$matches)) {
			$header = $matches[1];
			$arguement = $matches[2];
	
			if (preg_match('/(From|To|Cc)/i',$header)) {
				if (preg_match('/From/i',$header)) {
					$encoding = '';
					$content_type = '';
				}
				while (preg_match('/<([a-zA-Z0-9\-_\.]+?@([a-zA-Z0-9\-_\.]+?))>/',$arguement,$matches)) {
					$arguement = preg_replace('/<[a-zA-Z0-9\-_\.]+?@[a-zA-Z0-9\-_\.]+?>/','',$arguement,1);
					if ($matches[1])
						$tokens[] = 'EMAIL: '.$matches[1];
					if ($matches[2])
						$tokens[] = 'DOMAIN: '.$matches[2];
				}
				while (preg_match('/([a-zA-Z0-9\-_\.]+?@([a-zA-Z0-9\-_\.]+))/',$arguement,$matches)) {
					$arguement = preg_replace('/([a-zA-Z0-9\-_\.]+?@([a-zA-Z0-9\-_\.]+))/','',$arguement);
					if ($matches[1])
						$tokens[] = 'EMAIL: '.$matches[1];
					if ($matches[2])
						$tokens[] = 'DOMAIN: '.$matches[2];
				}
				$temp_tokens = bayesspam_parse_line($arguement, 'HEADER');
				foreach ($temp_tokens as $token) {
					$tokens[] = $token;
				}
				continue;
			}
			if (preg_match('/Subject/i',$header)) {
				$temp_tokens = bayesspam_parse_line($arguement, 'SUBJECT');
				foreach ($temp_tokens as $token) {
					$tokens[] = $token;
				}
				continue;
			}
	
			if (preg_match('/Content-Type/i',$header)) {
				if (preg_match('/multipart\//i',$arguement)) {
					$boundary = $arguement;
					if (preg_match('/boundary="(.*)"/',$arguement)) {
						$i++;
						$boundary = $lines[$i];
					}
					if (preg_match('/boundary="(.*)"/',$boundary,$matches)) {
						$mime = $matches[1];
						$mime = preg_replace('/(\+|\/|\?|\*|\||\(|\)|\[|\]|\{|\}|\^|\$|\.)/',$matches[1],$mime);
					}
				}
				$content_type = $arguement;
				continue;
			}
			if (preg_match('/Content-Transfer-Encoding/i',$header)) {
				$encoding = $arguement;
				continue;
			}
			if (preg_match('/(Thread-Index|X-UIDL|Message-ID|X-Text-Classification|X-Mime-Key)/i',$header)) {
				continue;
			}
			$temp_tokens = bayesspam_parse_line($arguement,'HEADER');
			foreach ($temp_tokens as $token) {
				$tokens[] = $token;
			}
		} else {
			$temp_tokens = bayesspam_parse_line($arguement,'BODY');
			foreach ($temp_tokens as $token) {
				$tokens[] = $token;
			}
		}
	}

	return $tokens;
}

function bayesspam_learn_single(&$imap_stream, $mailbox, $passed_id, $type) {
	$new_spam_occurences = array();
	$new_nonspam_occurences = array();
	$spam_occurences = bayesspam_get_occurences('spam');
	$nonspam_occurences = bayesspam_get_occurences('nonspam');

	$tokens = bayesspam_get_tokens($imap_stream,$passed_id);

	$added_spam = 0;
	$added_nonspam = 0;
	foreach ($tokens as $token) {
		if (strlen($token) > 0) {
			if ($type == 'spam') {
				$added_spam = 1;
				@$new_spam_occurences['token'.$token]++;
			} else {
				$added_nonspam = 1;
				@$new_nonspam_occurences['token'.$token] += 2;
			}
		}
	}

	if ($added_nonspam) {
		bayesspam_do_learn('nonspam',$nonspam_occurences,$new_nonspam_occurences,1);
	}
	if ($added_spam) {
		bayesspam_do_learn('spam',$spam_occurences,$new_spam_occurences,1);
	}

	if ($GLOBALS['bayesspam_do_stats'] && $GLOBALS['bayesspam_do_user_stats']) {
		$old_score = bayesspam_get_old_message_score();

		$res = $GLOBALS['bayesdbhandle']->query('SELECT UserName FROM stats WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');

		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		if (!DB::isError($res) && !($row = $res->fetchRow())) {
			$GLOBALS['bayesdbhandle']->query('INSERT INTO stats SET StatsStart=NOW(),UserName=\''.$GLOBALS['bayes_username'].'\'');
		}

		if ($old_score < .1 && $type == 'spam') {
			$GLOBALS['bayesdbhandle']->query('UPDATE stats SET FalseNegatives=FalseNegatives+1 WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
		}
		if ($old_score > .9 && $type == 'nonspam') {
			$GLOBALS['bayesdbhandle']->query('UPDATE stats SET FalsePositives=FalsePositives+1 WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
		}
		if ($old_score >= .1 && $old_score <= .9 && $type == 'spam') {
			$GLOBALS['bayesdbhandle']->query('UPDATE stats SET SpamUnsures=SpamUnsures+1 WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
		}
		if ($old_score >= .1 && $old_score <= .9 && $type == 'nonspam') {
			$GLOBALS['bayesdbhandle']->query('UPDATE stats SET HamUnsures=HamUnsures+1 WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
		}
		if ($old_score < .1 && $type == 'nonspam') {
			$GLOBALS['bayesdbhandle']->query('UPDATE stats SET HamReinforcement=HamReinforcement+1 WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
		}
		if ($old_score > .9 && $type == 'spam') {
			$GLOBALS['bayesdbhandle']->query('UPDATE stats SET SpamReinfercement=SpamReinforcement+1 WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
		}
	}

	bayesspam_add_messageid($type);
}

function bayesspam_rebuild_corpus() {
	$res = $GLOBALS['bayesdbhandle']->query('SELECT IF(LastRebuild<LastAdd,1,0) as Test FROM users WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
	$row = $res->fetchRow();

	if ($row && $row['Test']) {
		$sql0 = 'DELETE FROM nonspamOccurences WHERE UserName=\''.$GLOBALS['bayes_username'].'\' AND Frequency=0';
		$sql1 = 'DELETE FROM spamOccurences WHERE UserName=\''.$GLOBALS['bayes_username'].'\' AND Frequency=0';
		$sql2 = 'DELETE FROM Corpus WHERE UserName=\''.$GLOBALS['bayes_username'].'\'';
 		$sql3 = 'REPLACE INTO Corpus SELECT nonspamOccurences.UserName, nonspamOccurences.Token, 0.01 FROM nonspamOccurences LEFT JOIN spamOccurences USING (UserName,Token) WHERE spamOccurences.UserName IS NULL AND nonspamOccurences.Frequency>1 AND nonspamOccurences.UserName=\''.$GLOBALS['bayes_username'].'\'';
 		$sql4 = 'REPLACE INTO Corpus SELECT spamOccurences.UserName, spamOccurences.Token, 0.99 FROM spamOccurences LEFT JOIN nonspamOccurences USING (UserName,Token) WHERE nonspamOccurences.UserName IS NULL AND spamOccurences.Frequency>1 AND spamOccurences.UserName=\''.$GLOBALS['bayes_username'].'\'';
 		$sql5 = 'REPLACE INTO Corpus SELECT nonspamOccurences.UserName, nonspamOccurences.Token, IF( ( IF( spamOccurences.Frequency/users.spamCount > 1, 1,spamOccurences.Frequency/users.spamCount ) )/( ( IF( nonspamOccurences.Frequency/users.nonspamCount > 1, 1, nonspamOccurences.Frequency/users.nonspamCount ) )+( IF( spamOccurences.Frequency/users.spamCount > 1, 1, spamOccurences.Frequency/users.spamCount ) ) )>.99, .99, IF( ( IF( spamOccurences.Frequency/users.spamCount > 1, 1, spamOccurences.Frequency/users.spamCount ) )/( ( IF( nonspamOccurences.Frequency/users.nonspamCount > 1, 1, nonspamOccurences.Frequency/users.nonspamCount ) )+( IF( spamOccurences.Frequency/users.spamCount > 1, 1, spamOccurences.Frequency/users.spamCount ) ) )<.01, .01, ( IF( spamOccurences.Frequency/users.spamCount > 1, 1, spamOccurences.Frequency/users.spamCount ) )/( ( IF( nonspamOccurences.Frequency/users.nonspamCount > 1, 1, nonspamOccurences.Frequency/users.nonspamCount ) )+( IF( spamOccurences.Frequency/users.spamCount > 1, 1, spamOccurences.Frequency/users.spamCount ) ) ) ) ) as Total FROM nonspamOccurences INNER JOIN spamOccurences USING (UserName,Token) INNER JOIN users USING (UserName) WHERE spamOccurences.Frequency+nonspamOccurences.Frequency>1 AND nonspamOccurences.UserName=\''.$GLOBALS['bayes_username'].'\'';
		$sql6 = 'UPDATE users SET LastRebuild=NOW() WHERE UserName=\''.$GLOBALS['bayes_username'].'\'';
		$sql7 = 'DELETE FROM Messages WHERE TO_DAYS(Added) <= (TO_DAYS(NOW()) - '.$GLOBALS['bayes_message_store_days'].')';
		$sql8 = 'DELETE FROM ScoreCache WHERE TO_DAYS(Added) <= (TO_DAYS(NOW()) - '.$GLOBALS['bayes_cache_days'].')';

		$res = $GLOBALS['bayesdbhandle']->query($sql0);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $GLOBALS['bayesdbhandle']->query($sql1);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $GLOBALS['bayesdbhandle']->query($sql2);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $GLOBALS['bayesdbhandle']->query($sql3);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $GLOBALS['bayesdbhandle']->query($sql4);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $GLOBALS['bayesdbhandle']->query($sql5);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $GLOBALS['bayesdbhandle']->query($sql6);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $GLOBALS['bayesdbhandle']->query($sql7);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $GLOBALS['bayesdbhandle']->query($sql8);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}

		$_SESSION['bayesspam_corpus'] = bayesspam_get_corpus();
	}
}

function bayesspam_get_corpus() {
	$sql = 'SELECT Token,Score FROM Corpus WHERE UserName=\''.$GLOBALS['bayes_username'].'\'';

	$res = $GLOBALS['bayesdbhandle']->query($sql); 

	if (DB::isError($res)) {
		die ($res->getDebugInfo());
	}

	$corpus = array();
	while ($row = $res->fetchRow()) {
		$corpus['token'.$row['Token']] = $row['Score'];
	}

	return $corpus;
}

function bayesspam_get_interesting_tokens(&$tokens, &$corpus) {
	$tokencount = 0;
	$interestingtokens = array();
	$used_tokens = array();
	foreach ($tokens as $value) {
		if (strlen($value) > 0) {
			if (isset($corpus['token'.$value]) && abs(0.5-$corpus['token'.$value]) > 0) {
				//$corpus['token'.$value] = 0.4;
				@$used_tokens[$value] += 1;
				if ($used_tokens[$value] <= 2) 
					$interestingtokens[]=array($tokencount,abs(0.5-$corpus['token'.$value]));
			}
		}
		$tokencount++;
	}
	unset($tokencount);
	unset($used_tokens);

	if (!function_exists('bayesspam_sort')) {
		function bayesspam_sort ($a,$b) {
			if ($a[1] == $b[1])
				return 0;
			if ($a[1] < $b[1])
				return 1;
			return -1;
		}
	}

	usort($interestingtokens,'bayesspam_sort');

	$most_interesting = array_slice($interestingtokens,0,30);
	unset($interestingtokens);

	$display_interesting = array();
	for ($i = 0; $i < count($most_interesting); $i++) {
		$display_interesting[] = array($tokens[$most_interesting[$i][0]],$corpus['token'.$tokens[$most_interesting[$i][0]]]);
	}

	if (!function_exists('bayesspam_display_sort')) {
		function bayesspam_display_sort ($a,$b) {
			list($a_sort, $temp) = split(':',$a[0]);
			list($b_sort, $temp) = split(':',$b[0]);
			if ($a_sort == $b_sort) {
				if ($a[1] == $b[1]) {
					if ($a[0] == $b[0])
						return 0;
					if ($a[0] < $b[0])
						return -1;
					return 1;
				}
				if ($a[1] < $b[1])
					return 1;
				return -1;
			}
			if ($a_sort < $b_sort)
				return -1;
			return 1;
		}
	}

	usort($display_interesting, 'bayesspam_display_sort');

	$GLOBALS['token_display_string'] = '';
	$GLOBALS['token_html_display_string'] = '';

	for($i = 0; $i < count($display_interesting); $i++) {
		if ($i > 0)
			$GLOBALS['token_display_string'] .= "\n";
		$GLOBALS['token_display_string'] .= $display_interesting[$i][0].': '.$display_interesting[$i][1];

		$text_color = "";

		if ($display_interesting[$i][1] <= .10) {
			$text_color = " color=#0000ff";
		} elseif ($display_interesting[$i][1] <= .20) {
			$text_color = " color=#3300ff";
		} elseif ($display_interesting[$i][1] <= .30) {
			$text_color = " color=#6600ff";
		} elseif ($display_interesting[$i][1] <= .40) {
			$text_color = " color=#9900ff";
		} elseif ($display_interesting[$i][1] <= .50) {
			$text_color = " color=#cc00ff";
		} elseif ($display_interesting[$i][1] <= .60) {
			$text_color = " color=#ff00cc";
		} elseif ($display_interesting[$i][1] <= .70) {
			$text_color = " color=#ff0099";
		} elseif ($display_interesting[$i][1] <= .80) {
			$text_color = " color=#ff0066";
		} elseif ($display_interesting[$i][1] <= .90) {
			$text_color = " color=#ff0033";
		} elseif ($display_interesting[$i][1] <= 1.00) {
			$text_color = " color=#ff0000";
		}
		list($type,$which_token) = split(':',$display_interesting[$i][0]);
		$GLOBALS['token_html_display_string'] .= '<tr><td><font'.$text_color.'>'.$type.'</font></td>';
		$GLOBALS['token_html_display_string'] .= '<td><font'.$text_color.'>'.$which_token.'</font></td>';
		$GLOBALS['token_html_display_string'] .= '<td align=right><font'.$text_color.'>'.number_format(($display_interesting[$i][1] * 100),2).'%</font></td></tr>';
	}

	return $most_interesting;
}

function bayesspam_get_probability(&$imapConnection, $message_id, $no_cache=0) {
	bayesspam_set_message_id($imapConnection,$message_id);
	
	$GLOBALS['bayes_was_cached'] = 1;

	sqgetGlobalVar('bayes_recache',        $bayes_recache,        SQ_GET);

	if ( ( $is_spam = bayesspam_get_old_message_score() ) === FALSE || $no_cache || $bayes_recache == 1) {
		if (!$GLOBALS['bayesspam_tokens'] || $GLOBALS['bayesspam_tokens_message'] != $message_id) {
			$GLOBALS['bayesspam_tokens'] = bayesspam_get_tokens($imapConnection,$message_id);
			$GLOBALS['bayesspam_tokens_message'] = $message_id;
		}
		
		if (!isset($_SESSION['bayesspam_corpus']) || !$_SESSION['bayesspam_corpus']) {
			$_SESSION['bayesspam_corpus'] = bayesspam_get_corpus();
		}
	
		$most_interesting = bayesspam_get_interesting_tokens($GLOBALS['bayesspam_tokens'], $_SESSION['bayesspam_corpus']);
	
		$prod = 1;
		$minus_one_prod = 1;
	
		foreach ($most_interesting as $value) {
			$prod *= $_SESSION['bayesspam_corpus']['token'.$GLOBALS['bayesspam_tokens'][$value[0]]];
			$minus_one_prod *= (1.0 - $_SESSION['bayesspam_corpus']['token'.$GLOBALS['bayesspam_tokens'][$value[0]]]);
		}

		unset($most_interesting);
	
		$is_spam = $prod / ($prod + $minus_one_prod);
		bayesspam_cache_message_score($is_spam);
		$GLOBALS['bayes_was_cached'] = 0;
	}
	
	return $is_spam;
}

function bayesspam_get_old_message_score() {
	$sql = 'SELECT * FROM ScoreCache WHERE UserName=\''.$GLOBALS['bayes_username'].'\' AND MessageID=\''.$GLOBALS['bayes_message_id'].'\'';
	$res = $GLOBALS['bayesdbhandle']->query($sql);

	$row = $res->fetchRow();
	
	if ($row) {
		return $row['Score'];
	} else {
		return FALSE;
	}
}

function bayesspam_cache_message_score($score) {
	$sql = 'REPLACE INTO ScoreCache VALUES(\''.$GLOBALS['bayes_username'].'\',\''.$GLOBALS['bayes_message_id'].'\',\''.$score.'\',NOW())';
	$res = $GLOBALS['bayesdbhandle']->query($sql);
}

?>
