<?php /* Modified at 1 places by ri_once */ ?>
<?php /* 'php' Added by ri_once */
require_once('DB.php');
require_once('../plugins/bayesspam/bayesspam_functions.php');
require_once('../plugins/bayesspam/bayesspam_filter.php');

global $bayesdbhandle, $bayesdbuser, $bayesdbpass, $bayesdbhost, $bayesdbport, $bayesdbname, $bayes_username, $username, $bayes_message_id, $bayes_allow_db_nuke; 
global $bayesspam_ignore_folders, $bayes_max_size, $bayes_cache_days, $bayes_message_store_days, $bayes_was_cached, $bayesspam_scan_size, $bayes_ignore_size;
global $bayes_default_scan_size, $bayes_autorebuild_timeout, $bayesdbtype, $bayesspam_tokens, $bayesspam_update_tokens, $bayesspam_spam_occurences;
global $bayesspam_nonspam_occurences, $bayesspam_cached_occurences, $bayesspam_inboxonly, $token_display_string, $token_html_dislay_string;

if(!isset($_SESSION['bayesspam_corpus'])) {
	session_register('bayesspam_corpus');
}

// MAKE AJUSTMENTS FROM HERE DOWN

$GLOBALS['bayesdbtype'] = 'mysql';
$GLOBALS['bayesdbname'] = 'spamCorpus';
$GLOBALS['bayesdbhost'] = '127.0.0.1'; // IP is more efficient than DNS. Use if possible.
$GLOBALS['bayesdbport'] = '3306';
$GLOBALS['bayesdbuser'] = 'spamCorpus';
$GLOBALS['bayesdbpass'] = 'corpus';

// Granularity
//     user : Every user has their own Spam DB
//     domain : Every domain has it's own Spam DB
//     server : Every user/domain shares the same Spam DB
//
// If set to domain or server, bayes_allow_db_nuke should be FALSE
$GLOBALS['bayes_granularity'] = 'user';

// Allow DB Nuke
//     true : Users can empty their spam DB if they choose
//     false : Users may not empty their spam DB
//
// If Granularity is site or server, this should be FALSE
$GLOBALS['bayes_allow_db_nuke'] = TRUE;

// Domain Seperator
//    Specify what character is used to seperate the username
//    from the domain at your site if you are using a virtual
//    domain solution. This only matters for domain level
//    granularity. If using user level granularity, and this
//    matches the domain seperator, all that happens is that
//    BayesSpam replaces it with ! in the DB.
$GLOBALS['bayes_domain_seperator'] = '%';

// Default Scan Size
//    The default size (in bytes) of messages to use when filtering
$GLOBALS['bayes_default_scan_size'] = 65536; // 64 KB

// Max Scan Size
//    The maximum size (in bytes) of messages to use when filtering
//    If a message is bigger than this, only up to the max size
//    will be used when calculating the score
$GLOBALS['bayes_max_size'] = 131072; // 128 KB

// Ignore Size
//    BayesSpam will totally ignore messages larger than this
$GLOBALS['bayes_ignore_size'] = 2097152; // 2 MB

// Cache Days
//    How many days to cache message scores for. Longer improves
//    performance. Shorter gives more accurate scores.
//    Note that users do have a link to recalculate the score.
$GLOBALS['bayes_cache_days'] = 10;

// Message Store Days
//    How many days to cache knowledge of whether a message was
//    added to the spam or nonspam DB.
$GLOBALS['bayes_message_store_days'] = 10;

// Corpus Autorebuild Timeout
//    How many minutes to require between automatic rebuilds of the
//    spam Corpus. Set to 0 to always allow an automatic rebuild.
$GLOBALS['bayes_autorebuild_timeout'] = 15;

// NOTHING ELSE TO ADJUST

if ($GLOBALS['bayes_granularity'] == 'user') {
	$GLOBALS['bayes_username'] = addslashes(preg_replace('/'.$GLOBALS['bayes_domain_seperator'].'/','!',$_SESSION['username']));
} elseif ($GLOBALS['bayes_granularity'] == 'domain') {
	$GLOBALS['bayes_username'] = addslashes(preg_replace('/^.+'.$GLOBALS['bayes_domain_seperator'].'/','',$_SESSION['username']));
} else {
	$GLOBALS['bayes_username'] = 'server';
}
?>
