<?
require_once('DB.php');
require_once('../plugins/bayesspam/bayesspam_functions.php');
require_once('../plugins/bayesspam/bayesspam_filter.php');

global $bayesdbhandle, $bayesdbuser, $bayesdbpass, $bayesdbhost, $bayesdbport, $bayesdbname, $bayes_username, $username, $bayes_message_id, $bayes_allow_db_nuke, $bayesspam_ignore_folders, $bayes_max_size, $bayes_cache_days, $bayes_message_store_days, $bayes_was_cached, $bayesspam_scan_size, $bayes_ignore_size;

// MAKE AJUSTMENTS FROM HERE DOWN

$bayesdbname = "spamCorpus";
$bayesdbhost = "localhost";
$bayesdbport = "3306";
$bayesdbuser = "spamCorpus";
$bayesdbpass = "corpus";

// Granularity
//     user : Every user has their own Spam DB
//     domain : Every domain has it's own Spam DB
//     server : Every user/domain shares the same Spam DB
//
// If set to domain or server, bayes_allow_db_nuke should be FALSE
$bayes_granularity = 'user';

// Allow DB Nuke
//     true : Users can empty their spam DB if they choose
//     false : Users may not empty their spam DB
//
// If Granularity is site or server, this should be FALSE
$bayes_allow_db_nuke = TRUE;

// Domain Seperator
//    Specify what character is used to seperate the username
//    from the domain at your site if you are using a virtual
//    domain solution.
$bayes_domain_seperator = '%';

// Max Scan Size
//    The maximum size (in bytes) of messages to use when filtering
//    If a message is bigger than this, only up to the max size
//    will be used when calculating the score
$bayes_max_size = 131072; // 128 KB

// Ignore Size
//    BayesSpam will totally ignore messages larger than this
$bayes_ignore_size = 2097152; // 2 MB

// Cache Days
//    How many days to cache message scores for. Longer improves
//    performance. Shorter gives more accurate scores.
//    Note that users do have a link to reset the cached score
$bayes_cache_days = 10;

// Message Store Days
//    How many days to cache message IDs for.
$bayes_message_store_days = 10;

// NOTHING ELSE TO ADJUST


if ($bayes_granularity == 'user') {
	$bayes_username = addslashes(preg_replace('/'.$bayes_domain_seperator.'/',"!",$username));
} elseif ($bayes_granularity == 'domain') {
	$bayes_username = addslashes(preg_replace('/^.+'.$bayes_domain_seperator.'/','',$username));
} else {
	$bayes_username = 'server';
}
?>
