<?php
chdir ('..');
require_once('../src/validate.php');
require_once('../functions/page_header.php');
require_once('../functions/imap.php');
require_once('../src/load_prefs.php');
require_once('../plugins/bayesspam/config.php');

$imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
$boxes = sqimap_mailbox_list($imapConnection);
sqimap_logout($imapConnection);

displayPageHeader($color, "None");   

//global $bayesspam_enabled, $bayesspam_delete, $bayesdbhandle;

if (! isset($action))
	$action = '';
if ($action == 'links')
	setPref($data_dir, $username, 'bayesspam_links_enabled', 1);
elseif ($action == 'nolinks')
	setPref($data_dir, $username, 'bayesspam_links_enabled', '');
elseif ($action == 'filter')
	setPref($data_dir, $username, 'bayesspam_filtering_enabled', 1);
elseif ($action == 'nofilter')
	setPref($data_dir, $username, 'bayesspam_filtering_enabled', '');
elseif ($action == 'save')
	setPref($data_dir, $username, 'bayesspam_delete', '');
elseif ($action == 'delete')
	setPref($data_dir, $username, 'bayesspam_delete', 1);
elseif ($action == 'autolearn')
	setPref($data_dir, $username, 'bayesspam_autolearn', 1);
elseif ($action == 'noautolearn')
	setPref($data_dir, $username, 'bayesspam_autolearn', '');
elseif ($action == 'loginrebuild')
	setPref($data_dir, $username, 'bayesspam_rebuild_on_login', 1);
elseif ($action == 'nologinrebuild')
	setPref($data_dir, $username, 'bayesspam_rebuild_on_login', '');
elseif ($action == 'refreshrebuild')
	setPref($data_dir, $username, 'bayesspam_rebuild_on_refresh', 1);
elseif ($action == 'norefreshrebuild')
	setPref($data_dir, $username, 'bayesspam_rebuild_on_refresh', '');
elseif ($action == 'showprob')
	setPref($data_dir, $username, 'bayesspam_show_prob', 1);
elseif ($action == 'noshowprob')
	setPref($data_dir, $username, 'bayesspam_show_prob', '');
elseif ($action == 'folder' && isset($folder))
	setPref($data_dir, $username, 'bayesspam_folder', $folder);
elseif ($action == 'set_scan_size' && isset($scan_size)) {
	if ($scan_size > $bayes_max_size) {
		$scan_size = $bayes_max_size;
	}
	setPref($data_dir, $username, 'bayesspam_scan_size', $scan_size);
} elseif ($action == 'ignore_add' && isset($ignore_add)) {
	$bayesspam_ignore_folders[] = $ignore_add;
	array_unique($bayesspam_ignore_folders);
	$temp = array();
	foreach ($bayesspam_ignore_folders as $value) {
		$temp[] = $value;
	}	
	$bayesspam_ignore_folders = $temp;

	for ($i=0; $i<count($bayesspam_ignore_folders); $i++) {
		setPref($data_dir, $username, 'bayesspam_ignore_folders_'.$i, $bayesspam_ignore_folders[$i]);
	}
} elseif ($action == 'ignore_rem' && isset($ignore_rem)) {
	for ($i=0; $i<=count($bayesspam_ignore_folders); $i++) {
		removePref($data_dir, $username, 'bayesspam_ignore_folders_'.$i);
	}

	$bayesspam_ignore_folders = array_diff($bayesspam_ignore_folders, array($ignore_rem));
	
	$temp = array();
	foreach ($bayesspam_ignore_folders as $value) {
		$temp[] = $value;
	}	
	$bayesspam_ignore_folders = $temp;

	array_merge($bayesspam_ignore_folders, array());

	for ($i=0; $i<count($bayesspam_ignore_folders); $i++) {
		setPref($data_dir, $username, 'bayesspam_ignore_folders_'.$i, $bayesspam_ignore_folders[$i]);
	}
} elseif ($action == 'rebuild') 
	bayesspam_rebuild_corpus();
elseif ($action == 'empty')
	bayesspam_nuke_db();

bayesspam_load();

?>
	<br>
		<table width=95% align=center border=0 cellpadding=2 cellspacing=0><tr><td bgcolor="<?php echo $color[0] ?>">
		<center><b><?php echo _("Options") ?> - BayesSpam Filtering</b></center>
	</td></tr></table>
      <br>
      
  <table align=center>
    <tr>
	  <td align=right>BayesSpam Probability Display is:</td>
	  <td><?PHP if ($bayesspam_show_prob) { 
	  ?><font color=darkgreen>Enabled</font> (<a href="options.php?action=noshowprob">Disable it</a>)
	  <?PHP } else {
	  ?><font color=red>Disabled</font> (<a href="options.php?action=showprob">Enable it</a>)
	  <?PHP }
	  ?></td>
	</tr>
    <tr>
	  <td align=right>BayesSpam Links are:</td>
	  <td><?PHP if ($bayesspam_links_enabled) { 
	  ?><font color=darkgreen>Enabled</font> (<a href="options.php?action=nolinks">Disable it</a>)
	  <?PHP } else {
	  ?><font color=red>Disabled</font> (<a href="options.php?action=links">Enable it</a>)
	  <?PHP }
	  ?></td>
	</tr>
    <tr>
	  <td align=right>BayesSpam Filtering is:</td>
	  <td><?PHP if ($bayesspam_filtering_enabled) { 
	  ?><font color=darkgreen>Enabled</font> (<a href="options.php?action=nofilter">Disable it</a>)
	  <?PHP } else {
	  ?><font color=red>Disabled</font> (<a href="options.php?action=filter">Enable it</a>)
	  <?PHP }
	  ?></td>
	</tr>
    <tr>
	  <td align=right valign=top>Spam Deletion is:
	  </td>
	  <td valign=top><?PHP if ($bayesspam_delete) { 
	  ?><font color=darkgreen>Enabled</font> (<a href="options.php?action=save">Disable it</a>)
	  <?PHP } else {
	  ?><font color=red>Disabled</font> (<a href="options.php?action=delete">Enable it</a>)
	  <?PHP }
	  ?></td>
	</tr>
    <tr>
	  <td align=right valign=top>Rebuild On Folder Refresh is:
	  </td>
	  <td valign=top><?PHP if ($bayesspam_rebuild_on_refresh) { 
	  ?><font color=darkgreen>Enabled</font> (<a href="options.php?action=norefreshrebuild">Disable it</a>)
	  <?PHP } else {
	  ?><font color=red>Disabled</font> (<a href="options.php?action=refreshrebuild">Enable it</a>)
	  <?PHP }
	  ?></td>
	</tr>
    <tr>
	  <td align=right valign=top>Rebuild On Login is:
	  </td>
	  <td valign=top><?PHP if ($bayesspam_rebuild_on_login) { 
	  ?><font color=darkgreen>Enabled</font> (<a href="options.php?action=nologinrebuild">Disable it</a>)
	  <?PHP } else {
	  ?><font color=red>Disabled</font> (<a href="options.php?action=loginrebuild">Enable it</a>)
	  <?PHP }
	  ?></td>
	</tr>
    <tr>
	  <td align=right valign=top>Auto Learn is:
	  </td>
	  <td valign=top><?PHP if ($bayesspam_autolearn) { 
	  ?><font color=darkgreen>Enabled</font> (<a href="options.php?action=noautolearn">Disable it</a>)
	  <?PHP } else {
	  ?><font color=red>Disabled</font> (<a href="options.php?action=autolearn">Enable it</a>)
	  <?PHP }
	  ?></td>
	</tr>
	<tr><td>&nbsp;</td></tr>
	<tr>
		<td align=right>Bytes of message to scan:<br><font size=-1>Maximum: <? echo $bayes_max_size; ?></font></td>
		<form method=post action=options.php><td>
			<input type=text name=scan_size value="<? echo $bayesspam_scan_size; ?>">
			<input type=hidden name=action value="set_scan_size">
			<input type=submit value="Save">
		</td></form>
	</tr>
	<tr><td>&nbsp;</td></tr>
	<tr>
	  <td align=right>Folder To Filter Into:</td>
	  <form method=post action=options.php><td>
	    <select name=folder>
<?
        for ($i = 0; $i < count($boxes); $i++) {
            if (! in_array('noselect', $boxes[$i]['flags'])) {
                $box = $boxes[$i]['unformatted'];
                $box2 = str_replace(' ', '&nbsp;', $boxes[$i]['formatted']);
                if (isset($bayesspam_folder) &&
                    $bayesspam_folder == $box)
                echo "<OPTION VALUE=\"$box\" SELECTED>$box2</option>";
                else
                echo "<OPTION VALUE=\"$box\">$box2</option>";
            }
        }

?>
	    </select></td><td>
	    <input type=hidden name=action value=folder>
	    <input type=submit value="Save">
	  </td></form>
	</tr>
	<tr>
	  <td align=right>Add Folder To Ignore List:</td>
	  <form method=post action=options.php><td>
	    <select name=ignore_add>
<?
        for ($i = 0; $i < count($boxes); $i++) {
            if (!(in_array('noselect', $boxes[$i]['flags'])) && $boxes[$i]['unformatted'] != 'INBOX.Trash' && $boxes[$i]['unformatted'] != $bayesspam_folder && !(in_array($boxes[$i]['unformatted'],$bayesspam_ignore_folders))) {
                $box = $boxes[$i]['unformatted'];
                $box2 = str_replace(' ', '&nbsp;', $boxes[$i]['formatted']);
                echo "<OPTION VALUE=\"$box\">$box2</option>";
            }
        }
?>
	    </select></td><td>
	    <input type=hidden name=action value=ignore_add>
	    <input type=submit value="Save">
	  </td></form>
	</tr>
	<tr>
	  <td align=right>Remove Folder From Ignore List:</td>
	  <form method=post action=options.php><td>
	    <select name=ignore_rem>
<?
        for ($i = 0; $i < count($bayesspam_ignore_folders); $i++) {
            if ($bayesspam_ignore_folders[$i] != 'INBOX.Trash' && $bayesspam_ignore_folders[$i] != $bayesspam_folder) {
                $box = $bayesspam_ignore_folders[$i];
                $box2 = str_replace(' ', '&nbsp;', $bayesspam_ignore_folders[$i]);
                echo "<OPTION VALUE=\"$box\">$box2</option>";
            }
        }

?>
	    </select></td><td>
	    <input type=hidden name=action value=ignore_rem>
	    <input type=submit value="Save">
	  </td></form>
	</tr>
        <tr>
	  <td align=center colspan=2>&nbsp;<P>
		<b>Spam Database Stats:</b><br>
<table>
<tr><td align=right>NonSpam Emails Submitted:</td>
<td align=right>
<?
$res = $bayesdbhandle->query("SELECT nonspamCount FROM users WHERE UserName='".$bayes_username."'");
if (!DB::isError($res)) {
	$row = $res->fetchRow();
	echo $row['nonspamCount'];
} else {
	echo $res->getDebugInfo();
}
?>
</td>
</tr>
<tr><td align=right>Spam Emails Submitted:</td>
<td align=right>
<?
$res = $bayesdbhandle->query("SELECT spamCount FROM users WHERE UserName='".$bayes_username."'");
if (!DB::isError($res)) {
	$row = $res->fetchRow();
	echo $row['spamCount'];
} else {
	echo $res->getDebugInfo();
}
?>
</td>
</tr>
<tr><td align=right>Last Database Rebuild:</td>
<td align=right>
<?
$res = $bayesdbhandle->query("SELECT LastRebuild FROM users WHERE UserName='".$bayes_username."'");
if (!DB::isError($res)) {
	$row = $res->fetchRow();
	echo $row['LastRebuild'];
} else {
	echo $res->getDebugInfo();
}
?>
</td>
</tr>
<tr><td align=right>Last Mail Added:</td>
<td align=right>
<?
$res = $bayesdbhandle->query("SELECT LastAdd FROM users WHERE UserName='".$bayes_username."'");
if (!DB::isError($res)) {
	$row = $res->fetchRow();
	echo $row['LastAdd'];
} else {
	echo $res->getDebugInfo();
}
?>
</td>
</tr>
</table>
	  </td>
	</tr>
	<tr><td>&nbsp;</td></tr>
<?
$res = $bayesdbhandle->query("SELECT IF(LastRebuild<LastAdd,1,0) AS Check FROM users WHERE UserName='".$bayes_username."'");
$row = $res->fetchRow();
if ($row['Check']) {
?>
    <tr>
	  <td align=center colspan=2>
		<b><a href="options.php?action=rebuild">Rebuild Filtering Database Now</a></b>
	  </td>
	</tr>
<?
}
if ($bayes_allow_db_nuke) {
?>
    <tr>
	  <td align=center colspan=2>
		<b><a href="options.php?action=empty">Empty Database Now</a></b>
	  </td>
	</tr>
<? } ?>
      </table><P>
To start using BayesSpam Intelligent Filtering, you must first build up a database of what you consider to be spam, and what you consider to not be spam. 
To do this, enable the links. When you read an email, there will be two new links to the upper right, to let you mark the mail as Spam or NonSpam. 
Use them a few dozen times on both spam and nonspam emails before going any further. The more times you use them, the more accurate your filtering will become.
<P>Once you have a few dozen emails in your database (Come here to check your DB stats) you can enable the filtering itself.<P>

<b>Auto Learn</b>: NOTE: Auto Learn is still a little slow. Keep this in mind before enabling it. Auto Learn should not be enabled until you have manually added a number of spams and nonspams to the plugin's database. Once it is doing a good job of filtering on it's
own, then turn on AutoLearn, and it will automatically add every new email to it's database, thus improving it's filtering further.<P>
<b>Spam Deletion</b>: This option is somewhat dangerous, since if you get a false positive, it would delete the message without ever telling you. False positives /shouldn't/ happen, but you use this option at your own risk. This option requires Filtering to be turned on as well.<P>
<b>Ignore List</b>: Folders to not run the filtering on. This is not 100% reliable, since BayesSpam may load before the main Filters plugin, thus giving it a chance to run on the messages in the inbox before they've been moved to their own folders.<P>
<?
if ($bayes_allow_db_nuke) {
?>
<b>Empty Database</b>: Do this if you for some reason want to wipe out your current spam DB and start all over.<P>
<? } ?>
</body></html>
