<?
require_once('../plugins/bayesspam/config.php');
require_once('../functions/imap.php');
require_once('../functions/mailbox_display.php');

function bayesspam_nuke_db() {
	global $bayes_username, $bayesdbhandle;
	
	$sql0 = "DELETE FROM Corpus WHERE UserName='".$bayes_username."'";
	$sql1 = "DELETE FROM nonspamOccurences WHERE UserName='".$bayes_username."'";
	$sql2 = "DELETE FROM spamOccurences WHERE UserName='".$bayes_username."'";
	$sql3 = "DELETE FROM Messages WHERE UserName='".$bayes_username."'";
	$sql4 = "UPDATE users SET nonspamCount=0,spamCount=0,LastAdd=NOW(),LastRebuild=NOW() WHERE UserName='".$bayes_username."'";

	$bayesdbhandle->query($sql0);
	$bayesdbhandle->query($sql1);
	$bayesdbhandle->query($sql2);
	$bayesdbhandle->query($sql3);
	$bayesdbhandle->query($sql4);
}

function bayesspam_add_messageid($type) {
	global $bayes_username, $bayesdbhandle, $bayes_message_id;
	
	$sql = "REPLACE INTO Messages VALUES('".$bayes_username."','".$bayes_message_id."','".$type."',NULL)";
	$bayesdbhandle->query($sql);
}

function bayesspam_del_messageid($type) {
	global $bayes_username, $bayesdbhandle, $bayes_message_id;
	
	$sql = "DELETE FROM ".$type."Messages WHERE UserName='".$bayes_username."' AND MessageID='".$bayes_message_id."'";
	$bayesdbhandle->query($sql);
}

function bayesspam_check_messageid() {
	global $bayes_username, $bayesdbhandle, $bayes_message_id;
	
	$sql = "SELECT * FROM Messages WHERE UserName='".$bayes_username."' AND MessageID='".$bayes_message_id."'";
	$res = $bayesdbhandle->query($sql);

	$row = $res->fetchRow();
	
	if ($row) {
		return $row['Type'];
	} else {
		return FALSE;
	}
}

function bayesspam_do_learn($type,$oldarray,$newarray,$count,$skip_check=0) {
	global $bayes_username, $username, $bayesdbhandle, $bayes_message_id, $bayes_message_store_days;
	
	$check = bayesspam_check_messageid();

	if ($skip_check || ($check != $type)) {
		if (!$skip_check && $check !== FALSE) {
			$old_occurences = bayesspam_get_occurences($check);
			$update = array();
			foreach ($newarray as $token=>$value) {
				if (isset($old_occurences[$token])) {
					$update[$token] = $old_occurences[$token] - $value;
				}
			}

			$sql = "REPLACE INTO ".$check."Occurences VALUES ";
			$i = 1;
			foreach ($update as $token=>$value) {
				$sql .= '(\''.$bayes_username.'\',\''.addslashes(substr($token,5)).'\','.$value.',NULL)';
				if ($i < count($update)) {
					$sql .= ',';
				}
				$i++;
			}

			$bayesdbhandle->query($sql);
		}

		foreach ($newarray as $token=>$value) {
			@$newarray[$token] += $oldarray[$token];
		}
	
		$sql = "REPLACE INTO ".$type."Occurences VALUES ";
		$i = 1;
		foreach ($newarray as $token=>$value) {
			$sql .= '(\''.$bayes_username.'\',\''.addslashes(substr($token,5)).'\','.$value.',NULL)';
			if ($i < count($newarray)) {
				$sql .= ',';
			}
			$i++;
		}
		$bayesdbhandle->query($sql);
	
		$res = $bayesdbhandle->query("SELECT UserName FROM users WHERE UserName='".$bayes_username."'");
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		if (!DB::isError($res) && $row = $res->fetchRow()) {
			$bayesdbhandle->query("UPDATE users SET ".$type."Count=".$type."Count+".$count." WHERE UserName='".$bayes_username."'");
		} else {
			$bayesdbhandle->query("INSERT INTO users SET ".$type."Count=".$count.",UserName='".$bayes_username."'");
		}
	
		$bayesdbhandle->query("UPDATE users SET LastAdd=NOW() WHERE UserName='".$bayes_username."'");
	}
	
	$sql = "DELETE FROM Messages WHERE TO_DAYS(Added) <= (TO_DAYS(NOW()) - $bayes_message_store_days)";
	$res = $bayesdbhandle->query($sql);
}

function bayesspam_get_occurences($type) {
	global $bayes_username, $username, $bayesdbhandle;
	
	$return = array();
	
	$res = $bayesdbhandle->query("SELECT Token,Frequency FROM ".$type."Occurences WHERE UserName='".$bayes_username."'");
	while ($row = $res->fetchRow()) {
		$return['token'.$row['Token']]=$row['Frequency'];
	}
	
	return $return;
}

function bayesspam_set_message_id(&$imap_stream,$passed_id) {
	global $bayes_debug, $bayes_message_id, $bayesspam_scan_size, $mailbox, $version, $bayes_ignore_size;
	global $uid_support;

	$headers = sqimap_get_small_header_list ($imap_stream, array($passed_id), 0);
	$version_array = split('\.', $version);

    $read = sqimap_run_command ($imap_stream, "FETCH $passed_id:$passed_id BODY[HEADER]", true, $response, $message);

	array_shift($read);
	$text_headers = implode('\n',$read);

	unset($read);

	$bayes_message_id = md5($text_headers);
	unset($text_headers);

	if(!$headers[0]->flag_seen) {
		if ($version_array[0] == 1 && $version_array[1] <= 2) {
			sqimap_messages_remove_flag($imap_stream, $passed_id, $passed_id, "Seen");
		} else {
			sqimap_messages_remove_flag($imap_stream, $passed_id, $passed_id, "Seen", FALSE);
		}
	}
}

function bayesspam_get_tokens(&$imap_stream,$passed_id) {
	global $bayes_debug, $bayes_message_id, $bayesspam_scan_size, $mailbox, $version, $bayes_ignore_size;
	global $uid_support;
	
	$headers = sqimap_get_small_header_list ($imap_stream, array($passed_id), 0);
	
	if ($headers->size >= $bayes_ignore_size) {
		return array();
	}

	$version_array = split('\.', $version);

	bayesspam_set_message_id($imap_stream, $passed_id);

	$read = sqimap_run_command($imap_stream, "FETCH $passed_id:$passed_id RFC822", true, $response, $msg, $uid_support);

	if(!$headers[0]->flag_seen) {
		if ($version_array[0] == 1 && $version_array[1] <= 2) {
			sqimap_messages_remove_flag($imap_stream, $passed_id, $passed_id, "Seen");
		} else {
			sqimap_messages_remove_flag($imap_stream, $passed_id, $passed_id, "Seen", FALSE);
		}
	}

	unset($headers);

	array_shift($read);

	$mail = implode("\n",$read);
	unset($read);
	
	$mail = substr($mail,0,$bayesspam_scan_size);
	$temptokens = preg_split("/[^\w\-'\$]/",$mail);
	
	$tokens = array();
	foreach ($temptokens as $token) {
		if (strlen($token) > 0) {
			$tokens[] = $token;
		}
	}
	
	unset($temptokens);

	return $tokens;
}

function bayesspam_learn_single(&$imap_stream, $mailbox, $passed_id, $type) {
	global $bayes_username, $username, $bayesdbhandle;

	$new_spam_occurences = array();
	$new_nonspam_occurences = array();
	$spam_occurences = bayesspam_get_occurences('spam');
	$nonspam_occurences = bayesspam_get_occurences('nonspam');

	$tokens = bayesspam_get_tokens($imap_stream,$passed_id);
	
	$added_spam = 0;
	$added_nonspam = 0;
	foreach ($tokens as $token) {
		if (strlen($token) > 0) {
			if ($type == 'spam') {
				$added_spam = 1;
				@$new_spam_occurences['token'.$token]++;
			} else {
				$added_nonspam = 1;
				@$new_nonspam_occurences['token'.$token] += 2;
			}
		}
	}
	
	if ($added_nonspam) {
		bayesspam_do_learn('nonspam',$nonspam_occurences,$new_nonspam_occurences,1);
	}
	if ($added_spam) {
		bayesspam_do_learn('spam',$spam_occurences,$new_spam_occurences,1);
	}
	bayesspam_add_messageid($type);
}

function bayesspam_rebuild_corpus() {
	global $username, $bayes_username, $bayesdbhandle;

	$res = $bayesdbhandle->query("SELECT IF(LastRebuild<LastAdd,1,0) as Test FROM users WHERE UserName='".$bayes_username."'");
	$row = $res->fetchRow();
	
	if ($row && $row['Test']) {
		$sql0 = "DELETE FROM Corpus WHERE UserName='".$bayes_username."'";
		$sql1 = "REPLACE INTO Corpus SELECT nonspamOccurences.UserName, nonspamOccurences.Token, 0.01 FROM nonspamOccurences LEFT JOIN spamOccurences USING (UserName,Token) WHERE spamOccurences.UserName IS NULL AND nonspamOccurences.Frequency>5 AND nonspamOccurences.UserName='".$bayes_username."'";
		$sql2 = "REPLACE INTO Corpus SELECT spamOccurences.UserName, spamOccurences.Token, 0.99 FROM spamOccurences LEFT JOIN nonspamOccurences USING (UserName,Token) WHERE nonspamOccurences.UserName IS NULL AND spamOccurences.Frequency>5 AND spamOccurences.UserName='".$bayes_username."'";
		$sql3 = "REPLACE INTO Corpus SELECT nonspamOccurences.UserName, nonspamOccurences.Token, IF( ( IF( spamOccurences.Frequency/users.spamCount > 1, 1, spamOccurences.Frequency/users.spamCount ) )/( ( IF( nonspamOccurences.Frequency/users.nonspamCount > 1, 1, nonspamOccurences.Frequency/users.nonspamCount ) )+( IF( spamOccurences.Frequency/users.spamCount > 1, 1, spamOccurences.Frequency/users.spamCount ) ) )>.99, .99, IF( ( IF( spamOccurences.Frequency/users.spamCount > 1, 1, spamOccurences.Frequency/users.spamCount ) )/( ( IF( nonspamOccurences.Frequency/users.nonspamCount > 1, 1, nonspamOccurences.Frequency/users.nonspamCount ) )+( IF( spamOccurences.Frequency/users.spamCount > 1, 1, spamOccurences.Frequency/users.spamCount ) ) )<.01, .01, ( IF( spamOccurences.Frequency/users.spamCount > 1, 1, spamOccurences.Frequency/users.spamCount ) )/( ( IF( nonspamOccurences.Frequency/users.nonspamCount > 1, 1, nonspamOccurences.Frequency/users.nonspamCount ) )+( IF( spamOccurences.Frequency/users.spamCount > 1, 1, spamOccurences.Frequency/users.spamCount ) ) ) ) ) as Total FROM nonspamOccurences INNER JOIN spamOccurences USING (UserName,Token) INNER JOIN users USING (UserName) WHERE spamOccurences.Frequency+nonspamOccurences.Frequency>5 AND nonspamOccurences.UserName='".$bayes_username."'";
		$sql4 = "UPDATE users SET LastRebuild=NOW() WHERE UserName='".$bayes_username."'";
	
		$res = $bayesdbhandle->query($sql0);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $bayesdbhandle->query($sql1);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $bayesdbhandle->query($sql2);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $bayesdbhandle->query($sql3);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
		$res = $bayesdbhandle->query($sql4);
		if (DB::isError($res)) {
			echo $res->getDebugInfo();
		}
	}
}

function bayesspam_get_corpus() {
	global $username, $bayes_username, $bayesdbhandle;

	require_once ('../plugins/bayesspam/config.php');

	$sql = "SELECT Token,Score FROM Corpus WHERE UserName='".$bayes_username."'";

	$res = $bayesdbhandle->query($sql); 

	if (DB::isError($res)) {
		die ($res->getDebugInfo());
	}

	$corpus = array();
	while ($row = $res->fetchRow()) {
		$corpus["token".$row['Token']] = $row['Score'];
	}

	return $corpus;
}

function bayesspam_get_interesting_tokens(&$tokens, &$corpus) {
	$tokens = array_unique($tokens);
	$temp = array();
	foreach ($tokens as $value) {
		$temp[] = $value;
	}	
	$tokens = $temp;
	unset($temp);

	$tokencount = 0;
	$interestingtokens = array();
	foreach ($tokens as $value) {
		if (strlen($value) > 0) {
			if (!isset($corpus["token".$value])) {
				$corpus['token'.$value] = 0.2;
			}
			$interestingtokens[]=array($tokencount,abs(0.5-$corpus['token'.$value]));
		}
		$tokencount++;
	}
	unset($tokencount);

	if (!function_exists("bayesspam_sort")) {
		function bayesspam_sort ($a,$b) {
			if ($a[1] == $b[1])
				return 0;
			if ($a[1] < $b[1])
				return 1;
			return -1;
		}
	}

	usort($interestingtokens,"bayesspam_sort");

	$most_interesting = array_slice($interestingtokens,0,15);
	unset($interestingtokens);

	return $most_interesting;
}

function bayesspam_get_probability(&$imapConnection, $message_id, $no_cache=0) {
	global $username, $bayes_username, $bayesdbhandle, $mailbox, $bayes_was_cached;

	bayesspam_set_message_id($imapConnection,$message_id);
	
	$bayes_was_cached = 1;

	if ((($is_spam = bayesspam_get_old_message_score()) === FALSE) || $no_cache || 
			(
				(
					(isset($_GET['bayes_recache'])) && ($_GET['bayes_recache'] == 1)
				) || (
					(isset($HTTP_GET_VARS['bayes_recache'])) && ($HTTP_GET_VARS['bayes_recache'] == 1)
				)
			)
	) {
		$tokens = bayesspam_get_tokens($imapConnection,$message_id);
		$corpus = bayesspam_get_corpus();
	
		$most_interesting = bayesspam_get_interesting_tokens($tokens, $corpus);
	
		$prod = 1;
		$minus_one_prod = 1;
	
		foreach ($most_interesting as $value) {
			$prod *= $corpus['token'.$tokens[$value[0]]];
			$minus_one_prod *= (1.0 - $corpus['token'.$tokens[$value[0]]]);
		}
		unset($tokens);
		unset($corpus);
		unset($most_interesting);
	
		$is_spam = $prod / ($prod + $minus_one_prod);
		bayesspam_cache_message_score($is_spam);
		$bayes_was_cached = 0;
	}
	
	return $is_spam;
}

function bayesspam_get_old_message_score() {
	global $bayes_username, $bayesdbhandle, $bayes_message_id;
	
	$sql = "SELECT * FROM ScoreCache WHERE UserName='".$bayes_username."' AND MessageID='".$bayes_message_id."'";
	$res = $bayesdbhandle->query($sql);

	$row = $res->fetchRow();
	
	if ($row) {
		return $row['Score'];
	} else {
		return FALSE;
	}
}

function bayesspam_cache_message_score($score) {
	global $bayes_username, $bayesdbhandle, $bayes_message_id, $bayes_cache_days;
	
	$sql = "REPLACE INTO ScoreCache VALUES('$bayes_username','$bayes_message_id','$score',NOW())";
	$res = $bayesdbhandle->query($sql);

	$sql = "DELETE FROM ScoreCache WHERE TO_DAYS(Added) <= (TO_DAYS(NOW()) - $bayes_cache_days)";
	$res = $bayesdbhandle->query($sql);
}

?>
