<?php

/*
 * forward:  $Id: lib.php,v 1.6 2003/06/28 00:29:52 shaug Exp $
 * (c) 2002 O'Shaughnessy Evans <shaug-spamrule @ wumpus.org>
 */

/*
 * Table of Contents:
 * 
 * ar_print_header($mesg, $columns)
 * ar_print_footer($mesg, $columns)
 * ar_ftp_get($path)
 * ar_ftp_put($path, $data)
 * ar_syslog($message)
 * ar_change_autoresponse()
 * ar_install_autoresponse()
 * ar_read_vacation()
 * ar_edit_vacation()
 */


global $key, $onetimepad, $trash_folder, $AUTORESPOND_OPTS;
sqgetGlobalVar('key', $key, SQ_COOKIE);
sqgetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);
sqgetGlobalVar('trash_folder', $trash_folder, SQ_SESSION);
sqgetGlobalVar('AUTORESPOND_OPTS', $AUTORESPOND_OPTS);


/* ar_print_header($mesg, $columns)
 * 
 * Print out the beginning of a table, with $mesg in the first row.
 * 
 * Parameters:
 *   $mesg:     text to print out
 *   $columns:  how many columns will be in the table
 * 
 * Returns:
 *   nothing
 */
function ar_print_header($mesg, $columns)
{
    global $color;

    $title = _("Options") . ' - Automatic Forward and Reply';

    echo <<<EOtable_top
<br>
<table bgcolor="{$color[0]}" border=0 width=95%
       cellspacing=0 cellpadding=2 align=center>
  <tr bgcolor="{$color[0]}">
    <th>{$title}</b></th>
  </tr>
  <tr><td>
    <table bgcolor="{$color[4]}" border=0 width=100% cellspacing=0 cellpadding=5 align=center valign=top>
      <tr align=center bgcolor="{$color[4]}">
        <td colspan=$columns>
EOtable_top;

    if (isset($mesg))
        echo "<p>{$mesg}</p>\n";

    echo "</td>\n</tr>\n\n";
}


/* ar_print_footer($mesg, $columns)
 * 
 * Print out the end of a table, with $mesg in the last row.
 * 
 * Parameters:
 *   $mesg:     text to print out
 *   $columns:  how many columns the table has
 * 
 * Returns:
 *   nothing
 */
function ar_print_footer($mesg, $columns)
{
    global $color;

    if (isset($mesg)) {
        echo <<<EOmesg

  <tr align=center bgcolor="{$color[4]}">
    <td colspan=$columns>
      <p>{$mesg}</p>
    </td>
  </tr>
EOmesg;
    }

    echo <<<EOfooter

    </table>
  </td></tr>
</table>

EOfooter;
}



/* ar_ftp_get($path)
 * 
 * Downloads the given file name from the user's account on
 * $AUTORESPOND_OPTS['ftphost'] and returns the contents as an array.
 */
function ar_ftp_get($path)
{
    global $username, $key, $onetimepad, $AUTORESPOND_OPTS;

    $ftphost = $AUTORESPOND_OPTS['ftphost'];
    if (!$ftphost)
        return array(FALSE, 'Sorry, but this plugin is not completely set '.
                            'up.  Please contact your System Administrator '.
                            'about configuring the Spam Rules plugin.');

    if (empty($path))
        //return array();
        return array(FALSE, 'no file was given to upload');

    // decrypt the user's password so we can pass it to the ftp site
    // (borrowed from the vacation plugin; thanks!)
    $password = OneTimePadDecrypt($key, $onetimepad);
    //echo "connecting to $username@$ftphost ($key/$onetimepad => $password)<br>\n";

    // upload the file to the user's home
    $ftp = ftp_connect($ftphost);
    $stat = ftp_login($ftp, $username, $password);
    if (!$ftp or !$stat) {
        return array(FALSE, "cannot connect to $ftphost: $php_errormsg");
    }

    if (! @ftp_chdir($ftp, dirname($path)))
        return array(FALSE);

    $file = basename($path);
    if (! @ftp_size($ftp, $file))
        return array(FALSE);

    // create a local temp file to store the rules
    $temp = tmpfile();
    $stat = @ftp_fget($ftp, $temp, $file, FTP_ASCII);
    ftp_close($ftp);

    // put each line of the temp file into an array
    rewind($temp);
    $data = array();
    while (!feof($temp)) {
        array_push($data, fgets($temp));
    }
    fclose($temp);
    return array(TRUE, $data);

    // download the mailfilter file and return it in an array
    //$data = @file("ftp://$username:$password@$ftphost/$to_get");
    //echo "data is: <pre>"; print_r($data); echo "</pre>\n";
    //return isset($data) ? array_map('trim', $data) : array();
}


/* ar_ftp_put($path, $data)
 * 
 * Uploads the text in $data to $path in the user's account on 
 * $AUTORESPOND_OPTS['ftphost'].
 * 
 * Parameters:
 *   $path:  (string) the file to be modified
 *   $data:  (string) the data to be written to $path; if it's an empty
 *           string, $path will be removed
 * 
 * Returns:
 *   nothing
 */
function ar_ftp_put($path, $data)
{
    global $username, $key, $onetimepad, $AUTORESPOND_OPTS;

    $ftphost = $AUTORESPOND_OPTS['ftphost'];
    if (!$ftphost)
        return array(FALSE, 'Sorry, but this plugin is not completely set '.
                            'up.  Please contact your System Administrator '.
                            'about configuring the Spam Rules plugin.');
    if (!$path)
        return array(FALSE, 'no file was given to upload');

    // decrypt the user's password so we can pass it to the ftp site
    // (borrowed from the vacation plugin; thanks!)
    $password = OneTimePadDecrypt($key, $onetimepad);

    // upload the file to the user's home
    $ftp = ftp_connect($ftphost);
    $stat = ftp_login($ftp, $username, $password);
    if (!$ftp or !$stat) {
        return array(FALSE, "cannot connect to $ftphost: $php_errormsg");
    }
    // if there is data to upload, write it to a temporary file and upload
    // its contents
    if ($data) {
        // create a file w/the new rules
        $temp = tmpfile();
        fwrite($temp, $data);
        rewind($temp);

        // search the path to the file and create each parent dir if it
        // doesn't exist
        $dir = dirname($path);
        $dirs = preg_split('/[\\/\\\]+/', $dir, -1, PREG_SPLIT_NO_EMPTY);
        foreach ($dirs as $d) {
            if ($d == '.') continue;
            if ($d == '/') continue;
            if (! @ftp_chdir($ftp, $d)) {
                if (!(@ftp_mkdir($ftp, $d) && @ftp_site($ftp, "chmod 0700 $d")
                     && @ftp_chdir($ftp, $d))) {
                    return array(FALSE, "error creating $dir: $php_errormsg");
                }
            }
        }
        /*
        $cwd = ftp_pwd($ftp);
        if ($cwd != "/" and $cwd != $dir and $cwd != "/$dir") {
            return array(FALSE, "error creating $dir (could only get to ".
                            "$cwd): $php_errormsg");
        }
        */

        $file = basename($path);
        $stat = ftp_fput($ftp, $file, $temp, FTP_ASCII);
        @ftp_site($ftp, "chmod 0600 $file");
        if (!$stat)
            return array(FALSE, "error changing $cwd/$file: $php_errormsg");
    }
    // otherwise delete the remote file (we don't want to leave an empty file)
    else {
        $stat = @ftp_delete($ftp, $path);
        if (!$stat)
            return array(FALSE, "error removing $path: $php_errormsg");
    }

    @ftp_close($ftp);
    fclose($temp);

    return array(TRUE);
}


/* ar_syslog($message)
 * 
 * Write a message to the syslog.
 * 
 * Parameters:
 *   $mesg:     text to send
 * 
 * Returns:
 *   nothing
 */
function ar_syslog($message)
{
    define_syslog_variables();
    openlog('forward', LOG_NDELAY, LOG_DAEMON);
    syslog(LOG_ERR, $message);
    closelog();
}


/* ar_change_autoresponse()
 */
function ar_change_autoresponse()
{
    global $color, $trash_folder, $AUTORESPOND_OPTS;

    $check_fwd = '';
    $check_keep = '';
    $check_vacation = '';
    $keep_nofilt = '';
    $keep_filt = '';
    $addrs = array();
    $check_trash = '';
    $files = array();

    // download and process the installed forward file
    list($status, $forward) = ar_ftp_get($AUTORESPOND_OPTS['forward_file']);
    if ($status === TRUE && ! empty($forward)) {
        foreach ($forward as $i => $f) {
            $f = trim($f);
            // skip if the line is empty
            if (!$f)
                continue;

            // if it looks like a disabled forward that we created
            // earlier, remember it as the default forward address
            if (@ereg('^# forward: *([^ ].*)', $f, $regs)) {
                array_push($addrs, $regs[1]);
            }
            // skip other comments
            else if (@ereg('^#', $f)) {
                continue;
            }
            // if the forward entry is a path,
            // either it's being put into the Trash or
            // we will presume that means a local copy is being kept
            else if (@ereg('^([\.\/\\][^ ]*)', $f, $regs)) {
                if (@ereg("$trash_folder$", $regs[1])) {
                    $check_trash = 'checked';
                }
                else {
                    $keep_nofilt = $check_keep = 'checked';
                    $keep_filt = '';
                    //array_push($files, $regs[1]);
                }
            }
            // if it matches our vacation regex, turn on
            // the checked flag for the form
            else if (@ereg($AUTORESPOND_OPTS['vacation_pattern'], $f)) {
                $check_vacation = 'checked';
            }
            // if it matches our filter command pattern, turn on the
            // keep checkbox and the filter option
            else if (@ereg($AUTORESPOND_OPTS['filter_pattern'], $f)) {
                $keep_filt = $check_keep = 'checked';
                $keep_nofilt = '';
            }
            // ignore other pipes
            else if (@ereg('^\"?\|', $f)) {
                continue;
            }
            // finally, if the line matches anything else, we presume
            // it's an email address for forwarding
            else {
                $check_fwd = 'checked';
                array_push($addrs, $f);
            }
        }
    }

    if (empty($addrs)) {
        $def_fwd = '';
    }
    else {
        $def_fwd = implode(', ', $addrs);
    }

    list($subject, $message) = ar_read_vacation();
    if (!$subject)
        $subject = $AUTORESPOND_OPTS['default_subject'];
    if (!$message)
        $message = $AUTORESPOND_OPTS['default_message'];

    echo <<<EOform_top
<tr bgcolor="{$color[12]}">
  <td colspan=3><form action="options.php" method=GET>
  <b>You can choose one or more of these options:</br>
  </td>
</tr>

EOform_top;

    // show the text input for the forward address
    $desc = $AUTORESPOND_OPTS['forward_desc'];
    $to_str = _("To:");
    echo <<<EOforward
<tr align=left valign=top bgcolor="{$color[4]}">
  <td><input type=checkbox name=forward $check_fwd></input></td>
  <td><b>Forward?</b></td>
  <td>$desc<br><br>
    <i>$to_str</i> &nbsp;&nbsp;
    <input type=text name=addr size=40 value="$def_fwd"></input>
  </td>
</tr>

EOforward;

    // show the vacation subject and message inputs
    $desc = $AUTORESPOND_OPTS['vacation_desc'];
    $subj_str = _("Subject:");
    $mesg_str = _("Message:");
    echo <<<EOvacation
<tr align=left valign=top bgcolor="$color[12]">
  <td><input type=checkbox name=vacation $check_vacation></input></td>
  <td><b>Reply?</b></td>
  <td>$desc<br><br>
    <i>$subj_str</i> &nbsp;&nbsp;
    <input type=text name=subject size=40 value="$subject"></input><br>
    <i>$mesg_str</i><br>
    <textarea name=message rows=10 cols=65>$message</textarea>
  </td>
</tr>

EOvacation;

    // show the "keep a local copy" checkboxes
    $desc = $AUTORESPOND_OPTS['keep_desc'];
    $keep_text = isset($AUTORESPOND_OPTS['filter_string'])
     ? '&nbsp;&nbsp;'. $AUTORESPOND_OPTS['keep_filt_desc']. "<br><br>\n".
       '<input type=radio name=keeptype value=unfiltered '. $keep_nofilt. '>'.
       '<i>unfiltered</i>&nbsp;&nbsp;'. "\n".
       '<input type=radio name=keeptype value=filtered '. $keep_filt. '>'.
       '<i>filtered</i>'. "\n"
     : "&nbsp;\n";
    echo <<<EOkeep
<tr align=left valign=top bgcolor="{$color[4]}">
  <td><input type=checkbox name=keep $check_keep></td>
  <td><b>Keep a copy here?</b></td>
  <td>$desc
    $keep_text
  </td>
</tr>

EOkeep;

    // show the "send it to the Trash" option
    $desc = $AUTORESPOND_OPTS['trash_desc'];
    if ($desc) {
        echo <<<EOkeep
<tr align=left valign=top bgcolor="{$color[12]}">
  <td><input type=checkbox name=trash $check_trash></td>
  <td><b>Send it to your Trash?</b></td>
  <td>$desc
  </td>
</tr>

EOkeep;
    }

    // close out the form
    echo <<<EOend
    <tr align=left>
      <td align=left colspan=3> 
        <br>
        <input type=submit name=action value="Finish"> &nbsp;
        <input type=reset> &nbsp;
        </form>
      </td>
    </tr>
EOend;
}


/* ar_install_autoresponse()
 */
function ar_install_autoresponse()
{
    global $color, $AUTORESPOND_OPTS, $trash_folder;
    global $forward, $addr, $keep, $trash, $vacation, $subject, $message,
           $keeptype;
    $data = '';

    sqgetGlobalVar('forward', $forward);
    sqgetGlobalVar('addr', $addr);
    sqgetGlobalVar('keep', $keep);
    sqgetGlobalVar('trash', $trash);
    sqgetGlobalVar('vacation', $vacation);

    if ($addr) {
        if ($forward) {
            $data = "$addr\n";
            $mesg = "New mail will be sent to <a href=\"mailto:$addr\">".
                    "<i>$addr</i></a>.";
        }
        else
            $data = "# forward: $addr\n";
    }
    if (!$forward)
        $mesg = "New mail will be kept here in your Inbox.";

    if ($vacation) {
	sqgetGlobalVar('subject', $vsubj);
	sqgetGlobalVar('message', $vmesg);
        $vacdata = "Subject: ". $vsubj. "\n\n". $vmesg;
        $vacdata = str_replace("\r\n", "\n", $vacdata);
        if (! @ereg("\n$", $vacdata))
            $vacdata .= "\n";
        list($stat, $ftpmesg) = ar_ftp_put($AUTORESPOND_OPTS['vacation_file'],
         $vacdata);

        $mesg .= "<br>\nSenders will get an automatic reply.";
        $data .= $AUTORESPOND_OPTS['vacation_string']. "\n";
    }
    else {
        $mesg .= "<br>\nNo automatic reply will be sent.";
    }

    if ($keep) {
	sqgetGlobalVar('keeptype', $keeptype);
	/*
        $keeptype = isset($_POST['keeptype']) ? $_POST['keeptype']
                                              : $_GET['keeptype'];
	*/
        if ($keeptype === 'filtered') {
            $data = $AUTORESPOND_OPTS['filter_string']. "\n" . $data;
            if ($addr)
                $mesg .= "<br>\nLocal copies will also be kept (and will be ".
                         "filtered through ".
                         $AUTORESPOND_OPTS['filter_descr']. ").";
            else
                $mesg .= "<br>\n... filtered through ".
                         $AUTORESPOND_OPTS['filter_descr']. '.';
        }
        else {
            $data = $AUTORESPOND_OPTS['keep_string']. "\n" . $data;
            if ($addr)
                $mesg .= "<br>\nLocal copies will also be kept.";
        }
    }

    if ($trash) {
        $trash = @ereg('^[\.\/\\]', $trash_folder) ? $trash_folder
                 : "./$trash_folder";
        $mesg .= "<br>\nMail will be kept in your Trash mailbox.";
        $data .= $trash. "\n";
    }

    ar_ftp_put($AUTORESPOND_OPTS['forward_file'], $data);

    echo <<<EOmesg

    <tr align=left valign=top bgcolor="$color[12]">
      <td>&nbsp;</td>
      <td><b>New settings saved:</b></td>
      <td><font color=green>$mesg</font></td>
    </tr>
    <tr align=left>
      <td colspan=3>&nbsp;</td>
    </tr>
EOmesg;
}


function ar_read_vacation()
{
    global $AUTORESPOND_OPTS;
    $subject = '';
    $message = '';

    //echo "reading vacation...<br>\n";

    // download and process the installed vacation message
    list($status, $vacation) = ar_ftp_get($AUTORESPOND_OPTS['vacation_file']);
    if ($status === TRUE && !empty($vacation)) {
        // if the vacation entry looks like an email Subject,
        // save it for the default
        if (@ereg('^Subject: (.*)', $vacation[0], $regs)) {
            $subject = $regs[1];
            array_shift($vacation);
            reset($vacation);
            if (@ereg("^\r?\n?$", $vacation[0]))
                array_shift($vacation);
        }
        $message = implode('', $vacation);
    }

    return array($subject, $message);
}


function ar_edit_vacation()
{
    global $color, $AUTORESPOND_OPTS;

    global $subject, $message;
    sqgetGlobalVar('subject', $subject);
    sqgetGlobalVar('message', $message);

    if (!$subject && !$message)
        list($subject, $message) = ar_read_vacation();
    else {
        if (! @ereg("\n$", $message))
            $message .= "\n";
        $data = "Subject: ". $subject. "\n\n". $message;
        $data = str_replace("\r\n", "\n", $data);
        list($stat, $ftpmesg) = ar_ftp_put($AUTORESPOND_OPTS['vacation_file'],
         $data);
    }

    if (!$subject)
        $subject = $AUTORESPOND_OPTS['default_subject'];
    if (!$message)
        $message = $AUTORESPOND_OPTS['default_message'];

    $subj_str = _("Subject:");
    $mesg_str = _("Message:");
    echo <<<EOform
  <form action="options.php?action=editvacation" method=POST
   onSubmit="window.refresh()">
  <tr valign=top bgcolor="$color[4]">
    <td>$subj_str</td>
    <td><input type=text name=subject size=40 value="$subject"></input></td>
  </tr>
  <tr valign=top bgcolor="$color[4]">
    <td>$mesg_str</td>
    <td><textarea name=message rows=12 cols=75>$message</textarea></td>
  </tr>

  <tr>
    <td colspan=3> 
      <br><input type=submit value="Update"> &nbsp; <input type=reset>
    </td>
  </tr>
  </form>

EOform;
}


?>
