<?php

/*
 * autorespond:  $Id: config.php,v 1.8 2003/06/28 00:29:25 shaug Exp $
 * (c) 2002 O'Shaughnessy Evans <shaug-sqml @ wumpus.org>
 */

$AUTORESPOND_VERSION = '0.4';

/*
 * Customize the plugin here.
 */

// The host that stores the user's forward file:
//  Each user with an IMAP account must have the same login and password here.
$AUTORESPOND_OPTS['ftphost'] = 'localhost';

// What is the name of the user's filter file?
//  for sendmail or postfix, it would be .forward
//  for qmail, .qmail
$AUTORESPOND_OPTS['forward_file'] = '.forward';

// What should the filter file contain?  (make sure to include the newline)
//
// ... for keeping a local copy:
$AUTORESPOND_OPTS['keep_string']    = '\\'. $GLOBALS['username'];
//
// ... for filtering:
// (if there is no filter available, be sure to unset this)
$AUTORESPOND_OPTS['filter_string']  = '"|/usr/local/bin/maildrop"';
// (a regexp to match the filter_string:)
$AUTORESPOND_OPTS['filter_pattern'] = '^\"?\| */usr/local/bin/maildrop\"?';
// (a title for the filter:)
$AUTORESPOND_OPTS['filter_descr']   = 'the Spam Rules';
//
// ... for the vacation program:
$AUTORESPOND_OPTS['vacation_string']  = '"|/usr/bin/vacation '.
                                        $GLOBALS['username'] . '"';
// (a regexp to match the vacation_string:)
$AUTORESPOND_OPTS['vacation_pattern'] = '^\"?\| *[^ ]+/vacation\"?';

// Configure the vacation autoresponder:
// ... where is the vacation message kept?
$AUTORESPOND_OPTS['vacation_file']    = '.vacation.msg';
// ... what should the default subject be?
$AUTORESPOND_OPTS['default_subject'] = 'Auto-Reply:  away from my mail';
// ... what should the default message be?
$AUTORESPOND_OPTS['default_message'] = <<<EOmesg
Hello.  I'm away from my mailbox right now, but I will read
your message when I return.  Thank you for your patience.

PS:  This automatic response is only sent after your first
message.  It won't be sent again in the near future, even if
you send more email before I return.

Best regards.

    -- {$GLOBALS['username']}
EOmesg;


/*
 * END OF BASIC CUSTOMIZATION
 * 
 * All config variables below can be used to change the messages presented
 * to the user in the Options interface.
 */


$AUTORESPOND_OPTS['default_header'] = <<<EOheader
<p>
  Here you can define various ways to automatically handle all your Incoming
  email.  <b>Please note:</b>  If you choose <i>Forward</i> or <i>Reply</i>,
  you will not keep copies of mail in your mailbox unless you also select
  <i>Keep a copy here</i>.
</p>

EOheader;
/*
<div align=left><p>
  For example, if you have more than one mailbox but you want to
  read them all from the same place, you could forward all of them to that
  address.  Just enter the address below.  If you've set up spam filters
  and want to continue using them for the mail you're keeping here, select
  <em>filtered</em>.  If you're not using the filters but still want to keep
  the local copy, select <em>unfiltered</em>.  If you want all your mail sent
  to the new address and never plan on reading it here, just select <em>no</em>.
</p></div>
*/

$AUTORESPOND_OPTS['default_footer'] = ''; //<<<EOfooter
//EOfooter;

$AUTORESPOND_OPTS['new_header'] = <<<EOheader
<div align=left><p>
  Your new forwarding rules have been saved.
</p></div>
EOheader;

$AUTORESPOND_OPTS['new_footer'] = ''; //<<<EOfooter
//EOfooter;

$AUTORESPOND_OPTS['vacation_header'] = <<<EOheader
  <p align=center><u>Vacation Message</u></p>
  <p align=left>
     Here you can change the message that is automatically sent to people 
     who send email to you.  The word "\$SUBJECT" in the <em>Subject</em>
     field will be replaced with the subject of the current message when the
     response is generated.  For example, if you've saved a vacation
     message with the <em>Subject</em> "Re: \$SUBJECT", and you receive a
     message with the <em>Subject</em> "I Am The Walrus", then the automatic
     response sent back will say "Re: I Am The Walrus".
  </p>
EOheader;
$AUTORESPOND_OPTS['vacation_footer'] = $GLOBALS['javascript_on']
 ? '<p>[ <a href="javascript:window.close()" onClick="window.opener.location.reload()">Close</a> ]</p>'
 : '';

$AUTORESPOND_OPTS['forward_desc'] = <<<EOdesc
Send all your Incoming email to another address:
EOdesc;
$AUTORESPOND_OPTS['vacation_desc'] = <<<EOdesc
Return a prewritten response, sometimes called a &quot;vacation message&quot;,
to all your senders:
EOdesc;
$AUTORESPOND_OPTS['keep_desc'] = <<<EOdesc
No matter where else your email goes, a copy can always be kept here in your
mailbox.  If you've set up <a href="../spamrule/options.php">Spam
filters</a>, the mail can be sent through those, or it can be stored
unmodified.
EOdesc;
$AUTORESPOND_OPTS['trash_desc'] = ''; 
//<<<EOdesc
//This is convenient if you don't check this mailbox often or know you'll be
//gone for a long time and don't want to go over your allotted disk space.
//EOdesc;

?>
