<?php
	/* At this point, we know the user has just logged in - it's time to do something. */
	global $sent_folder,$trash_folder,$username,$imapServerAddress,$imapPort,$onetimepad;
	global $auto_prune_sent_threshold,$default_move_to_trash,$auto_expunge;
	if ($auto_prune_sent_threshold == 0) {
		/* Plugin is disabled */
		return;
	}

	$secsago=(86400 * $auto_prune_sent_threshold); /* Convert days to seconds */
	$cutoffdate=date('d-M-Y',(time() - $secsago));

	/* Now, time to do the IMAP fuckery */
	$key=$_COOKIE['key'];
	$onetimepad=$_SESSION['onetimepad'];

	$imap=sqimap_login($username,$key,$imapServerAddress,$imapPort,0);
	if (!sqimap_mailbox_exists($imap,$sent_folder)) {
		/* Somehow, the user has a nonexistent sent folder. */
		return;
	}

	/* We don't need it yet, but we should do this before we
	   SELECT our sent mailbox */
	$notrash = false;
    if (!sqimap_mailbox_exists($imap,$trash_folder)) {
		/* They don't have a trash folder - we can still proceed,
		   but we can't copy the messages to trash */
		$notrash = true;
	} else {
		$trashbox=sqimap_mailbox_select($imap,$trash_folder);
		if ((strtolower($trashbox['RIGHTS'])) != "read-write") {
			/* Trash exists, but is read-only */
			$notrash = true;
		}
	}

	/* Now we can move on to the sent mailbox */
	$mbx=sqimap_mailbox_select($imap,$sent_folder);
	if ((strtolower($mbx['RIGHTS'])) != "read-write") {
		/* We don't have write access to Sent!  This shouldn't happen, but... */
		return;
	}

	$query = "SQM1 UID SEARCH SENTBEFORE $cutoffdate\r\n";
	
	fputs($imap,$query);
	
	$read=sqimap_fgets($imap); /* This is the search results */
	$discard=sqimap_fgets($imap); /* This is the OK tag at the end */
	
	/* Results in form: "* SEARCH <msg numbers separated by space"
	   Extract just the numbers, and comma separate them */
	$results=str_replace(' ',',',substr($read,9));

	$msglist=trim($results); /* get rid of that nasty whitespace */

	if (strlen($msglist) < 1) {
		/* There were no messages that matched the criteria */
		return;
	}
	/* Make the message list into a squished version - good for VERY big lists */
	$msglist=sqimap_message_list_squisher(explode(' ',$msglist));

	if ((sqimap_mailbox_exists($imap,$trash_folder)) and ($default_move_to_trash == true) and ($notrash == false)) {
		/* The trash folder exists, and the user wants us to use it */
		$query = "SQM2 UID COPY $msglist $trash_folder\r\n";
		fputs($imap,$query);
		$results=sqimap_fgets($imap);  /* Should be OK */
	}
	/* Ok, we copied if we had to - time to do some deletion */
	$query = 'SQM2 UID STORE ' . $msglist . ' +FLAGS.Silent (\Deleted)' . "\r\n";
	fputs($imap,$query);
	$results=sqimap_fgets($imap); /* Should be ok here too */

	fputs($imap,"SQM4 CLOSE\r\n"); /* Close the box we have SELECTed */

	/* Now we're done and ready to log out.
	   I'm not using sqimap_logout because I didn't flush the output above */
	fputs($imap,"SQM5 LOGOUT\r\n");
	fclose($imap);
			
?>
