<?php

/*
 * tnef.php
 *
 *  Bernd Wiegmann <bernd@wib-software.de>
 *  Graham Norbury <gnorbury@bondcar.com>
 *  (c) 2002 (GNU GPL - see ../../COPYING)
 *
 */

/*
 *   $Header: /storage/repository/attachment_tnef/tnef.php,v 1.22 2003/10/10 12:50:52 bernd Exp $
 *
 *   $Log: tnef.php,v $
 *   Revision 1.22  2003/10/10 12:50:52  bernd
 *   Don't try to hide the warning attachment. This prevented some attachments
 *   to be shown at all.
 *
 *   Revision 1.21  2003/10/08 15:34:26  bernd
 *   Fixed some bugs.
 *
 *   Revision 1.20  2003/10/08 15:29:23  bernd
 *   Removed old warning message about RTF attachments.
 *
 *   Revision 1.19  2003/10/08 15:19:36  bernd
 *   Display also RTF attachments and don't show useless attachments like to small
 *   RTF files or warning messages.
 *
 *   Revision 1.18  2003/09/11 11:36:45  bernd
 *   Preparations for beta release.
 *
 *   Revision 1.2  2003/07/12 21:54:10  bernd
 *   Removed broken code that caused warnings and changed some messages which are now translatable.
 *
 *   Revision 1.1.1.1  2003/07/02 09:12:46  bernd
 *   initial import into CVS
 *
 */
    
/* 
 *  Displays table of contents and handles attachment download for ms-tnef files
 *
 */

   if (!defined('SM_PATH')) {
      define('SM_PATH', '../../'); 
   }

   include_once(SM_PATH . 'include/validate.php');

   include_once(SM_PATH . 'functions/date.php');
   include_once(SM_PATH . 'functions/page_header.php');
   include_once(SM_PATH . 'functions/mime.php');

   include_once(SM_PATH . 'plugins/attachment_tnef/tnef_attachment.php');

   header("Pragma: ");
   header("Cache-Control: cache");

   sqgetGlobalVar('tnef_debug', $tnef_debug, SQ_SESSION);
   sqgetGlobalVar('tnef_download', $tnef_download, SQ_SESSION);

   sqgetGlobalVar('absolute_dl', $absolute_dl);
   sqgetGlobalVar('file_id', $file_id);
   sqgetGlobalVar('key', $key, SQ_COOKIE);
   sqgetGlobalVar('mailbox', $mailbox);
   sqgetGlobalVar('passed_ent_id', $passed_ent_id);
   sqgetGlobalVar('passed_id', $passed_id);
   sqgetGlobalVar('startMessage', $startMessage);
   sqgetGlobalVar('username', $username);

   $tnef_debug = 0; // change this to 1 to enable debugging output

   $tnef_download = (!isset($file_id)) ? 0 : 1;       // only display page if not downloading
   $tnef_debug = ((!$tnef_download) && $tnef_debug);  // debugging disabled when downloading

   sqsession_register($tnef_download, 'tnef_download');
   sqsession_register($tnef_debug, 'tnef_debug');

   // extract the tnef attachment and decode it
   $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
   sqimap_mailbox_select($imapConnection, $mailbox);
   $message = sqimap_get_message($imapConnection, $passed_id, $mailbox);
   $entity_tnef = getEntity($message,$passed_ent_id);

   $tnef = mime_fetch_body ($imapConnection, $passed_id, $passed_ent_id); 
   $tnef = decodeBody($tnef, $entity_tnef->header->encoding);

   $attachment = &new TnefAttachment($tnef_debug);
   $result = $attachment->decodeTnef($tnef);
   $tnef_files = &$attachment->getFilesNested();

   if (!$tnef_download)  // only display page if not downloading
   {
      displayPageHeader($color, "None");

?>
<br>
<table width="100%" border="0" cellspacing="0" cellpadding="2" align="center">
 <tr>
  <td bgcolor="<?php echo $color[0]; ?>">
   <b><center>
<?php

      echo _("Viewing") . " - ";
      if (isset($where) && isset($what))
      {
         // from a search
         echo "<a href=\"../../src/read_body.php?mailbox=" . urlencode($mailbox) .
              "&passed_id=$passed_id&where=" . urlencode($where) .
              "&what=".urlencode($what) . "\">" . _("View message") . "</a>";
      }
      else
      {   
         echo "<a href=\"../../src/read_body.php?mailbox=" . urlencode($mailbox) .
              "&passed_id=$passed_id&startMessage=$startMessage&show_more=0\">" .
              _("View message") . "</a>";
      }   
      echo "</center></b></td></tr></table>";

      // IMHO the following html is very difficult to interpret...
      // For consistency with the way other attachments are displayed
      // this is more or less a straight copy from mime.php
      $body = "<TABLE WIDTH=\"100%\" CELLSPACING=0 CELLPADDING=2 " .
              "BORDER=0 BGCOLOR=\"$color[0]\"><TR>\n" .
              "<TH ALIGN=\"left\" BGCOLOR=\"$color[9]\"><B>\n" .
              _("Mail Infos") . ':' .  "</B></TH></TR><TR><TD>\n" .
              "<TABLE CELLSPACING=0 CELLPADDING=1 BORDER=0>\n";

      $mailinfo = &$attachment->getMailinfo();
      $subject = $mailinfo->getSubject();
      $topic = $mailinfo->getTopic();
      $from_mail = $mailinfo->getFrom();
      $from_name = $mailinfo->getFromName();
      $obj = &$mailinfo->getDateSent();

      if ($subject) {
	$body .= '<TR><TD>&nbsp;&nbsp;</TD><TD><B>' . _("Subject") . ':</B></TD><TD>' . $subject . '</TD></TR>';
      }
      if (($topic) && ($topic != $subject)) {
	$body .= '<TR><TD>&nbsp;&nbsp;</TD><TD><B>' . _("Topic") . ':</B></TD><TD>' . $topic . '</TD></TR>';
      }
      if ($from_name) {
	$body .= '<TR><TD>&nbsp;&nbsp;</TD><TD><B>' . _("Name") . ':</B></TD><TD>' . $from_name . '</TD></TR>';
      }
      if ($from_mail) {
	$body .= '<TR><TD>&nbsp;&nbsp;</TD><TD><B>' . _("Name") . ':</B></TD><TD>' . $from_mail . '</TD></TR>';
      }
      if ($obj) {
	$body .= '<TR><TD>&nbsp;&nbsp;</TD><TD><B>' . _("Date") . ':</B></TD><TD>' . $obj->getString() . '</TD></TR>';
      }

      $body .= "</TABLE></TD></TR></TABLE>";
      echo($body);

      // IMHO the following html is very difficult to interpret...
      // For consistency with the way other attachments are displayed
      // this is more or less a straight copy from mime.php
      $body = "<TABLE WIDTH=\"100%\" CELLSPACING=0 CELLPADDING=2 " .
              "BORDER=0 BGCOLOR=\"$color[0]\"><TR>\n" .
              "<TH ALIGN=\"left\" BGCOLOR=\"$color[9]\"><B>\n" .
              _("Attachments") . ':' .  "</B></TH></TR><TR><TD>\n" .
              "<TABLE CELLSPACING=0 CELLPADDING=1 BORDER=0>\n";

      $show_it = 0;
      $id = 0;
      foreach ($tnef_files as $file) {

	if (get_class($file) != "tnefvcard") {
	  $dl_href = 'tnef.php?' . $HTTP_SERVER_VARS['QUERY_STRING'] . "&file_id=$id";
	  $body .= '<TR><TD>&nbsp;&nbsp;</TD><TD>' .
	    "<A HREF=\"$dl_href\">" . $file->getName() . "</A>&nbsp;</TD>" .
	    '<TD><SMALL><b>' . show_readable_size($file->getSize()) .
	    '</b>&nbsp;&nbsp;</small></TD>' .
	    sprintf("<TD><SMALL>[ %s ]&nbsp;</SMALL></TD>", $file->getType() ) .
	    '<TD><SMALL></SMALL></TD><TD><SMALL>&nbsp;' .
	    "<A HREF=\"$dl_href&absolute_dl=1\">" . _("download") . "</A>" .
	    "</SMALL></TD></TR>\n";
	  $show_it = 1;
	}
	$id++;
      }

      $body .= "</TABLE></TD></TR></TABLE>";

      if ($show_it > 0) {
	echo($body);
      }

      foreach ($tnef_files as $file) {

	if (get_class($file) == "tnefvcard") {
	  // IMHO the following html is very difficult to interpret...
	  // For consistency with the way other attachments are displayed
	  // this is more or less a straight copy from mime.php
	  $body = "<TABLE WIDTH=\"100%\" CELLSPACING=0 CELLPADDING=2 " .
	    "BORDER=0 BGCOLOR=\"$color[0]\"><TR>\n" .
	    "<TH ALIGN=\"left\" BGCOLOR=\"$color[9]\"><B>\n" .
	    _("Contact Information for") . ':&nbsp;' . $file->getName() . "</B></TH></TR><TR><TD>\n" .
	    "<TABLE CELLSPACING=0 CELLPADDING=1 BORDER=0>\n";

	  $value = $file->getGivenName();
	  if ($value) {
	    $disp .= $value;
	  }
	  $value = $file->getMiddleName();
	  if ($value) {
	    $disp .= ' ' . $value;
	  }
	  $value = $file->getSurname();
	  if ($value) {
	    $disp .= ' ' . $value;
	  }
	  if ($disp) {
	    $body .= '<TR><TD>&nbsp;&nbsp;</TD><TD><B>' . _("Name") . ':</B></TD><TD>' . $disp . '</TD></TR>';
	  }
	  unset($disp);

	  $disp = $file->getCompany();
	  if ($disp) {
	    $body .= '<TR><TD>&nbsp;&nbsp;</TD><TD><B>' . _("Company") . ':</B></TD><TD>' . $disp . '</TD></TR>';
	  }
	  unset($disp);

	  $telefones = &$file->getTelefones();
	  ksort($telefones);
	  foreach ($telefones as $telkey => $telvalue) {
	    $body .= '<TR><TD>&nbsp;&nbsp;</TD><TD><B>' . _($telkey) . ':</B></TD><TD>' . $telvalue . '</TD></TR>';
	  }

	  $emails = &$file->getEmails();
	  ksort($emails);
	  foreach ($emails as $emailkey => $emailvalue) {
	    $disp = $emailvalue[EMAIL_DISPLAY];
	    if (!$disp) {
	      $disp = $emailkey;
	    }
	    $body .= '<TR><TD>&nbsp;&nbsp;</TD><TD><B>' . _($disp) . ':</B></TD><TD>' . $emailvalue[EMAIL_EMAIL] . '</TD></TR>';
	    unset($disp);
	  }
	  $homepages = &$file->getHomepages();
	  foreach ($homepages as $hpkey => $hpvalue) {
	    $body .= '<TR><TD>&nbsp;&nbsp;</TD><TD><B>' . _($hpkey) . ':</B></TD><TD>' . $hpvalue . '</TD></TR>';
	  }

	  $body .= "</TABLE></TD></TR></TABLE>";
	  echo $body;
	}

      }


?>
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 ALIGN=CENTER>
<TR><TD BGCOLOR="<?PHP echo $color[4] ?>">
</TD></TR></TABLE>
</body></html>
<?PHP

   }
   else //download the requested attachment
   {
      set_time_limit(0); // disable 30 second timer in case download takes a while

      DumpHeaders($tnef_files[$file_id]->getType(),
                  $tnef_files[$file_id]->getName(),
                  $tnef_files[$file_id]->getSize(),
                  $absolute_dl);

      echo($tnef_files[$file_id]->getContent());
   }

?>
