<?php

/*
 * functions.php
 *
 *  Bernd Wiegmann <bernd@wib-software.de>
 *  Graham Norbury <gnorbury@bondcar.com>
 *  (c) 2002 (GNU GPL - see ../../COPYING)
 *
 */

/*
 *   $Header: /storage/repository/attachment_tnef/functions.php,v 1.5 2003/10/10 12:50:52 bernd Exp $
 *
 *   $Log: functions.php,v $
 *   Revision 1.5  2003/10/10 12:50:52  bernd
 *   Don't try to hide the warning attachment. This prevented some attachments
 *   to be shown at all.
 *
 *   Revision 1.4  2003/09/11 11:36:45  bernd
 *   Preparations for beta release.
 *
 *   Revision 1.2  2003/07/31 15:24:25  bernd
 *   Complete rework of tnef decoder
 *
 *   Revision 1.1.1.1  2003/07/02 09:12:46  bernd
 *   initial import into CVS
 *
 */

$ext_mime_array = array( '.gif' => 'image/gif',
			 '.jpg' => 'image/jpg',
			 '.png' => 'image/png',
			 '.vcf' => 'text/x-vcard',
			 '.zip' => 'application/zip',
			 '.rtf' => 'application/rtf',
			 '.pdf' => 'application/pdf'
			 );

function ext_to_mime($extension) {
  global $ext_mime_array;

  return  $ext_mime_array[$extension];
}

/*
 *  Generate browser-specific headers to initiate file download.
 *
 *  The following logic is a cleaned up version of ../../src/download.php
 *  which has been modified to include a Content-Length: header needed to
 *  enable the the download progress bar to work correctly.
 *
 *  Ideally this should be a generic method in the ../../functions hierachy
 *  so it can be called directly without getting all the other html gunk
 *  created by download.php.
 *
 */

function DumpHeaders($type, $filename, $length, $force)
{
   global $HTTP_USER_AGENT;

   $isIE = 0;
   if (strstr($HTTP_USER_AGENT, 'compatible; MSIE ') !== false &&
       strstr($HTTP_USER_AGENT, 'Opera') === false)
   {
      $isIE = 1;
   }

   $filename = ereg_replace('[^-a-zA-Z0-9\.]', '_', $filename);

   // A Pox on Microsoft and it's Office!
   if (!$force)
   {
      // Try to show in browser window
      header("Content-Disposition: inline; filename=\"$filename\"");
      header("Content-Type: $type; name=\"$filename\"");
      header("Content-Length: $length");
   }
   else
   {
      // Try to pop up the "save as" box
      if ($isIE)
      {
         header("Content-Disposition: inline; filename=$filename");
         header("Content-Type: application/download; name=\"$filename\"");
         header("Content-Length: $length");
      }
      else
      {
         header("Content-Disposition: attachment; filename=\"$filename\"");
         header("Content-Type: application/octet-stream; name=\"$filename\"");
         header("Content-Length: $length");
      }
   }
}

/*
 * Just a little helper for $tnef_debug == 1
 * Will not create any output in production environment.
 */

function tnef_log($string)
{
  error_log($string . "\n", 3, "/tmp/tnef.log");
}

function attachment_tnef_link_do(&$Args)
{
  $Args[1]['attachment_tnef']['href'] = '../plugins/attachment_tnef/tnef.php?startMessage=' .
    $Args[2] . '&passed_id=' . $Args[3] . '&mailbox=' .
    $Args[4] . '&passed_ent_id=' . $Args[5];

  if (isset($where) &&
      isset($what))
    {
      $Args[1]['attachment_tnef']['href'] .= '&where=' . urlencode($Args[8]) .
	'&what=' . urlencode($Args[9]);
    }

  $Args[1]['attachment_tnef']['text'] = _("view");
  $Args[6] = $Args[1]['attachment_tnef']['href'];
}

function attachment_tnef_preview_do()
{
  // TODO
  // Display a list of attachments under the tnef file so the user
  // does not have to click on "view" to directly access its contents
}

function tnef_getx($size, &$buf)
{
   $value = null;
   $len = strlen($buf);
   if ($len >= $size)
   {
      $value = substr($buf, 0, $size);
      $buf = substr_replace($buf, '', 0, $size);
   } else {
     substr_replace($buf, '', 0, $len);
   }
   return $value;
}

function tnef_geti8(&$buf)
{
   $value = null;
   $len = strlen($buf);
   if ($len >= 1)
   {
      $value = ord($buf{0});
      $buf = substr_replace($buf, '', 0, 1);
   } else {
     substr_replace($buf, '', 0, $len);
   }
   return $value;
}

function tnef_geti16(&$buf)
{
   $value = null;
   $len = strlen($buf);
   if ($len >= 2)
   {
      $value = ord($buf{0}) +
               (ord($buf{1}) << 8);
      $buf = substr_replace($buf, '', 0, 2);
   } else {
     substr_replace($buf, '', 0, $len);
   }
   return $value;
}

function tnef_geti32(&$buf)
{
   $value = null;
   $len = strlen($buf);
   if ($len >= 4)
   {
      $value = ord($buf{0}) +
               (ord($buf{1}) << 8) +
               (ord($buf{2}) << 16) +
               (ord($buf{3}) << 24);
      $buf = substr_replace($buf, '', 0, 4);
   } else {
     substr_replace($buf, '', 0, $len);
   }
   return $value;
}

?>
