<?php

/*
 * functions.php
 *
 *  Bernd Wiegmann <bernd@wib-software.de>
 *  Graham Norbury <gnorbury@bondcar.com>
 *  (c) 2002 (GNU GPL - see ../../COPYING)
 *
 */

/*
 *   $Header: /storage/repository/attachment_tnef/functions.php,v 1.1.1.1 2003/07/02 09:12:46 bernd Exp $
 *
 *   $Log: functions.php,v $
 *   Revision 1.1.1.1  2003/07/02 09:12:46  bernd
 *   initial import into CVS
 *
 */

/*
 *  Generate browser-specific headers to initiate file download.
 *
 *  The following logic is a cleaned up version of ../../src/download.php
 *  which has been modified to include a Content-Length: header needed to
 *  enable the the download progress bar to work correctly.
 *
 *  Ideally this should be a generic method in the ../../functions hierachy
 *  so it can be called directly without getting all the other html gunk
 *  created by download.php.
 *
 */

function DumpHeaders($type0, $type1, $filename, $length, $force)
{
   global $HTTP_USER_AGENT;

   $isIE = 0;
   if (strstr($HTTP_USER_AGENT, 'compatible; MSIE ') !== false &&
       strstr($HTTP_USER_AGENT, 'Opera') === false)
   {
      $isIE = 1;
   }

   $filename = ereg_replace('[^-a-zA-Z0-9\.]', '_', $filename);

   // A Pox on Microsoft and it's Office!
   if (!$force)
   {
      // Try to show in browser window
      header("Content-Disposition: inline; filename=\"$filename\"");
      header("Content-Type: $type0/$type1; name=\"$filename\"");
      header("Content-Length: $length");
   }
   else
   {
      // Try to pop up the "save as" box
      if ($isIE)
      {
         header("Content-Disposition: inline; filename=$filename");
         header("Content-Type: application/download; name=\"$filename\"");
         header("Content-Length: $length");
      }
      else
      {
         header("Content-Disposition: attachment; filename=\"$filename\"");
         header("Content-Type: application/octet-stream; name=\"$filename\"");
         header("Content-Length: $length");
      }
   }
}

/*
 * Just a little helper for $tnef_debug == 1
 * Will not create any output in production environment.
 */

function tnef_log($string)
{
  error_log($string . "\n", 3, "/tmp/tnef.log");
}

function attachment_tnef_link_do(&$Args)
{
  $Args[1]['attachment_tnef']['href'] = '../plugins/attachment_tnef/tnef.php?startMessage=' .
    $Args[2] . '&passed_id=' . $Args[3] . '&mailbox=' .
    $Args[4] . '&passed_ent_id=' . $Args[5];

  if (isset($where) &&
      isset($what))
    {
      $Args[1]['attachment_tnef']['href'] .= '&where=' . urlencode($Args[8]) .
	'&what=' . urlencode($Args[9]);
    }

  $Args[1]['attachment_tnef']['text'] = _("view");
  $Args[6] = $Args[1]['attachment_tnef']['href'];
}

function attachment_tnef_preview_do()
{
  // TODO
  // Display a list of attachments under the tnef file so the user
  // does not have to click on "view" to directly access its contents
}

?>
