<?php
  /*
   * setup.php - attachment_tnef plugin
   *  Graham Norbury <gnorbury@bondcar.com>
   *  v0.2 (c) 2002 (GNU GPL - see ../../COPYING)
   *
   *  Allows an attachment of mime type application/ms-tnef (winmail.dat) to be
   *  opened and its contents downloaded.
   *
   *  This file mostly copied and adapted from attachment_common.php
   *
   *  If you need help with this, or see improvements that can be made, please
   *  email me directly at the address above.
   *
   */

   function squirrelmail_plugin_init_attachment_tnef()
   {
      global $squirrelmail_plugin_hooks;
      $squirrelmail_plugin_hooks['attachment application/ms-tnef']['attachment_tnef'] = 'attachment_tnef_link';
      $squirrelmail_plugin_hooks['read_body_bottom']['attachment_tnef'] = 'attachment_tnef_preview';
   }

   function attachment_tnef_link(&$Args)
   {
     $Args[1]['attachment_tnef']['href'] = '../plugins/attachment_tnef/tnef.php?startMessage=' .
                                           $Args[2] . '&passed_id=' . $Args[3] . '&mailbox=' .
                                           $Args[4] . '&passed_ent_id=' . $Args[5];

     if (isset($where) &&
         isset($what))
     {
        $Args[1]['attachment_tnef']['href'] .= '&where=' . urlencode($Args[8]) .
                                               '&what=' . urlencode($Args[9]);
     }

     $Args[1]['attachment_tnef']['text'] = _("view");
     $Args[6] = $Args[1]['attachment_tnef']['href'];
   }

   function attachment_tnef_preview()
   {
      // TODO
      // Display a list of attachments under the tnef file so the user
      // does not have to click on "view" to directly access its contents
   }
?>
