<?PHP

/*
 * download_fn.php
 *  Graham Norbury <gnorbury@bondcar.com>
 *  (c) 2002 (GNU GPL - see ../../COPYING)
 *
 *  Generate browser-specific headers to initiate file download.
 *
 *  The following logic is a cleaned up version of ../../src/download.php
 *  which has been modified to include a Content-Length: header needed to
 *  enable the the download progress bar to work correctly.
 *
 *  Ideally this should be a generic method in the ../../functions hierachy
 *  so it can be called directly without getting all the other html gunk
 *  created by download.php.
 *
 */

function DumpHeaders($type0, $type1, $filename, $length, $force)
{
   global $HTTP_USER_AGENT;

   $isIE = 0;
   if (strstr($HTTP_USER_AGENT, 'compatible; MSIE ') !== false &&
       strstr($HTTP_USER_AGENT, 'Opera') === false)
   {
      $isIE = 1;
   }

   $filename = ereg_replace('[^-a-zA-Z0-9\.]', '_', $filename);

   // A Pox on Microsoft and it's Office!
   if (!$force)
   {
      // Try to show in browser window
      header("Content-Disposition: inline; filename=\"$filename\"");
      header("Content-Type: $type0/$type1; name=\"$filename\"");
      header("Content-Length: $length");
   }
   else
   {
      // Try to pop up the "save as" box
      if ($isIE)
      {
         header("Content-Disposition: inline; filename=$filename");
         header("Content-Type: application/download; name=\"$filename\"");
         header("Content-Length: $length");
      }
      else
      {
         header("Content-Disposition: attachment; filename=\"$filename\"");
         header("Content-Type: application/octet-stream; name=\"$filename\"");
         header("Content-Length: $length");
      }
   }
}

?>
