<?php

/**
 * hooks.php
 *
 * Copyright (c) 2004 Simon Newell <simonnew@speedymail.org>
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Allows an attachment of mime type application/document (.doc, .pdf, .sxw) to be
 * opened and its contents displayed on browser.
 *
 * Hook the various document mime types into the plugin.
 * ./doc: doclink
 * ./pdf: pdflink
 * ./sxw: sxwlink
 *
 * @package plugins
 * @subpackage attachment_doc
 */

  if (!defined('SM_PATH')) define('SM_PATH','../../');

  global $squirrelmail_plugin_hooks;
  $squirrelmail_plugin_hooks['attachment application/msword']['attachment_doc'] = 'attachment_doc_dochook';
  $squirrelmail_plugin_hooks['attachment application/pdf']['attachment_doc'] = 'attachment_doc_pdfhook';
  $squirrelmail_plugin_hooks['attachment application/octet-stream']['attachment_doc'] = 'attachment_doc_sxwhook';
  $squirrelmail_plugin_hooks['logout']['attachment_doc'] = 'attachment_doc_logout';

  function attachment_doc_logout(&$Args) {
    global $username;
    include_once(SM_PATH . 'plugins/attachment_doc/includes/config.php');
    include_once(SM_PATH . 'plugins/attachment_doc/includes/logout.php');
  }

  function attachment_doc_dochook(&$Args) {
    include_once(SM_PATH . 'plugins/attachment_doc/includes/link.php');
    attachment_doc_doclink($Args);
  }

  function attachment_doc_pdfhook(&$Args) {
    include_once(SM_PATH . 'plugins/attachment_doc/includes/link.php');
    attachment_doc_pdflink($Args);
  }

  function attachment_doc_sxwhook(&$Args) {
    include_once(SM_PATH . 'plugins/attachment_doc/includes/link.php');
    attachment_doc_sxwlink($Args);
  }
  
?>