<?php

/**
 * functions.php
 *
 * Copyright (c) 2004 Simon Newell <simonnew@speedymail.org>
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Functions for the attachment_doc plugin.
 *
 * @package plugins
 * @subpackage attachment_doc
 */

function init_log($username) {

	define_log($username);

	if (!(file_exists('CLEAN_LOG'))) {

		$fp = fopen(CLEAN_LOG, "a");

		if (!$fp) {
			die ("Invalid working directory or file. Please notify administrator.");
		}
	
		if (flock($fp, LOCK_EX)) {
			fputs($fp, "<?php /* Cleanup log for $username */ ?>\n");
			flock($fp, LOCK_UN);
		}

		fclose($fp);

	} else {
		die("Unable to log. Please notify administrator.");
	}
}

function cleanup_doc($username) {

	if (!defined('CLEAN_LOG') && !define_log($username)) {
		header("Location:../../index.php");
	}
  
	@include_once(CLEAN_LOG);
	@unlink(CLEAN_LOG);

}

function parse_image($filename) {

	eregi('[./]*[/](.*)>', $filename, $url);
	return $url[1];

}

function define_log($username) {

	global $dirname;

	if(!defined('CLEAN_LOG')) { 
		if (!isset($dirname) || $dirname == "")  {
			return false;
		} else { 
			return isset($dirname) && 
				define('CLEAN_LOG', $dirname."/".$username.".dat");
		}
	}

}

function log_image($username, $filename, $mode) {

	if ($filename == "") {
		return -1;
	}

	if (!defined('CLEAN_LOG')) {
		define_log($username);
	}

	$fp = fopen(CLEAN_LOG, "a");

	if (!$fp) {
		die ("Invalid working directory or file. Please notify administrator.");
	}
	
	/* Strip HTML and PHP tags from image filename */
	$filename = strip_tags($filename);

	if (!isset($filename) || $filename == "") {
		return -1;
	}

	if (flock($fp, LOCK_EX)) {
		if ($mode == 1)
			fputs($fp, "<?php @unlink(\"".$filename."\"); ?>\n");
		else if ($mode == 2)
			fputs($fp, "<?php @rmdir(\"".$filename."\"); ?>\n");
		flock($fp, LOCK_UN);
	} 

	fclose($fp);

}

function log_dir($username, $logdirname) {
	 if(empty($logdirname)) {
       return true;
   }
   if(file_exists($logdirname)) {
       $dir = dir($logdirname);
       while($file = $dir->read()) {
           if($file != '.' && $file != '..') {
               if(is_dir($logdirname.'/'.$file)) {
                   log_dir($username, $logdirname.'/'.$file);
               } else {
                   log_image($username, $logdirname.'/'.$file, 1);
               }
           }
       }
       $dir->close();
       log_image($username, $logdirname.'/'.$file, 2);
   } else {
       return false;
   }
   return true;
}

?>
