<?php

/**
 * view_doc.php
 *
 * Copyright (c) 2004 Simon Newell <simonnew@speedymail.org>
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Allows an attachment of mime type application/document (.doc, .pdf) to be
 * opened and its contents displayed on browser.
 *
 * This php converts the attachment document into .html and displayed the html page.
 *
 * The following code is modified from /src/view_text.php
 *
 * view_text.php -- Displays the main frameset
 *
 * Copyright (c) 1999-2003 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Who knows what this file does. However PUT IT HERE DID NOT PUT
 * A SINGLE FREAKING COMMENT IN! Whoever is responsible for this,
 * be very ashamed.
 *
 * $Id: view_text.php,v 1.17 2003/03/27 16:47:48 philippe_mingo Exp $
 *
 * @package plugins
 * @subpackage attachment_doc
 */


/* Path for SquirrelMail required files. */
define('SM_PATH','../../../');

/* SquirrelMail required files. */
include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'functions/imap.php');
include_once(SM_PATH . 'plugins/attachment_doc/includes/config.php');
include_once(SM_PATH . 'plugins/attachment_doc/includes/functions.php');

bindtextdomain('attachment_doc', SM_PATH . 'plugins/attachment_doc/locale');
textdomain('attachment_doc');

sqgetGlobalVar('key',        $key,          SQ_COOKIE);
sqgetGlobalVar('username',   $username,     SQ_SESSION);
sqgetGlobalVar('delimiter',  $delimiter,    SQ_SESSION);
sqgetGlobalVar('QUERY_STRING', $QUERY_STRING, SQ_SERVER);
sqgetGlobalVar('messages', $messages);
sqgetGlobalVar('passed_id', $passed_id, SQ_GET);
sqgetGlobalVar('doctype', $doctype, SQ_GET);

if ( sqgetGlobalVar('mailbox', $temp, SQ_GET) ) {
  $mailbox = $temp;
}
if ( !sqgetGlobalVar('ent_id', $ent_id, SQ_GET) ) {
  $ent_id = '';
}
if ( !sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_GET) ) {
  $passed_ent_id = '';
} 

$imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
$mbx_response =  sqimap_mailbox_select($imapConnection, $mailbox);

$message = &$messages[$mbx_response['UIDVALIDITY']]["$passed_id"];
$message_ent = &$message->getEntity($ent_id);
if ($passed_ent_id) {
    $message = &$message->getEntity($passed_ent_id);
}
   
$header = $message_ent->header;
$charset = $header->getParameter('charset');
$type0 = $header->type0;
$type1 = $header->type1;
$encoding = strtolower($header->encoding);

$body = mime_fetch_body($imapConnection, $passed_id, $ent_id);
$body = decodeBody($body, $encoding);

// convert doc to html
if (!(file_exists($dirname))) mkdir("$dirname", 0777);
if (strcasecmp($doctype, "doc") == 0) {
  $fp = fopen("$dirname/$docname", "w");
  fwrite($fp, $body);
  fclose($fp);
  system($wvWarecmd);
  unlink("$dirname/$docname");
} else if (strcasecmp($doctype, "pdf") == 0) {
  $fp = fopen("$dirname/$pdfname", "w");
  fwrite($fp, $body);
  fclose($fp);
  system($pdftohtmlcmd);
  unlink("$dirname/$pdfname");
}
// end of conversion

$msg_url = '../../../plugins/attachment_doc/includes/cleanup.php?' . $QUERY_STRING . '&amp;prefixname=' . $prefixname . '&amp;dirname=' . $dirname;
$msg_url = set_url_var($msg_url, 'ent_id', 0);

displayPageHeader($color, 'None');

echo "<BR><TABLE WIDTH=\"100%\" BORDER=0 CELLSPACING=0 CELLPADDING=2 ALIGN=CENTER><TR><TD BGCOLOR=\"$color[0]\">".
     "<B><CENTER>".
     _("Viewing a document attachment") . " - ";
echo '<a href="'.$msg_url.'">'. _("View message") . '</a>';

$dwnld_url = '../../../src/download.php?'. $QUERY_STRING.'&amp;absolute_dl=true';
echo '</b></td><tr><tr><td><CENTER><A HREF="'.$dwnld_url. '">'.
     _("Download this as a file").
     "</A></CENTER><BR>".
     "</CENTER></B>".
     "</TD></TR></TABLE>".
     "<TABLE WIDTH=\"98%\" BORDER=0 CELLSPACING=0 CELLPADDING=2 ALIGN=CENTER><TR><TD BGCOLOR=\"$color[0]\">".
     "<TR><TD BGCOLOR=\"$color[4]\">";

// display converted html page
if (file_exists("$dirname/$htmlname")) { // conversion is successful
  $handle = fopen("$dirname/$htmlname", "r");
  while (!feof($handle)) {
    $buffer = fgets($handle, 4096);
    if (!(stristr($buffer, "img") === FALSE)) {
      /* Extract image filename */
      $img = eregi_replace('(.*<img.*src.*=.*["])([[:alnum:]_-]+\.[[:alnum:]]{3,4})(["].*>.*)','\\2', $buffer);

      /* Append relative path to temp directory */
      $buffer = eregi_replace('(.*<img.*src.*=.*["])([[:alnum:]_-]+\.[[:alnum:]]{3,4})(["].*>.*)','\\1'.$dirname.'/\\2\\3', $buffer);

      echo $buffer;
      if ($img != "") {
      	/* Strip HTML and PHP tags from image filename */
        $img = strip_tags($img);
      	if (isset($img) && $img != "") {
      		log_image ($username, realpath($dirname)."/".$img);
          $pos = strpos($img, ".");
          $imgwmf = substr($img, 0, $pos) . ".wmf";
      		log_image ($username, realpath($dirname)."/".$imgwmf);
	      }
      }
    } else {
      echo $buffer;
    }
  }
  fclose($handle);
  unlink("$dirname/$htmlname");

  echo '<br><a href="'.$msg_url.'">'. _("Back to message") . '</a><br>';
  echo "<div align='center'><br><br><br><hr>";
  echo _("Hosted by:") . "<a href=$sflink><img src=$sfimgsrc width='88' height='31' border='0' alt=" . _("SourceForge Logo") . "></a> ";
  if (strcasecmp($doctype, "doc") == 0) {
    echo _("Powered by:") . "<a href=$wvlink><img src=$wvimgsrc width='88' height='31' border='0' alt=" . _("wvWare Logo") . "></a>";
  } else if (strcasecmp($doctype, "pdf") == 0) {
    echo _("Powered by:") . "<a href=$pdflink>" . _("pdftohtml") . "</a>";
  }
  echo " <a href=$pluginlink><img src=$pluginimgsrc width='205' height='35' border='0' alt=" . _("Plugin Logo") . "></a>";
  echo "<hr></div>";
} else { // conversion failed, display error page
  if (file_exists(SM_PATH . 'plugins/attachment_doc/includes/error.html')) {
    $handle = fopen(SM_PATH . 'plugins/attachment_doc/includes/error.html', "r");
    while (!feof($handle)) {
      $buffer = fgets($handle, 4096);
      echo $buffer;
    }
    fclose($handle);
  } else {
    echo "<br>" . _("The requested html page could not be retrieved.");
    echo "<br>" . _("An error condition occurred while trying to display the html page converted from your document attachment.");
    echo "<br>" . _("Please retry your request or contact your administrator.");
  }
}
// end of display

echo "</TD></TR></TABLE>";

?>
