<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@advcs.org
    Home Site ...... http://www.advcs.org/
    Program ........ Archive Mail
    Version ........ 0.8
    Purpose ........ Allows you to download your email in a compressed archive

*******************************************************************************/


    global $msg, $username, $attachment_dir, $mailbox, $charset,
           $data_dir, $composesession, $uid_support, $sort,
           $msgs, $thread_sort_messages, $allow_server_sort, $show_num,
           $compose_messages, $startMessage, $imapConnection, $archivetype;

   sqgetGlobalVar('archiveButton',$archiveButton);

   if (!isset($archiveButton))
      return;
   if (!isset($msg) || !is_array($msg))
      return;
   include_once(SM_PATH . 'functions/imap.php');
   $hashed_dir = getHashedFile($username, $data_dir, '$username.pref');
   $archivefilenames = getPref($hashed_dir, $username, 'archivefilenames');
   $archiveattachments = getPref($hashed_dir, $username, 'archiveattachments');
   $archiveent = getPref($hashed_dir, $username, 'archiveent');
   $archivetype = getPref($hashed_dir, $username, 'archivetype');

   if ($archivetype == 0)
      $t = "zip";
   if ($archivetype == 1)
      $t = "gzip";
   if ($archivetype == 2)
      $t = "text";
   if ($archivetype == 3)
      $t = "tar";

   include_once(SM_PATH . 'plugins/archive_mail/includes/os.php');
   include_once(SM_PATH . "plugins/archive_mail/includes/compression/$t.php");
   if (!ini_get("safe_mode"))
      set_time_limit(0);

   $zipfile = new zipfile();

   if ($thread_sort_messages || $allow_server_sort)
      $start_index=0;
   else
      $start_index = ($startMessage-1) * $show_num;
   $i = 0;
   $j = 0;
   $mbox = '';
   $c = 0;
   while ($j < count($msg)) {
      if (isset($msg[$i])) {
         $id = $msg[$i];

            if ($archiveent == 3) {
               include (SM_PATH . 'plugins/archive_mail/includes/formats/maildir.php');
            }
            if ($archiveent == 2) {
               include (SM_PATH . 'plugins/archive_mail/includes/formats/mbox.php');
            }

            if ($archiveent == 1) {
               include (SM_PATH . 'plugins/archive_mail/includes/formats/eml.php');
            }
            if ($archiveent == 0) {
               include (SM_PATH . 'plugins/archive_mail/includes/formats/seperate.php');
            }
         $j++;
      }
      $i++;
   }
   $filename = archive_replace_str($mailbox, '-');

   if ($archiveent == 2)
      $zipfile -> addFile($mbox, "$filename");

   sendheader($filename);
   header("Content-Length: " . strlen($zipfile -> file()));
   echo $zipfile -> file();

   exit;

function archive_replace_str($temp, $temp2 = ' ') {
   $temp = str_replace(chr(92), $temp2, $temp);
   $temp = str_replace('/', $temp2, $temp);
   $temp = str_replace(':', $temp2, $temp);
   $temp = str_replace('>', $temp2, $temp);
   $temp = str_replace('<', $temp2, $temp);
   $temp = str_replace('|', $temp2, $temp);
   $temp = str_replace('?', $temp2, $temp);
   $temp = str_replace('*', $temp2, $temp);
   $temp = str_replace(chr(34), $temp2, $temp);
   return $temp;
}

function checkincrement($tempsuffix) {
   global $names;
   if (isset($names[$tempsuffix])) {
      $names[$tempsuffix] = $names[$tempsuffix] + 1;
      $increment = $names[$tempsuffix];
      $increment = ' - ' . $increment;
   } else {
      $names[$tempsuffix] = 1;
      $increment = '';
   }
   return $increment;
}

function archive_names ($archivefilenames, $email, $date, $c, $subject) {
   switch ($archivefilenames) {
      case 0:     // Numbers
         $name = $c;
         break;
      case 1:     // Date
         $name = $date;
         break;
      case 2:     // Date - Email
         $name = $date . ' - ' . $email;
         break;
      case 3:     // Email
         $name = $email;
         break;
      case 4:     // Email - Date
         $name = $email . ' - ' . $date;
         break;
      case 5:     // Subject
         $name = $subject;
         break;
      case 6:     // Email - Subject
         $name = $email . " - ($subject)";
         break;
      case 7:     // Date - Subject
         $name = $date . " - ($subject)";
         break;
      case 8:     // Subject - Email
         $name = "($subject) - " . $email;
         break;
      case 9:     // Subject - Date
         $name = "($subject) - " . $date;
         break;
      default:
         break;
   }
   return $name;
}

?>