<?php
/**
 * Advanced Settings plugin init
 * Copyright (C) 2006 The SquirrelMail Project Team
 * This program is licensed under GPL. See COPYING for details
 * @author Tomas Kuliavas <tokul@users.sourceforge.net>
 * @version $Id: setup.php,v 1.2 2006/04/15 06:12:21 tokul Exp $
 * @package sm-plugins
 * @subpackage advanced_settings
 */

/** Init plugin */
function squirrelmail_plugin_init_advanced_settings() {
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['optpage_set_loadinfo']['advanced_settings']='advset_optpage_set_loadinfo';
    $squirrelmail_plugin_hooks['optpage_register_block']['advanced_settings']='advset_optpage_register_block';
    $squirrelmail_plugin_hooks['loading_prefs']['advanced_settings']='advset_loading_prefs';
}

/** Hooked function to create advanced_settings widgets */
function advset_optpage_set_loadinfo() {
    include_once(SM_PATH . 'plugins/advanced_settings/functions.php');
    advset_optpage_set_loadinfo_do();
}

/** Hooked function to add advanced settings option block */
function advset_optpage_register_block() {
    include_once(SM_PATH . 'plugins/advanced_settings/functions.php');
    advset_optpage_register_block_do();
}

/** Hooked function to load advanced settings */
function advset_loading_prefs() {
    include_once(SM_PATH . 'plugins/advanced_settings/functions.php');
    advset_loading_prefs_do();
}

/**
 * Plugin version function
 * @return string version string
 */
function advanced_settings_version() {
    return '1.0';
}
?>