<?php
/**
 * Advanced settings plugin option block
 *
 * Copyright (C) 2006 The SquirrelMail Project Team
 * This program is licensed under GPL. See COPYING for details
 * @author Tomas Kuliavas <tokul@users.sourceforge.net>
 * @version $Id: options.php,v 1.3 2006/04/15 06:12:21 tokul Exp $
 * @package sm-plugins
 * @subpackage advanced_settings
 */

/** Define the group constants */
define('SMOPT_GRP_ADV_MAILBOX',0);
define('SMOPT_GRP_ADV_COMPOSE',1);

/**
 * Function is used to build internal plugin widget data
 */
function load_optpage_advanced_settings() {
    /* Build a simple array into which we will build options. */
    $optgrps = array();
    $optvals = array();

    /** Switch to plugin domain */
    bindtextdomain('advanced_settings',SM_PATH . 'locale');
    textdomain('advanced_settings');

    /** Settings related to mailbox */
    $optgrps[SMOPT_GRP_ADV_MAILBOX] = _("Advanced Mailbox Options");
    $optvals[SMOPT_GRP_ADV_MAILBOX] = array();

    $optvals[SMOPT_GRP_ADV_MAILBOX][] = array(
        'name'    => 'auto_expunge',
        'caption' => _("Auto expunge"),
        'type'    => SMOPT_TYPE_BOOLEAN,
    );

    $optvals[SMOPT_GRP_ADV_MAILBOX][] = array(
        'name'    => 'use_special_folder_color',
        'caption' => _("Use special folder color"),
        'type'    => SMOPT_TYPE_BOOLEAN,
        'refresh' => SMOPT_REFRESH_FOLDERLIST
    );

    $optvals[SMOPT_GRP_ADV_MAILBOX][] = array(
        'name'    => 'list_special_folders_first',
        'caption' => _("List special folders first"),
        'type'    => SMOPT_TYPE_BOOLEAN,
        'refresh' => SMOPT_REFRESH_FOLDERLIST,
        'save'    => 'advset_remove_mailbox_cache'
    );

    /** Message composition options */
    $optgrps[SMOPT_GRP_ADV_COMPOSE] = _("Advanced Message Composition Options");
    $optvals[SMOPT_GRP_ADV_COMPOSE] = array();
    $optvals[SMOPT_GRP_ADV_COMPOSE][] = array(
        'name'    => 'default_use_priority',
        'caption' => _("Use email priorities"),
        'type'    => SMOPT_TYPE_BOOLEAN
    );

    /** revert to sm domain */
    bindtextdomain('squirrelmail',SM_PATH . 'locale');
    textdomain('squirrelmail');

    /* Assemble all this together and return it as our result. */
    $result = array(
        'grps' => $optgrps,
        'vals' => $optvals,
        'xtra' => ''
    );
    return ($result);
}

/**
 * Removes cached folder tree information
 * @param mixed $option saved option value
 */
function advset_remove_mailbox_cache($option) {
    /* remove boxesnew from session in order to force rebuild of folder tree */
    sqsession_unregister('boxesnew');
    /* standard option saving code */
    save_option($option);
}
?>