<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@advcs.org
    Home Site ...... http://www.advcs.org/
    Program ........ Address Add
    Version ........ 2.0
    Purpose ........ Allows you to add the From address to the address book

*******************************************************************************/

   chdir("..");
   if (!defined('SM_PATH'))
      define('SM_PATH','../');
   if (file_exists(SM_PATH . 'include/validate.php')) {
      include_once(SM_PATH . 'include/validate.php');
   } else {
      if (file_exists(SM_PATH . 'src/validate.php'))
         include_once(SM_PATH . 'src/validate.php');
   }

   include_once(SM_PATH . 'functions/i18n.php');
   include_once(SM_PATH . 'functions/addressbook.php');

   // open address book, trash errors, skip LDAP
   $address = addressbook_init(false, true);

   global $_GET;
   $nick = '';
   if (isset($_GET['nick']))
      $nick = $_GET['nick'];
   $nick = strip_tags(urldecode(urldecode($nick)));
   $name = '';
   if (isset($_GET['name']))
      $name = $_GET['name'];
   $name = strip_tags(urldecode(urldecode($name)));
   $email = '';
   if (isset($_GET['email']))
      $email = $_GET['email'];
   $email = strip_tags(urldecode(urldecode($email)));
   $first = '';
   if (isset($_GET['first']))
      $first = $_GET['first'];
   $first = strip_tags(urldecode(urldecode($first)));
   $last = '';
   if (isset($_GET['last']))
      $last = $_GET['last'];
   $last = strip_tags(urldecode(urldecode($last)));

   displayPageHeader($color, "None");

   bindtextdomain('address_add', SM_PATH . 'plugins/address_add/locale');
   textdomain('address_add');

   print "<form action=\"../../src/addressbook.php\" name=f_add method=\"post\">\n";
   print "<table width=\"100%\" cols=1 align=center>\n";
   print "   <tr>\n";
   print "      <th bgcolor=\"$color[0]\" align=center>";
   print        '<strong>' . sprintf(_("Add to %s"), $address->localbackendname) . '</strong>';
   print "      </th>\n";
   print "   </tr>\n";
   print "</table>\n";
   print "<table border=0 cellpadding=1 cols=2 width=\"90%\" align=center>\n";
   print "   <tr>\n";
   print "      <td width=50 bgcolor=\"$color[4]\" align=right>" . _("Nickname") . ":</td>";
   print "      <td bgcolor=\"$color[4]\" align=left><input name=\"addaddr[nickname]\" size=15 value=\"$nick\">&nbsp;<small>" . _("Must be unique") . "</small></td></tr>\n";
   print "   <tr>\n";
   print "      <td width=50 bgcolor=\"$color[4]\" align=right>" . _("E-mail address") . ":</td>";
   print "      <td bgcolor=\"$color[4]\" align=left>";
   print "      <input type=text  size=45 name=\"addaddr[email]\" value=\"" . htmlspecialchars($email) . "\">\n";
   print "      </td>\n";
   print "   </tr>\n";
   print "   <tr>\n";
   print "      <td width=50 bgcolor=\"$color[4]\" align=right>" . _("First name") . ":</td>\n";
   print "      <td bgcolor=\"$color[4]\" align=left><input name=\"addaddr[firstname]\" size=45 value=\"$first\"></td>\n";
   print "   </tr>\n";
   print "   <tr>\n";
   print "      <td width=50 bgcolor=\"$color[4]\" align=right>" . _("Last name") . ":</td>\n";
   print "      <td bgcolor=\"$color[4]\" align=left><input name=\"addaddr[lastname]\" size=45 value=\"$last\"></td>\n";
   print "   </tr>\n";
   print "   <tr>\n";
   print "      <td width=50 bgcolor=\"$color[4]\" align=right>" . _("Additional info") . ":</td>\n";
   print "      <td bgcolor=\"$color[4]\" align=left><input name=\"addaddr[label]\" size=45 value=\"\"></td>\n";
   print "   </tr>\n";
   print "   <tr>\n";
   print "      <td colspan=2 bgcolor=\"$color[4]\" align=center><input type=submit name=\"addaddr[SUBMIT]\" value=\"" . _("Add address") . "\"></td>\n";
   print "   </tr>\n";
   print "</table>\n";
   print "</form></body>\n";
   print "</html>\n";
   textdomain('squirrelmail');
?>