<?php

/**
 * modifyGroup.php
 *
 * 2002 @ Kelvin Ho. abook_group_plugin v0.1
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * script to modify group
 *
 */

chdir('..');
require_once('../src/validate.php');
require_once('../functions/display_messages.php');
require_once('../functions/addressbook.php');
include_once('../plugins/abook_group/abook_group_database.php');
include_once('../plugins/abook_group/abook_group_functions.php');

/* --- End functions --- */

global $mailbox, $username;

/* Initialize addressbook */
$abook = addressbook_init();

$myparams = array();
$myparams['dsn'] = $addrbook_dsn;
$myparams['table'] = 'addressgroups';
$myparams['owner'] = $username;

$abookGroups = new abook_group_database($myparams);

if (!$opt){
	$opt = "edit";
}

if ($opt=="delete"){
	$abookGroups->deleteGroup($groupName);
}
elseif ($opt=="editexe"){
    $abookGroups->modifyGroup($groupName, $newGroupName);
}

if ($opt!="edit"){
	if ($abookGroups->error){
		$message = $abookGroups->error;
	}
	else{
		header("Location: list_abook_group.php");
	}
}

displayPageHeader($color, $mailbox);

?>

<table width="95%" align=center cellpadding=2 cellspacing=2 border=0>
<tr><td bgcolor="<?php echo $color[0] ?>">
   <center><b><?php echo _("Modify Group Name") ?></b></center>
</td></tr></table>
<form name="form" method="post" action="<?php echo $PHP_SELF ?>">
  <p align="center"><b>&nbsp; </b></p>
  <p align="center"><b>
    <?php echo $message ?>
    </b></p>
  <table width="95%" align="center">
    <tr>
      <td width="50%">Old Group Name</td>
      <td width="50%"><b> 
        <?php echo $groupName ?>
        </b></td>
    </tr>
	<tr>
      <td width="50%">New Group Name</td>
      <td width="50%">
        <input type="text" name="newGroupName" value="<?php echo $groupName  ?>">
      </td>
    </tr>		
</table>
  <p align="center">
    <input type="hidden" name="opt" value="editexe">
    <input type="hidden" name="groupName" value="<?php echo $groupName ?>">
    <input type="submit" name="Modify" value="Modify">
  </p>
</form>
<?php display_abook_group_footer(); ?>
</body></html>
