<?php

/**
  * SquirrelMail Address Book Grouping and Pagination Plugin
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage abook_group_pagination
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_abook_group_pagination()
{

   global $squirrelmail_plugin_hooks;


   // SM 1.4.x - Add pagination and grouping selector to address book table header
   //
   $squirrelmail_plugin_hooks['address_book_header']['abook_group_pagination']
      = 'add_pagination_and_grouping';


   // SM 1.5.x - Add grouping selector to address book table header
   //
   $squirrelmail_plugin_hooks['template_construct_addressbook_list.tpl']['abook_group_pagination']
      = 'add_pagination_and_grouping';


   // Filter address book search results
   //
   $squirrelmail_plugin_hooks['abook_list_filter']['abook_group_pagination']
      = 'filter_address_book_listing';


   // show options on display preferences page
   //
   $squirrelmail_plugin_hooks['optpage_loadhook_display']['abook_group_pagination']
      = 'abook_group_pagination_display_options';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['abook_group_pagination']
      = 'abook_group_pagination_check_configuration';

}



/**
  * Returns info about this plugin
  *
  */
function abook_group_pagination_info()
{

   return array(
                 'english_name' => 'Address Book Grouping and Pagination',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '1.1',
                 'required_sm_version' => '1.4.9',
                 'requires_configuration' => 0,
                 'summary' => 'Allows grouping of address book entries and adds pagination to the address book list page.',
                 'details' => 'This plugin adds pagination to the address listing page and, if allowed per the configuration file, adds address book grouping functionality to SquirrelMail.  Users may define any number of groups to which addresses can be added (and addresses may be added to more than one group).  The address listing page is then adorned with a filtering selector that lets the listing be filtered by one or more groups.  Grouping is backend-agnostic.  That is, no matter what address book backends are in use, this plugin will work the same, and there are NO changes required whatsoever to begin using grouping functionality.',
                 'per_version_requirements' => array(
                    '1.5.2' => array(
                       'requires_source_patch' => 0,
                       'required_plugins' => array()
                    ),
                    '1.5.0' => array(
                       'requires_source_patch' => 1,
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                    '1.4.14' => array(
                       'requires_source_patch' => 0,
                    ),
                    '1.4.10' => array(
                       'required_plugins' => array()
                    ),
                    '1.4.9' => array(
                       'requires_source_patch' => 1,
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                 ),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function abook_group_pagination_version()
{
   $info = abook_group_pagination_info();
   return $info['version'];
}



/**
  * Add pagination and grouping selector to address book table header
  *
  */
function add_pagination_and_grouping($args)
{
   include_once(SM_PATH . 'plugins/abook_group_pagination/functions.php');
   return add_pagination_and_grouping_do($args);
}



/**
  * Filter address book search results
  *
  */
function filter_address_book_listing(&$args)
{
   include_once(SM_PATH . 'plugins/abook_group_pagination/functions.php');
   return filter_address_book_listing_do($args);
}



/**
  * Display user configuration options on display preferences page
  *
  */
function abook_group_pagination_display_options()
{
   include_once(SM_PATH . 'plugins/abook_group_pagination/functions.php');
   abook_group_pagination_display_options_do();
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function abook_group_pagination_check_configuration()
{
   include_once(SM_PATH . 'plugins/abook_group_pagination/functions.php');
   return abook_group_pagination_check_configuration_do();
}



