<?php

/**
  * SquirrelMail Address Book Grouping and Pagination Plugin
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage abook_group_pagination
  *
  */

global $agp_abook_pagination, $agp_abook_pagination_allow_override,
       $agp_grouping, $max_pagination_links_to_show, $small_paginator_text;


// This controls if address grouping functionality
// will be enabled
//
// 1 = yes, 0 (zero) = no
//
$agp_grouping = 1;



// This controls if pagination will be used on the
// address book page.  Set it to 0 (zero) to turn
// off pagination or the number of items PER address
// book backend to show on each page
//
// This is only used in SquirrelMail 1.4.x
//
$agp_abook_pagination = 15;



// Should users be able to control address
// book pagination themselves?
//
// 1 = yes, 0 (zero) = no
//
// This is only used in SquirrelMail 1.4.x
//
$agp_abook_pagination_allow_override = 1;



// When pagination is enabled, how many page links
// should be shown at the most?  Must be at least 3.
//
// This is only used in SquirrelMail 1.4.x
//
$max_pagination_links_to_show = 5;



// Should the paginator links be in small text?
//
// 1 = yes, 0 (zero) = no
//
// This is only used in SquirrelMail 1.4.x
//
$small_paginator_text = 0;



