<?php

/**
 * listMembers.php
 *
 * 2002 @ Kelvin Ho. abook_group_plugin v0.1
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * List Group members
 */
if (!defined('SM_PATH'))define('SM_PATH','../../');

include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'functions/date.php');
include_once(SM_PATH . 'functions/display_messages.php');
include_once(SM_PATH . 'functions/addressbook.php');
include_once(SM_PATH . 'functions/plugin.php');
include_once(SM_PATH . 'functions/strings.php');
include_once(SM_PATH . 'plugins/abook_group/abook_group_database.php');
include_once(SM_PATH . 'plugins/abook_group/abook_group_functions.php');


/* --- End functions --- */

global $mailbox, $username;

/* Set globals */
sqgetGlobalVar('username', $username, SQ_POST);
sqgetGlobalVar('mailbox', $mailbox, SQ_POST);
sqgetGlobalVar('myparams', $myparams, SQ_POST);
sqgetGlobalVar('abook', $abook, SQ_POST);
sqgetGlobalVar('nickNameBackEnd', $nickNameBackEnd, SQ_POST);
sqgetGlobalVar('userData', $userData, SQ_POST);
sqgetGlobalVar('groupName', $groupName, SQ_GET);
sqgetGlobalVar('message', $message, SQ_POST);
sqgetGlobalVar('myGroupMembers', $myGroupMembers, SQ_POST);
sqgetGlobalVar('abookGroups', $abookGroups, SQ_POST);
sqgetGlobalVar('remove', $remove, SQ_POST);
sqgetGlobalVar('name', $name, SQ_POST);
sqgetGlobalVar('nickName', $nickName, SQ_POST);
sqgetGlobalVar('backendName', $backendName, SQ_POST);


/* End globals */

displayPageHeader($color, $mailbox);

/* Initialize addressbook */
$abook = addressbook_init();

$myparams = array();
$myparams['dsn'] = $addrbook_dsn;
$myparams['table'] = 'addressgroups';
$myparams['owner'] = $username;

$abookGroups = new abook_group_database($myparams);
if (isset($remove) && !empty($remove)){
       if (isset($nickNameBackEnd) && !empty($nickNameBackEnd)){

           $userData = explodeUserArray($nickNameBackEnd);

           $abookGroups->removeFromGroup($userData, $groupName);

           if ($abookGroups->error){
               $message = "<P ALIGN=center><STRONG>".$abookGroups->error."</STRONG></P>";
           } else{
               bindtextdomain('abook_group', SM_PATH . 'plugins/abook_group/locale');
               textdomain('abook_group');
               $message =  "<P ALIGN=center><STRONG>" . _("Remove Successful") . "</STRONG></P>";
               bindtextdomain('squirrelmail', SM_PATH . 'locale');
               textdomain('squirrelmail');
           }
       }	


}

$myGroupMembers = $abookGroups->list_groupMembers($groupName);

?>

<table width="95%" align=center cellpadding=2 cellspacing=2 border=0>
<tr><td bgcolor="<?php echo $color[0] ?>">
   <center>
        <b> 
        <?php echo $groupName ?>&nbsp;
        <?php 
         bindtextdomain('abook_group', SM_PATH . 'plugins/abook_group/locale');
         textdomain('abook_group');
         echo _("Members");
         bindtextdomain('squirrelmail', SM_PATH . 'locale');
         textdomain('squirrelmail');
        ?>
        </b> 
      </center>
</td></tr></table>
<form name="form" method="post" action="<?php echo $PHP_SELF ?>">
  <p align="center"><b>
    <?php echo $message ?>
    </b></p>
<?php if(count($myGroupMembers)>0) { ?>	
  <table width="95%" align="center">
    <?php

    for ($j=0;$j<count($myGroupMembers);$j++){
        $name = $myGroupMembers[$j]['name'];
		$nickName = $myGroupMembers[$j]['nickname'];
		$backendName = $abook->backends[$myGroupMembers[$j]['backend']]->sname;
#$backendName = addslashes ($backendName);
?>		
<tr><td>

        <input type="checkbox" name="nickNameBackEnd[]" value="<?php echo $nickName.",".$backendName ?>">
      
    </td><td><?php echo $name ?></td></tr>		
<?php
    }
?>
</table>
<?php
} //end count > 0
else{
        bindtextdomain('abook_group', SM_PATH . 'plugins/abook_group/locale');
        textdomain('abook_group');
	echo "<p><center>"._("You Currently Do Not Have Any Members In This Group")."</center></p>";
        bindtextdomain('squirrelmail', SM_PATH . 'locale');
        textdomain('squirrelmail');
}
?>

  <p align="center">
    <input type="hidden" name="groupName" value="<?php echo $groupName ?>">
    <input type="submit" name="remove" value="
       <?php 
        bindtextdomain('abook_group', SM_PATH . 'plugins/abook_group/locale');
        textdomain('abook_group');
        echo _("Remove");
        bindtextdomain('squirrelmail', SM_PATH . 'locale');
        textdomain('squirrelmail');
       ?>
    ">
  </p>
</form>
<?php display_abook_group_footer(); ?>
</body></html>
