<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@advcs.org
    Home Site ...... http://www.advcs.org/
    Program ........ Download All
    Version ........ 0.1
    Purpose ........ Allows you to download all your attachments at once in a zip

*******************************************************************************/

   if (!defined('SM_PATH'))
      define('SM_PATH','../../');
   include_once(SM_PATH . 'include/validate.php');
   include_once(SM_PATH . 'functions/imap.php');
   include_once(SM_PATH . 'plugins/download_all/includes/zip.php');

   sqgetGlobalVar('username', $username);
   sqgetGlobalVar('key', $key,SQ_COOKIE);
   sqgetGlobalVar('onetimepad', $onetimepad);
   sqgetGlobalVar('mailbox', $mailbox);
   sqgetGlobalVar('startMessage', $startMessage);
   sqgetGlobalVar('passed_id', $passed_id);

   $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
   sqimap_mailbox_select($imapConnection, $mailbox);

   if (!ini_get("safe_mode"))
      set_time_limit(0);

   $zipfile = new zipfile();

   $message2 = sqimap_get_message($imapConnection, $passed_id, $mailbox);
   $count = count($message2->entities);
   if ($count == 0)
      $count = 1;
   for ($b = 2; $b < $count + 1; $b++) {
      $message = $message2->getEntity($b);
      $header = $message->rfc822_header;
      $body = mime_fetch_body ($imapConnection, $passed_id, $b);
      $body = decodeBody($body, $message->header->encoding);
      $filename = $message->header->getParameter('filename');
      if (!$filename)
         $filename = $message->header->getParameter('name');
      $filename = archive_replace_str($filename);
      $zipfile -> addFile($body, $filename);
   }

   $filename = archive_replace_str($mailbox, '-');
   sendheader($filename);
   header("Content-Length: ".strlen($zipfile -> file()));
   echo $zipfile -> file();
   exit;

function archive_replace_str($temp, $temp2 = ' ') {
   $temp = str_replace(chr(92), $temp2, $temp);
   $temp = str_replace('/', $temp2, $temp);
   $temp = str_replace(':', $temp2, $temp);
   $temp = str_replace('>', $temp2, $temp);
   $temp = str_replace('<', $temp2, $temp);
   $temp = str_replace('|', $temp2, $temp);
   $temp = str_replace('?', $temp2, $temp);
   $temp = str_replace('*', $temp2, $temp);
   $temp = str_replace(chr(34), $temp2, $temp);
   return $temp;
}

?>