<?php
/**
 * AmavisNewSQL - AmavisNew+SQL+SpamAssassin+Quarantine plugin for SquirrelMail
 *
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @author Jared Watkins 2003 <jared@watkins.net>
 * @package amavisnewsql
 * $Id: setup.php, v
*/

/**
 * Required for SM versioning
 */
function amavisnewsql_version()
{
  return '0.7.3';
}

include(SM_PATH.'plugins/amavisnewsql/config.php');


function squirrelmail_plugin_init_amavisnewsql () {
  include(SM_PATH.'plugins/amavisnewsql/config.php');

  global $squirrelmail_plugin_hooks;

  $squirrelmail_plugin_hooks['optpage_register_block']['amavisnewsql'] = 'amavisnewsql_optpage_register_block';

  $squirrelmail_plugin_hooks['read_body_header_right']['amavisnewsql'] = 'amavisnewsql_address_add';



  if($CONFIG["use_quarantine"]) {
     $squirrelmail_plugin_hooks['menuline']['amavisnewsql'] = 'amavisnewsql_spam_quarantine';
     #$squirrelmail_plugin_hooks['left_main_after']['amavisnewsql'] = 'amavisnewsql_spam_quarantine';
  }

}


function amavisnewsql_address_add() {  // Borrowed from address_add plugin
    global $message;
    if (!$message || !isset($message)) return;

    $header = $message->rfc822_header;
    $decodedfrom = $header->getAddr_s('from');

    $IP_RegExp_Match = '\\[?[0-9]{1,3}(\\.[0-9]{1,3}){3}\\]?';
    $Host_RegExp_Match = '(' . $IP_RegExp_Match . '|[0-9a-z]([-.]?[0-9a-z])*\\.[a-z][a-z]+)';
    $Email_RegExp_Match = '[0-9a-z]([-_.+|]?[_0-9a-z|])*(%' . $Host_RegExp_Match . ')?@' . $Host_RegExp_Match;
    $regs = array();
    while (eregi($Email_RegExp_Match, $decodedfrom, $regs)) {
       $decodedfrom = substr(strstr($decodedfrom, $regs[0]), strlen($regs[0]));
       $fromaddress = urlencode($regs[0]);
    }

    echo " | ";
    displayInternalLink ("plugins/amavisnewsql/amavisnewsql.php?action=add_edit_wb_address&WorB=W&priority=7&address=$fromaddress", _("Whitelist Sender"), 'right');


}


function amavisnewsql_optpage_register_block () {
  global $optpage_blocks;

  $optpage_blocks[] =
    array (
           'name' => _("SpamAssassin Configuration"),
           'url'  => '../plugins/amavisnewsql/amavisnewsql.php',
           'desc' => _("Here you may define your own white/black lists and customize your spam scoring rules."),
           'js'   => FALSE);
}


function amavisnewsql_spam_quarantine () {

   displayInternalLink ('plugins/amavisnewsql/quarantine.php', _("[Quarantine]"), 'right');
   #echo "<p align=center><a target=\"right\" href=\"../plugins/amavisnewsql/quarantine.php\">Quarantine</a>";

}

?>